/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RomClassWalker;
import java.io.PrintStream;

public class DumpAllRomClassLinearCommand
extends Command {
    public DumpAllRomClassLinearCommand() {
        this.addCommand("dumpallromclasslinear", "[nestingThreshold]", "cfdump all J9ROMClass using the Linear ROM Class Dumper");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length > 1) {
            throw new DDRInteractiveCommandException("This debug extension accepts none or one argument!");
        }
        long l = stringArray.length == 1 ? Long.valueOf(stringArray[0]) : 1L;
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (null == j9JavaVMPointer) {
                throw new DDRInteractiveCommandException("Unable to find the VM in core dump!");
            }
            printStream.println();
            printStream.println("!j9javavm " + j9JavaVMPointer.getHexAddress());
            printStream.println();
            ROMClassesIterator rOMClassesIterator = new ROMClassesIterator(printStream, j9JavaVMPointer.classMemorySegments());
            while (rOMClassesIterator.hasNext()) {
                J9ROMClassPointer j9ROMClassPointer = rOMClassesIterator.next();
                printStream.println("!dumpromclasslinear " + j9ROMClassPointer.getHexAddress());
                printStream.format("ROM Class '%s' at %s%n%n", J9UTF8Helper.stringValue(j9ROMClassPointer.className()), j9ROMClassPointer.getHexAddress());
                RomClassWalker romClassWalker = new RomClassWalker(j9ROMClassPointer, context);
                new LinearDumper().gatherLayoutInfo(printStream, romClassWalker, l);
                printStream.println();
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }
}

