/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.j9.SystemMonitor;
import com.ibm.j9ddr.vm29.j9.walkers.MonitorIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ContendedLoadTableEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9VMThreadHelper;
import com.ibm.j9ddr.vm29.structure.J9ContendedLoadTableEntry;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;

public class DumpContendedLoadTable
extends Command {
    private static final String nl = System.getProperty("line.separator");
    static HashMap<Long, String> loadingStatusValues;

    public DumpContendedLoadTable() {
        this.addCommand("dumpcontload", "cmd|help", "dump contended class load table");
        loadingStatusValues = new HashMap(5);
        loadingStatusValues.put(J9ContendedLoadTableEntry.CLASSLOADING_DONT_CARE, "dont_care");
        loadingStatusValues.put(J9ContendedLoadTableEntry.CLASSLOADING_DUMMY, "dummy");
        loadingStatusValues.put(J9ContendedLoadTableEntry.CLASSLOADING_LOAD_FAILED, "failed");
        loadingStatusValues.put(J9ContendedLoadTableEntry.CLASSLOADING_LOAD_IN_PROGRESS, "in-progress");
        loadingStatusValues.put(J9ContendedLoadTableEntry.CLASSLOADING_LOAD_SUCCEEDED, "succeeded");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        block10: {
            Object object;
            if (0 != stringArray.length && ((String)(object = stringArray[0])).equalsIgnoreCase("help")) {
                this.help(printStream);
                return;
            }
            try {
                object = J9RASHelper.getVM(DataType.getJ9RASPointer());
                J9HashTablePointer j9HashTablePointer = ((J9JavaVMPointer)object).contendedLoadTable();
                J9PoolPointer j9PoolPointer = j9HashTablePointer.listNodePool();
                Pool<J9ContendedLoadTableEntryPointer> pool = Pool.fromJ9Pool(j9PoolPointer, J9ContendedLoadTableEntryPointer.class);
                SlotIterator<J9ContendedLoadTableEntryPointer> slotIterator = pool.iterator();
                if (slotIterator.hasNext()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    printStream.println("Active class loads:");
                    while (slotIterator.hasNext()) {
                        object4 = (J9ContendedLoadTableEntryPointer)slotIterator.next();
                        object3 = loadingStatusValues.get(((J9ContendedLoadTableEntryPointer)object4).status().longValue());
                        if (null == object3) {
                            object3 = "ILLEGAL VALUE: " + ((J9ContendedLoadTableEntryPointer)object4).status();
                        }
                        object2 = ((J9ContendedLoadTableEntryPointer)object4).thread();
                        printStream.format("\tClassname: %s;%n\t\tLoader:  %s; Loading thread: %s %s%n\t\tStatus: %s; Table entry hash 0x%X%n", ((J9ContendedLoadTableEntryPointer)object4).className().getCStringAtOffset(0L, ((J9ContendedLoadTableEntryPointer)object4).classNameLength().longValue()), ((J9ContendedLoadTableEntryPointer)object4).classLoader().formatShortInteractive(), J9VMThreadHelper.getName((J9VMThreadPointer)object2), ((AbstractPointer)object2).formatShortInteractive(), object3, ((J9ContendedLoadTableEntryPointer)object4).hashValue().longValue());
                    }
                    object4 = new MonitorIterator((J9JavaVMPointer)object);
                    while (((MonitorIterator)object4).hasNext()) {
                        String string2;
                        object3 = ((MonitorIterator)object4).next();
                        if (!(object3 instanceof J9ThreadMonitorPointer) || !(string2 = ((SystemMonitor)(object2 = SystemMonitor.fromJ9ThreadMonitor((J9ThreadMonitorPointer)object3))).getName()).matches(".*VM class table.*")) continue;
                        List<J9ThreadPointer> list = ((SystemMonitor)object2).getWaitingThreads();
                        if (!list.isEmpty()) {
                            printStream.print("Waiting threads:\n");
                            for (J9ThreadPointer j9ThreadPointer : list) {
                                J9VMThreadPointer j9VMThreadPointer = J9ThreadHelper.getVMThread(j9ThreadPointer);
                                if (j9VMThreadPointer.notNull()) {
                                    printStream.format("\t%s\t%s%n", j9VMThreadPointer.formatShortInteractive(), J9VMThreadHelper.getName(j9VMThreadPointer));
                                    continue;
                                }
                                printStream.format("\t%s\t%s%n", j9ThreadPointer.formatShortInteractive(), "[osthread]");
                            }
                        }
                        break block10;
                    }
                    break block10;
                }
                printStream.println("No active class loads");
            }
            catch (CorruptDataException corruptDataException) {
                throw new DDRInteractiveCommandException(corruptDataException);
            }
        }
    }

    private void help(PrintStream printStream) {
        printStream.append("!dumpcontload       -- the contents of the VM contended class load table");
        printStream.append(nl);
    }
}

