/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RamClassWalker;
import java.io.PrintStream;

public class DumpRamClassLinearCommand
extends Command {
    public DumpRamClassLinearCommand() {
        this.addCommand("dumpramclasslinear", "<addr>[,n]", "cfdump the specified J9RAMClass using Linear RAM Class Dumper");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            throw new DDRInteractiveCommandException("This debug extension needs an address argument !dumpramclasslinear <addr>[,n]");
        }
        String[] stringArray2 = stringArray[0].split(",");
        long l = Long.decode(stringArray2[0]);
        long l2 = stringArray2.length > 1 ? Long.decode(stringArray2[1]) : 1L;
        J9ClassPointer j9ClassPointer = J9ClassPointer.cast(l);
        try {
            printStream.format("RAM Class '%s' at %s%n", J9UTF8Helper.stringValue(j9ClassPointer.romClass().className()), j9ClassPointer.getHexAddress());
            RamClassWalker ramClassWalker = new RamClassWalker(j9ClassPointer, context);
            new LinearDumper().gatherLayoutInfo(printStream, ramClassWalker, l2);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

