/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.J9ROMClassAndMethod;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9BCTranslationData;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.FilteredROMMethodsIterator;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.J9BCUtil;
import java.io.PrintStream;
import java.util.Vector;

public class DumpRomMethodCommand
extends Command {
    private static final String DUMPROMMETHOD = "dumprommethod";
    private static final String COMMAND_SYNTAX = "-a <ram method addr>|-o <rom method addr>|<name>";
    private static final String COMMAND_DESCRIPTION = "dump all the rommethods corresponding to RAM method address <addr>, or to <name> (with wildcards)";
    private final long dumpFlags = J9BuildFlags.J9VM_ENV_LITTLE_ENDIAN ? J9BCTranslationData.BCT_LittleEndianOutput : J9BCTranslationData.BCT_BigEndianOutput;

    public DumpRomMethodCommand() {
        this.addCommand(DUMPROMMETHOD, COMMAND_SYNTAX, COMMAND_DESCRIPTION);
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            StructurePointer structurePointer;
            long l;
            Iterable<J9ROMClassAndMethod> iterable = null;
            if (stringArray.length < 1) {
                this.printUsage(printStream);
                return;
            }
            String string2 = stringArray[0];
            if (string2.equals("-a")) {
                if (stringArray.length != 2) {
                    this.printUsage(printStream);
                    return;
                }
                l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.J9VM_ENV_DATA64);
                structurePointer = J9MethodPointer.cast(l);
                if (structurePointer.isNull()) {
                    CommandUtils.dbgPrint(printStream, "bad ram method addr\n");
                    return;
                }
                iterable = this.romMethodIteratorFromRamMethod((J9MethodPointer)structurePointer);
            } else if (string2.equals("-o")) {
                if (stringArray.length != 2) {
                    this.printUsage(printStream);
                    return;
                }
                l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.J9VM_ENV_DATA64);
                structurePointer = J9ROMMethodPointer.cast(l);
                if (structurePointer.isNull()) {
                    CommandUtils.dbgPrint(printStream, "bad rom method addr\n");
                    return;
                }
                J9ROMMethodPointer j9ROMMethodPointer = ((J9ROMMethodPointer)structurePointer).add(1L);
                U8Pointer u8Pointer = U8Pointer.cast(j9ROMMethodPointer.getAddress());
                J9MethodPointer j9MethodPointer = J9JavaVMHelper.getMethodFromPC(J9RASHelper.getVM(DataType.getJ9RASPointer()), u8Pointer);
                iterable = this.romMethodIteratorFromRamMethod(j9MethodPointer);
            } else {
                try {
                    iterable = new FilteredROMMethodsIterator(printStream, context, string2);
                }
                catch (CorruptDataException corruptDataException) {
                    throw new DDRInteractiveCommandException(corruptDataException);
                }
            }
            for (J9ROMClassAndMethod j9ROMClassAndMethod : iterable) {
                printStream.format("Class: %s%n", J9UTF8Helper.stringValue(j9ROMClassAndMethod.romClass.className()));
                J9BCUtil.j9bcutil_dumpRomMethod(printStream, j9ROMClassAndMethod.romMethod, j9ROMClassAndMethod.romClass, this.dumpFlags, J9BCUtil.BCUtil_DumpAnnotations);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw nullPointerException;
        }
    }

    private Iterable<J9ROMClassAndMethod> romMethodIteratorFromRamMethod(J9MethodPointer j9MethodPointer) throws CorruptDataException {
        J9ClassPointer j9ClassPointer = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(j9MethodPointer);
        J9ROMMethodPointer j9ROMMethodPointer = J9MethodHelper.romMethod(j9MethodPointer);
        J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
        Vector<J9ROMClassAndMethod> vector = new Vector<J9ROMClassAndMethod>(1);
        vector.add(new J9ROMClassAndMethod(j9ROMMethodPointer, j9ROMClassPointer));
        Vector<J9ROMClassAndMethod> vector2 = vector;
        return vector2;
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("dumprommethod -a <ram method addr>|-o <rom method addr>|<name>: dump all the rommethods corresponding to RAM method address <addr>, or to <name> (with wildcards)");
        printStream.println("<name> is classname.methodname(signature.  package names are separated by '/'. Signature is optional ");
    }
}

