/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.gc.GCStringTableIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class DumpStringTableCommand
extends Command {
    public DumpStringTableCommand() {
        this.addCommand("dumpstringtable", "", "Dump content of string table");
    }

    private Set<J9ObjectPointer> getStringTableObjects() throws CorruptDataException {
        TreeSet<J9ObjectPointer> treeSet = new TreeSet<J9ObjectPointer>(new Comparator<J9ObjectPointer>(){

            @Override
            public int compare(J9ObjectPointer j9ObjectPointer, J9ObjectPointer j9ObjectPointer2) {
                if (j9ObjectPointer.getAddress() < j9ObjectPointer2.getAddress()) {
                    return -1;
                }
                if (j9ObjectPointer.getAddress() > j9ObjectPointer2.getAddress()) {
                    return 1;
                }
                return 0;
            }
        });
        GCStringTableIterator gCStringTableIterator = GCStringTableIterator.from();
        while (gCStringTableIterator.hasNext()) {
            J9ObjectPointer j9ObjectPointer = gCStringTableIterator.next();
            treeSet.add(j9ObjectPointer);
        }
        return treeSet;
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        Set<J9ObjectPointer> set = null;
        try {
            set = this.getStringTableObjects();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException.getMessage(), corruptDataException);
        }
        for (J9ObjectPointer j9ObjectPointer : set) {
            String string2 = "**CORRUPT STRING TABLE ELEMENT **";
            try {
                string2 = J9ObjectHelper.stringValue(j9ObjectPointer);
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            String string3 = j9ObjectPointer.formatShortInteractive();
            printStream.format("%s value = <%s>%n", string3, string2);
        }
        printStream.println("Table Size = " + set.size());
    }
}

