/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.MonitorTable;
import com.ibm.j9ddr.vm29.j9.MonitorTableListIterator;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.j9.SystemMonitor;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.j9.walkers.HeapWalker;
import com.ibm.j9ddr.vm29.j9.walkers.MonitorIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadLibraryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9VMThreadHelper;
import com.ibm.j9ddr.vm29.structure.J9ThreadAbstractMonitor;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.monitors.DeadlockDetector;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class MonitorsCommand
extends Command {
    public MonitorsCommand() {
        this.addCommand("monitors", "<command> | help", "Monitor related commands");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            if (stringArray.length < 1) {
                printStream.println("No subcommand specified. \"!monitors help\" for usage");
                return;
            }
            String string2 = stringArray[0];
            if (string2.equalsIgnoreCase("table")) {
                this.tableCommand(stringArray, printStream);
            } else if (string2.equalsIgnoreCase("tables")) {
                this.tablesCommand(stringArray, printStream);
            } else if (string2.equalsIgnoreCase("system")) {
                this.systemCommand(stringArray, printStream);
            } else if (string2.equalsIgnoreCase("object")) {
                this.objectCommand(stringArray, printStream);
            } else if (string2.equalsIgnoreCase("objects")) {
                this.objectsCommand(stringArray, printStream);
            } else if (string2.equalsIgnoreCase("thread")) {
                this.threadCommand(stringArray, printStream);
            } else if (string2.equalsIgnoreCase("j9thread")) {
                this.j9threadCommand(stringArray, printStream);
            } else if (string2.equalsIgnoreCase("j9vmthread")) {
                this.j9vmthreadCommand(stringArray, printStream);
            } else if (string2.equalsIgnoreCase("deadlock")) {
                this.deadlockCommand(stringArray, printStream);
            } else if (string2.equalsIgnoreCase("help")) {
                this.helpCommand(stringArray, printStream);
            } else {
                this.allCommand(stringArray, printStream);
            }
        }
        catch (Exception exception) {
            throw new DDRInteractiveCommandException(exception);
        }
    }

    private void deadlockCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        DeadlockDetector.findDeadlocks(printStream);
    }

    private void threadCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length < 2) {
            printStream.println("This command takes one address argument: \"!monitors thread <address>\"");
            return;
        }
        try {
            long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.J9VM_ENV_DATA64);
            VoidPointer voidPointer = VoidPointer.cast(l);
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
            J9ThreadLibraryPointer j9ThreadLibraryPointer = j9VMThreadPointer.osThread().library();
            J9PoolPointer j9PoolPointer = j9ThreadLibraryPointer.thread_pool();
            Pool<J9ThreadPointer> pool = Pool.fromJ9Pool(j9PoolPointer, J9ThreadPointer.class);
            SlotIterator<J9ThreadPointer> slotIterator = pool.iterator();
            J9ThreadPointer j9ThreadPointer = null;
            while (slotIterator.hasNext()) {
                j9ThreadPointer = (J9ThreadPointer)slotIterator.next();
                J9VMThreadPointer j9VMThreadPointer2 = J9ThreadHelper.getVMThread(j9ThreadPointer);
                J9ObjectPointer j9ObjectPointer = null;
                if (j9VMThreadPointer2.notNull()) {
                    j9ObjectPointer = j9VMThreadPointer2.threadObject();
                    if (null != j9ObjectPointer && j9ObjectPointer.equals(voidPointer)) {
                        printStream.println("Found java/lang/Thread @ " + voidPointer.getHexAddress());
                        this.printMonitorsForJ9VMThread(printStream, j9JavaVMPointer, j9VMThreadPointer2);
                        return;
                    }
                    if (j9VMThreadPointer2.equals(voidPointer)) {
                        printStream.println("Found j9vmthread @ " + voidPointer.getHexAddress());
                        this.printMonitorsForJ9VMThread(printStream, j9JavaVMPointer, j9VMThreadPointer2);
                        return;
                    }
                }
                if (!j9ThreadPointer.equals(voidPointer)) continue;
                printStream.println("Found j9thread @ " + voidPointer.getHexAddress());
                if (j9VMThreadPointer2.notNull()) {
                    this.printMonitorsForJ9VMThread(printStream, j9JavaVMPointer, j9VMThreadPointer2);
                }
                this.printMonitorsForJ9Thread(printStream, j9JavaVMPointer, j9ThreadPointer);
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void j9vmthreadCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length < 2) {
            printStream.println("This command takes one address argument: \"!monitors j9vmthread <address>\"");
            return;
        }
        try {
            long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.J9VM_ENV_DATA64);
            VoidPointer voidPointer = VoidPointer.cast(l);
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer j9VMThreadPointer = null;
            GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
            while (gCVMThreadListIterator.hasNext()) {
                if (!voidPointer.equals(gCVMThreadListIterator.next())) continue;
                j9VMThreadPointer = J9VMThreadPointer.cast(voidPointer);
            }
            if (null == j9VMThreadPointer) {
                throw new DDRInteractiveCommandException(String.format("Could not find any j9vmthread at address %s\n", voidPointer.getHexAddress()));
            }
            printStream.format("!j9vmthread 0x%08x\t!j9thread 0x%08x\t// %s%n", j9VMThreadPointer.getAddress(), j9VMThreadPointer.osThread().getAddress(), J9VMThreadHelper.getName(j9VMThreadPointer));
            this.printMonitorsForJ9VMThread(printStream, j9JavaVMPointer, j9VMThreadPointer);
            this.printMonitorsForJ9Thread(printStream, j9JavaVMPointer, j9VMThreadPointer.osThread());
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printMonitorsForJ9VMThread(PrintStream printStream, J9JavaVMPointer j9JavaVMPointer, J9VMThreadPointer j9VMThreadPointer) throws CorruptDataException {
        FilterOptions filterOptions = FilterOptions.defaultOption();
        MonitorIterator monitorIterator = new MonitorIterator(j9JavaVMPointer);
        while (monitorIterator.hasNext()) {
            Object object = monitorIterator.next();
            if (!(object instanceof ObjectMonitor)) continue;
            ObjectMonitor objectMonitor = (ObjectMonitor)object;
            if (j9VMThreadPointer.equals(objectMonitor.getOwner())) {
                printStream.format("Owns Object Monitor:%n\t", new Object[0]);
                this.writeObjectMonitor(filterOptions, objectMonitor, printStream);
            }
            for (J9VMThreadPointer j9VMThreadPointer2 : objectMonitor.getBlockedThreads()) {
                if (!j9VMThreadPointer2.equals(j9VMThreadPointer)) continue;
                printStream.format("Blocking on (Enter Waiter):%n\t", new Object[0]);
                this.writeObjectMonitor(filterOptions, objectMonitor, printStream);
            }
            for (J9VMThreadPointer j9VMThreadPointer2 : objectMonitor.getWaitingThreads()) {
                if (!j9VMThreadPointer2.equals(j9VMThreadPointer)) continue;
                printStream.format("Waiting on (Notify Waiter):%n\t", new Object[0]);
                this.writeObjectMonitor(filterOptions, objectMonitor, printStream);
            }
        }
    }

    private void j9threadCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length < 2) {
            printStream.println("This command takes one address argument: \"!monitors j9thread <address>\"");
            return;
        }
        try {
            long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.J9VM_ENV_DATA64);
            VoidPointer voidPointer = VoidPointer.cast(l);
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer j9VMThreadPointer = j9JavaVMPointer.mainThread();
            if (j9VMThreadPointer.isNull() || j9VMThreadPointer.osThread().isNull() || j9VMThreadPointer.osThread().library().isNull()) {
                throw new CorruptDataException("Cannot locate thread library");
            }
            J9ThreadLibraryPointer j9ThreadLibraryPointer = j9VMThreadPointer.osThread().library();
            J9PoolPointer j9PoolPointer = j9ThreadLibraryPointer.thread_pool();
            Pool<J9ThreadPointer> pool = Pool.fromJ9Pool(j9PoolPointer, J9ThreadPointer.class);
            SlotIterator<J9ThreadPointer> slotIterator = pool.iterator();
            J9ThreadPointer j9ThreadPointer = null;
            while (slotIterator.hasNext()) {
                if (!voidPointer.equals(slotIterator.next())) continue;
                j9ThreadPointer = J9ThreadPointer.cast(voidPointer);
            }
            if (null == j9ThreadPointer) {
                throw new DDRInteractiveCommandException(String.format("Could not find any j9thread at address %s\n", voidPointer.getHexAddress()));
            }
            J9VMThreadPointer j9VMThreadPointer2 = J9ThreadHelper.getVMThread(j9ThreadPointer);
            printStream.format("%s\t%s\t// %s%n", j9ThreadPointer.formatShortInteractive(), j9VMThreadPointer2.notNull() ? j9VMThreadPointer2.formatShortInteractive() : "<none>", j9VMThreadPointer2.notNull() ? J9VMThreadHelper.getName(j9VMThreadPointer2) : "[osthread]");
            this.printMonitorsForJ9Thread(printStream, j9JavaVMPointer, j9ThreadPointer);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printMonitorsForJ9Thread(PrintStream printStream, J9JavaVMPointer j9JavaVMPointer, J9ThreadPointer j9ThreadPointer) throws CorruptDataException {
        FilterOptions filterOptions = FilterOptions.defaultOption();
        MonitorIterator monitorIterator = new MonitorIterator(j9JavaVMPointer);
        while (monitorIterator.hasNext()) {
            Object object = monitorIterator.next();
            if (!(object instanceof J9ThreadMonitorPointer)) continue;
            SystemMonitor systemMonitor = SystemMonitor.fromJ9ThreadMonitor((J9ThreadMonitorPointer)object);
            List<J9ThreadPointer> list = null;
            J9ThreadPointer j9ThreadPointer2 = systemMonitor.getOwner();
            if (j9ThreadPointer2.notNull() && j9ThreadPointer2.equals(j9ThreadPointer)) {
                printStream.print("Owns System Monitor:\n\t");
                this.writeSystemMonitor(filterOptions, systemMonitor, printStream);
            }
            list = systemMonitor.getBlockedThreads();
            for (J9ThreadPointer j9ThreadPointer3 : list) {
                if (!j9ThreadPointer.equals(j9ThreadPointer3)) continue;
                printStream.print("Blocking on System Monitor (Enter Waiter):\n\t");
                this.writeSystemMonitor(filterOptions, systemMonitor, printStream);
            }
            list = systemMonitor.getWaitingThreads();
            for (J9ThreadPointer j9ThreadPointer3 : list) {
                if (!j9ThreadPointer.equals(j9ThreadPointer3)) continue;
                printStream.print("Waiting on System Monitor (Notify Waiter):\n\t");
                this.writeSystemMonitor(filterOptions, systemMonitor, printStream);
            }
        }
    }

    private void objectsCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        FilterOptions filterOptions = FilterOptions.defaultOption();
        if (stringArray.length > 1) {
            filterOptions = FilterOptions.parseOption(stringArray[1]);
        } else if (stringArray.length == 1) {
            printStream.println("No filter specified, defaulting to 'active' monitors.");
        }
        this.objectsCommand(filterOptions, printStream);
    }

    private void objectsCommand(FilterOptions filterOptions, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            HashSet<ObjectMonitor> hashSet = new HashSet<ObjectMonitor>();
            MonitorTableListIterator monitorTableListIterator = new MonitorTableListIterator();
            MonitorTable object = null;
            StringBuilder stringBuilder = new StringBuilder();
            while (monitorTableListIterator.hasNext()) {
                J9ObjectMonitorPointer j9ObjectMonitorPointer = monitorTableListIterator.next();
                MonitorTable object2 = monitorTableListIterator.currentMonitorTable();
                ObjectMonitor objectMonitor = this.tablePrintHelper(filterOptions, stringBuilder, j9ObjectMonitorPointer);
                if (null != objectMonitor) {
                    hashSet.add(objectMonitor);
                }
                if (!object2.equals(object) && stringBuilder.length() > 0) {
                    if (null != object) {
                        printStream.println();
                    }
                    printStream.println(monitorTableListIterator.currentMonitorTable().extraInfo());
                    object = object2;
                }
                printStream.append(stringBuilder);
                stringBuilder.setLength(0);
            }
            for (ObjectMonitor objectMonitor : HeapWalker.getFlatLockedMonitors()) {
                if (hashSet.contains(objectMonitor)) continue;
                this.writeObjectMonitorToBuffer(filterOptions, objectMonitor, stringBuilder);
            }
            if (stringBuilder.length() > 0) {
                printStream.append("<Flatlocked Monitors on Heap>\n");
                printStream.append(stringBuilder);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void systemCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        FilterOptions filterOptions = FilterOptions.defaultOption();
        if (stringArray.length > 1) {
            filterOptions = FilterOptions.parseOption(stringArray[1]);
        }
        if (stringArray.length == 1) {
            printStream.println("No filter specified, defaulting to 'active' monitors.");
        }
        this.systemCommand(filterOptions, printStream);
    }

    private void systemCommand(FilterOptions filterOptions, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            MonitorIterator monitorIterator = new MonitorIterator(j9JavaVMPointer);
            while (monitorIterator.hasNext()) {
                Object object = monitorIterator.next();
                if (!(object instanceof J9ThreadMonitorPointer)) continue;
                SystemMonitor systemMonitor = SystemMonitor.fromJ9ThreadMonitor((J9ThreadMonitorPointer)object);
                this.writeSystemMonitor(filterOptions, systemMonitor, printStream);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private List<String> threadsListHelper(List<J9ThreadPointer> list) throws CorruptDataException {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (J9ThreadPointer j9ThreadPointer : list) {
            J9VMThreadPointer j9VMThreadPointer = J9ThreadHelper.getVMThread(j9ThreadPointer);
            if (j9VMThreadPointer.notNull()) {
                linkedList.add(String.format("%s\t%s", j9VMThreadPointer.formatShortInteractive(), J9VMThreadHelper.getName(j9VMThreadPointer)));
            } else {
                linkedList.add(String.format("%s\t%s", j9ThreadPointer.formatShortInteractive(), "[osthread]"));
            }
            j9ThreadPointer = j9ThreadPointer.next();
        }
        return linkedList;
    }

    private ObjectMonitor tablePrintHelper(FilterOptions filterOptions, StringBuilder stringBuilder, J9ObjectMonitorPointer j9ObjectMonitorPointer) throws DDRInteractiveCommandException {
        try {
            J9ObjectPointer j9ObjectPointer;
            ObjectMonitor objectMonitor;
            J9ThreadMonitorPointer j9ThreadMonitorPointer = j9ObjectMonitorPointer.monitor();
            J9ThreadAbstractMonitorPointer j9ThreadAbstractMonitorPointer = J9ThreadAbstractMonitorPointer.cast(j9ThreadMonitorPointer);
            if (j9ThreadAbstractMonitorPointer.flags().allBitsIn(J9ThreadAbstractMonitor.J9THREAD_MONITOR_OBJECT) && !j9ThreadAbstractMonitorPointer.userData().eq(0L) && null != (objectMonitor = ObjectAccessBarrier.getMonitor(j9ObjectPointer = J9ObjectPointer.cast(j9ThreadAbstractMonitorPointer.userData())))) {
                this.writeObjectMonitorToBuffer(filterOptions, objectMonitor, stringBuilder);
                return objectMonitor;
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
        return null;
    }

    private void tableCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        FilterOptions filterOptions = FilterOptions.defaultOption();
        if (stringArray.length > 2) {
            filterOptions = FilterOptions.parseOption(stringArray[2]);
        } else if (stringArray.length == 2) {
            printStream.println("No filter specified, defaulting to 'active' monitors.");
        } else if (stringArray.length < 2) {
            printStream.println("This command takes one address argument: \"!monitors table <address>\"");
            return;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.J9VM_ENV_DATA64);
            VoidPointer voidPointer = VoidPointer.cast(l);
            MonitorTableListIterator monitorTableListIterator = new MonitorTableListIterator();
            boolean bl = false;
            while (monitorTableListIterator.hasNext()) {
                J9ObjectMonitorPointer j9ObjectMonitorPointer = monitorTableListIterator.next();
                MonitorTable monitorTable = monitorTableListIterator.currentMonitorTable();
                if (!monitorTable.getMonitorTableListEntryPointer().equals(voidPointer)) continue;
                this.tablePrintHelper(filterOptions, stringBuilder, j9ObjectMonitorPointer);
                bl = true;
            }
            printStream.append(stringBuilder);
            if (!bl) {
                printStream.append(String.format("Could not find any J9MonitorTableListEntryPointer at address %s\n", voidPointer.getHexAddress()));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void tablesCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            MonitorTableListIterator monitorTableListIterator = new MonitorTableListIterator();
            MonitorTable monitorTable = null;
            while (monitorTableListIterator.hasNext()) {
                MonitorTable monitorTable2 = monitorTableListIterator.currentMonitorTable();
                if (!monitorTable2.equals(monitorTable)) {
                    printStream.println(monitorTableListIterator.currentMonitorTable().extraInfo());
                }
                monitorTable = monitorTable2;
                monitorTableListIterator.next();
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void objectCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        FilterOptions filterOptions = FilterOptions.defaultOption();
        try {
            J9ObjectPointer j9ObjectPointer = null;
            if (stringArray.length < 2) {
                printStream.println("This command takes one address \"!monitors object <J9Object address>\"");
                return;
            }
            long l = Long.decode(stringArray[1]);
            j9ObjectPointer = J9ObjectPointer.cast(l);
            ObjectMonitor objectMonitor = ObjectMonitor.fromJ9Object(j9ObjectPointer);
            if (null == objectMonitor) {
                printStream.printf("No corresponding monitor was found for %s\n", j9ObjectPointer.getHexAddress());
            } else {
                this.writeObjectMonitor(filterOptions, objectMonitor, printStream);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void writeObjectMonitor(FilterOptions filterOptions, ObjectMonitor objectMonitor, PrintStream printStream) throws CorruptDataException {
        StringBuilder stringBuilder = new StringBuilder();
        this.writeObjectMonitorToBuffer(filterOptions, objectMonitor, stringBuilder);
        printStream.print(stringBuilder.toString());
    }

    private void writeObjectMonitorToBuffer(FilterOptions filterOptions, ObjectMonitor objectMonitor, StringBuilder stringBuilder) throws CorruptDataException {
        if (filterOptions.shouldPrint(objectMonitor)) {
            J9VMThreadPointer j9VMThreadPointer;
            stringBuilder.append(String.format("Object monitor for %s\t\n", objectMonitor.getObject().formatShortInteractive()));
            if (objectMonitor.isInflated()) {
                stringBuilder.append("\tInflated\n");
            } else if (objectMonitor.isContended()) {
                stringBuilder.append("\tContended Flatlocked\n");
            } else if (objectMonitor.getLockword().isNull()) {
                stringBuilder.append("\tDeflated\n");
            } else {
                stringBuilder.append("\tFlatlocked\n");
            }
            J9ObjectMonitorPointer j9ObjectMonitorPointer = objectMonitor.getJ9ObjectMonitorPointer();
            if (j9ObjectMonitorPointer.notNull()) {
                stringBuilder.append(String.format("\t%s   %s\n", j9ObjectMonitorPointer.formatShortInteractive(), j9ObjectMonitorPointer.monitor().formatShortInteractive()));
            }
            if ((j9VMThreadPointer = objectMonitor.getOwner()).notNull()) {
                stringBuilder.append(String.format("\tOwner:\t%s\t%s\n", j9VMThreadPointer.formatShortInteractive(), J9VMThreadHelper.getName(j9VMThreadPointer)));
            }
            if (!objectMonitor.getBlockedThreads().isEmpty()) {
                stringBuilder.append(String.format("\t%s\t\n", "Blocking (Enter Waiter):"));
                for (J9VMThreadPointer j9VMThreadPointer2 : objectMonitor.getBlockedThreads()) {
                    stringBuilder.append(String.format("\t\t%s\t%s\n", j9VMThreadPointer2.formatShortInteractive(), J9VMThreadHelper.getName(j9VMThreadPointer2)));
                }
            }
            if (!objectMonitor.getWaitingThreads().isEmpty()) {
                stringBuilder.append(String.format("\t%s\t\n", "Waiting (Notify Waiter):"));
                for (J9VMThreadPointer j9VMThreadPointer2 : objectMonitor.getWaitingThreads()) {
                    stringBuilder.append(String.format("\t\t%s\t%s\n", j9VMThreadPointer2.formatShortInteractive(), J9VMThreadHelper.getName(j9VMThreadPointer2)));
                }
            }
            stringBuilder.append(nl);
        }
    }

    private void writeSystemMonitor(FilterOptions filterOptions, SystemMonitor systemMonitor, PrintStream printStream) throws CorruptDataException {
        StringBuilder stringBuilder = new StringBuilder();
        this.writeSystemMonitorToBuffer(filterOptions, systemMonitor, stringBuilder);
        printStream.print(stringBuilder.toString());
    }

    private void writeSystemMonitorToBuffer(FilterOptions filterOptions, SystemMonitor systemMonitor, StringBuilder stringBuilder) throws CorruptDataException {
        if (filterOptions.shouldPrint(systemMonitor)) {
            Object object;
            Object object2;
            List<String> list;
            stringBuilder.append(String.format("%s\t%s\n", systemMonitor.getRawMonitor().formatShortInteractive(), systemMonitor.getName()));
            J9ThreadPointer j9ThreadPointer = systemMonitor.getOwner();
            if (!j9ThreadPointer.isNull()) {
                stringBuilder.append(String.format("\tOwner:\t%s\n", j9ThreadPointer.formatShortInteractive()));
            }
            if (!(list = this.threadsListHelper(systemMonitor.getBlockedThreads())).isEmpty()) {
                stringBuilder.append("\tBlocking (Enter Waiter):\n");
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    stringBuilder.append(String.format("\t\t%s\n", object));
                }
            }
            if (!(object2 = this.threadsListHelper(systemMonitor.getWaitingThreads())).isEmpty()) {
                stringBuilder.append("\tWaiting (Notify Waiter):\n");
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    stringBuilder.append(String.format("\t\t%s\n", string));
                }
            }
        }
    }

    private void allCommand(String[] stringArray, PrintStream printStream) throws DDRInteractiveCommandException {
        FilterOptions filterOptions = FilterOptions.defaultOption();
        if (stringArray.length > 0) {
            filterOptions = FilterOptions.parseOption(stringArray[0]);
        }
        printStream.println("----------------");
        printStream.println("Object Monitors:");
        printStream.println("----------------");
        this.objectsCommand(filterOptions, printStream);
        printStream.println("----------------");
        printStream.println("System Monitors:");
        printStream.println("----------------");
        this.systemCommand(filterOptions, printStream);
    }

    private void helpCommand(String[] stringArray, PrintStream printStream) {
        String string = "!monitors table <address> [ owned | waiting | blocked | active | all ]\n\t- dump object monitor tables individually\n\t- see \"!monitors system\" for owned/waiting/blocked/active/all description\n\n!monitors tables\n\t- dump the object monitor table list\n\n!monitors system [ owned | waiting | blocked | active | all ]\n\t- dump system monitors, where:\n\t\towned\n\t\t\t- owned by a thread\n\t\twaiting\n\t\t\t- a thread is waiting on it\n\t\tblocked\n\t\t\t- a thread is blocked on it\n\t\tactive\n\t\t\t- any of owned, waiting, blocked\n\t\tall\n\t\t\t- any monitor\n\n!monitors object <address>\n\t- dump object monitors corresponding to the specified object (either flat locked or inflated)\n\n!monitors objects [ owned | waiting | blocked | active | all ]\n\t- dump all object monitors\n\t- see \"!monitors system\" for owned/waiting/blocked/active/all description\n\n!monitors j9thread <address>\n\t- dump all monitors that are active for a J9Thread\n\n!monitors j9vmthread <address>\n\t- dump all monitors that are active for a J9VMThread\n\n!monitors thread <address>\n\t- dump all monitors that are active for the specified J9Thread/J9VMThread/java.lang.Thread\n\n!monitors deadlock\n\t- search for deadlock conditions (supports J9Threads and J9VMThreads)\n\n!monitors [ owned | waiting | blocked | active | all ]\n\t- dump the system and flat locked or inflated object monitors\n\t- see \"!monitors system\" for owned/waiting/blocked/active/all description\n";
        printStream.print(string);
    }

    static class FilterOptions {
        boolean all;
        boolean owner;
        boolean blocked;
        boolean waiting;

        private FilterOptions() {
        }

        public static FilterOptions defaultOption() {
            FilterOptions filterOptions = new FilterOptions();
            filterOptions.owner = true;
            filterOptions.blocked = true;
            filterOptions.waiting = true;
            return filterOptions;
        }

        public static FilterOptions parseOption(String string) throws DDRInteractiveCommandException {
            FilterOptions filterOptions = new FilterOptions();
            if (string.equalsIgnoreCase("all")) {
                filterOptions.all = true;
            } else if (string.equalsIgnoreCase("active")) {
                filterOptions.owner = true;
                filterOptions.blocked = true;
                filterOptions.waiting = true;
            } else if (string.equalsIgnoreCase("blocked")) {
                filterOptions.blocked = true;
            } else if (string.equalsIgnoreCase("waiting")) {
                filterOptions.waiting = true;
            } else if (string.equalsIgnoreCase("owned")) {
                filterOptions.owner = true;
            } else {
                String string2 = "Unsupported subcommand \"" + string + "\", see \"!monitors help\" for usage.";
                throw new DDRInteractiveCommandException(string2);
            }
            return filterOptions;
        }

        public boolean shouldPrint(ObjectMonitor objectMonitor) throws CorruptDataException {
            if (this.all) {
                return true;
            }
            if (objectMonitor.getOwner().notNull() && this.owner) {
                return true;
            }
            if (!objectMonitor.getBlockedThreads().isEmpty() && this.blocked) {
                return true;
            }
            return !objectMonitor.getWaitingThreads().isEmpty() && this.waiting;
        }

        public boolean shouldPrint(SystemMonitor systemMonitor) throws CorruptDataException {
            if (this.all) {
                return true;
            }
            if (systemMonitor.getOwner().notNull() && this.owner) {
                return true;
            }
            if (!systemMonitor.getBlockedThreads().isEmpty() && this.blocked) {
                return true;
            }
            return !systemMonitor.getWaitingThreads().isEmpty() && this.waiting;
        }
    }
}

