/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import java.io.PrintStream;

public class RomClassForNameCommand
extends Command {
    public RomClassForNameCommand() {
        this.addCommand("romclassforname", "<name>", "find all the romclasses corresponding to name (with wildcards)");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            this.printUsage(printStream);
            return;
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ROMClassesIterator rOMClassesIterator = new ROMClassesIterator(printStream, j9JavaVMPointer.classMemorySegments());
            int n = 0;
            String string2 = stringArray[0];
            PatternString patternString = new PatternString(string2);
            printStream.format("Searching for ROMClasses named '%1$s' in VM=%2$s%n", string2, Long.toHexString(j9JavaVMPointer.getAddress()));
            while (rOMClassesIterator.hasNext()) {
                J9ROMClassPointer j9ROMClassPointer = rOMClassesIterator.next();
                String string3 = J9UTF8Helper.stringValue(j9ROMClassPointer.className());
                if (!patternString.isMatch(string3)) continue;
                ++n;
                String string4 = j9ROMClassPointer.getHexAddress();
                printStream.format("!j9romclass %1$s named %2$s%n", string4, string3);
            }
            printStream.format("Found %1$d ROMClass(es) named %2$s%n", n, string2);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("romclassforname <name> - find the class corresponding to name (with wildcards)");
    }
}

