/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.StringTable;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import java.io.PrintStream;

public class SearchStringTableCommand
extends Command {
    public SearchStringTableCommand() {
        this.addCommand("searchstringtable", "<address>", "Search for J9Object* in string table");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        block5: {
            try {
                if (1 == stringArray.length) {
                    J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64));
                    J9ObjectPointer j9ObjectPointer2 = StringTable.from().search(j9ObjectPointer);
                    if (j9ObjectPointer2.notNull()) {
                        String string2 = J9ObjectHelper.stringValue(j9ObjectPointer2);
                        String string3 = j9ObjectPointer2.formatShortInteractive();
                        printStream.format("%s <%s>%n", string3, string2);
                    } else {
                        printStream.println("Not found");
                    }
                    break block5;
                }
                throw new DDRInteractiveCommandException("This debug extension needs an address argument !searchstringtable <addr>");
            }
            catch (CorruptDataException corruptDataException) {
                throw new DDRInteractiveCommandException(corruptDataException);
            }
        }
    }
}

