/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckClassLoaders
extends Check {
    CheckClassLoaders() {
    }

    @Override
    public void check() {
        try {
            GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
            while (gCClassLoaderIterator.hasNext()) {
                PointerPointer pointerPointer;
                J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
                if (j9ClassLoaderPointer.gcFlags().allBitsIn(2L) || this._engine.checkSlotPool(pointerPointer = j9ClassLoaderPointer.classLoaderObjectEA(), VoidPointer.cast(j9ClassLoaderPointer)) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "CLASS LOADERS";
    }

    @Override
    public void print() {
        try {
            GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
            this.getReporter().format("<gc check: Start scan classLoaderBlocks (%s)>%n", ScanFormatter.formatPointer(this.getJavaVM().classLoaderBlocks()));
            while (gCClassLoaderIterator.hasNext()) {
                J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
                this.getReporter().format("  <classLoader (%s)>%n", ScanFormatter.formatPointer(j9ClassLoaderPointer));
                this.getReporter().format("    <flags=%d, classLoaderObject=%s>%n", j9ClassLoaderPointer.gcFlags().longValue(), ScanFormatter.formatPointer(j9ClassLoaderPointer.classLoaderObject()));
            }
            this.getReporter().format("<gc check: End scan classLoaderBlocks (%s)>%n", ScanFormatter.formatPointer(this.getJavaVM().classLoaderBlocks()));
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

