/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckVMThreadStacks
extends Check {
    CheckVMThreadStacks() {
    }

    @Override
    public void check() {
        try {
            GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
            while (gCVMThreadListIterator.hasNext()) {
                final J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
                WalkState walkState = new WalkState();
                walkState.walkThread = j9VMThreadPointer;
                walkState.flags = J9Consts.J9_STACKWALK_ITERATE_O_SLOTS | J9Consts.J9_STACKWALK_DO_NOT_SNIFF_AND_WHACK | J9Consts.J9_STACKWALK_SKIP_INLINES;
                walkState.callBacks = new BaseStackWalkerCallbacks(){

                    @Override
                    public void objectSlotWalkFunction(WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer) {
                        CheckVMThreadStacks.this._engine.checkSlotStack(pointerPointer, j9VMThreadPointer, voidPointer);
                    }
                };
                StackWalker.walkStackFrames(walkState);
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "THREAD STACKS";
    }

    @Override
    public void print() {
        try {
            GCVMThreadListIterator gCVMThreadListIterator = GCVMThreadListIterator.from();
            final ScanFormatter scanFormatter = new ScanFormatter(this, "thread stacks");
            while (gCVMThreadListIterator.hasNext()) {
                J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
                scanFormatter.section("thread slots", j9VMThreadPointer);
                WalkState walkState = new WalkState();
                walkState.walkThread = j9VMThreadPointer;
                walkState.flags = J9Consts.J9_STACKWALK_ITERATE_O_SLOTS | J9Consts.J9_STACKWALK_DO_NOT_SNIFF_AND_WHACK | J9Consts.J9_STACKWALK_SKIP_INLINES;
                walkState.callBacks = new BaseStackWalkerCallbacks(){

                    @Override
                    public void objectSlotWalkFunction(WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer) {
                        try {
                            scanFormatter.entry(pointerPointer.at(0L));
                        }
                        catch (CorruptDataException corruptDataException) {
                            // empty catch block
                        }
                    }
                };
                StackWalker.walkStackFrames(walkState);
                scanFormatter.endSection();
                scanFormatter.section("thread stack", j9VMThreadPointer);
                this.dumpStackTrace(j9VMThreadPointer);
                scanFormatter.endSection();
            }
            scanFormatter.end("thread stacks");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    private void dumpStackTrace(J9VMThreadPointer j9VMThreadPointer) {
        WalkState walkState = new WalkState();
        walkState.walkThread = j9VMThreadPointer;
        walkState.flags = J9Consts.J9_STACKWALK_VISIBLE_ONLY | J9Consts.J9_STACKWALK_INCLUDE_NATIVES | J9Consts.J9_STACKWALK_ITERATE_FRAMES;
        walkState.callBacks = new BaseStackWalkerCallbacks(){

            @Override
            public FrameCallbackResult frameWalkFunction(WalkState walkState) {
                String string = "(unknown class)";
                if (walkState.constantPool.notNull()) {
                    try {
                        string = J9ClassHelper.getName(walkState.constantPool.ramClass());
                    }
                    catch (CorruptDataException corruptDataException) {
                        // empty catch block
                    }
                }
                if (walkState.method.isNull()) {
                    CheckVMThreadStacks.this.getReporter().format("0x%08X %s (unknown method)%n", walkState.pc.getAddress(), string);
                } else if (walkState.jitInfo.isNull()) {
                    boolean bl = false;
                    U8Pointer u8Pointer = U8Pointer.NULL;
                    String string2 = "(corrupt)";
                    String string3 = "(corrupt)";
                    try {
                        J9ROMMethodPointer j9ROMMethodPointer = J9MethodHelper.romMethod(walkState.method);
                        bl = j9ROMMethodPointer.modifiers().allBitsIn(J9JavaAccessFlags.J9AccNative);
                        if (!bl) {
                            u8Pointer = J9ROMMethodHelper.bytecodes(j9ROMMethodPointer);
                        }
                        string2 = J9ROMMethodHelper.getName(j9ROMMethodPointer);
                        string3 = J9ROMMethodHelper.getSignature(j9ROMMethodPointer);
                    }
                    catch (CorruptDataException corruptDataException) {
                        // empty catch block
                    }
                    if (bl) {
                        CheckVMThreadStacks.this.getReporter().format(" NATIVE   %s.%s%s%n", string, string2, string3);
                    } else {
                        CheckVMThreadStacks.this.getReporter().format(" %08X %s.%s%s%n", walkState.pc.sub(u8Pointer).longValue(), string, string2, string3);
                    }
                } else {
                    boolean bl = walkState.inlineDepth != 0L;
                    U8Pointer u8Pointer = walkState.pc;
                    String string4 = "(corrupt)";
                    String string5 = "(corrupt)";
                    try {
                        J9ROMMethodPointer j9ROMMethodPointer = J9MethodHelper.romMethod(walkState.method);
                        string4 = J9UTF8Helper.stringValue(j9ROMMethodPointer.nameAndSignature().name());
                        string5 = J9UTF8Helper.stringValue(j9ROMMethodPointer.nameAndSignature().signature());
                        if (!bl) {
                            u8Pointer = U8Pointer.cast(u8Pointer.sub(U8Pointer.cast(walkState.method.extra())).longValue());
                        }
                    }
                    catch (CorruptDataException corruptDataException) {
                        // empty catch block
                    }
                    if (bl) {
                        CheckVMThreadStacks.this.getReporter().format(" INLINED  %s.%s%s  (@%s)%n", string, string4, string5, ScanFormatter.formatPointer(walkState.pc));
                    } else {
                        CheckVMThreadStacks.this.getReporter().format(" %08X %s.%s%s  (@%s)%n", u8Pointer.getAddress(), string, string4, string5, ScanFormatter.formatPointer(walkState.pc));
                    }
                }
                return FrameCallbackResult.KEEP_ITERATING;
            }
        };
        StackWalker.walkStackFrames(walkState);
    }
}

