/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.monitors;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.J9VMThreadPointerUtil;
import com.ibm.j9ddr.vm29.j9.ObjectMonitor;
import com.ibm.j9ddr.vm29.j9.walkers.MonitorIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm29.structure.J9AbstractThread;
import com.ibm.j9ddr.vm29.structure.J9VMThread;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.monitors.JavaDeadlockGraphNode;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.monitors.NativeDeadlockGraphNode;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.HashMap;

public class DeadlockUtils {
    public static void findThreadCycle(J9ThreadPointer structurePointer, HashMap<Integer, NativeDeadlockGraphNode> hashMap, HashMap<J9ObjectPointer, Object> hashMap2) throws CorruptDataException {
        Object object = null;
        Object object2 = null;
        do {
            StructurePointer structurePointer2;
            Object object3;
            J9VMThreadPointer j9VMThreadPointer;
            boolean bl = null != (j9VMThreadPointer = J9ThreadHelper.getVMThread(structurePointer)) && j9VMThreadPointer.notNull();
            boolean bl2 = false;
            if (bl) {
                object3 = new JavaDeadlockGraphNode();
                ((JavaDeadlockGraphNode)object3).javaThread = j9VMThreadPointer;
                structurePointer2 = null;
                J9ObjectPointer j9ObjectPointer = null;
                J9ThreadAbstractMonitorPointer j9ThreadAbstractMonitorPointer = null;
                j9ObjectPointer = j9VMThreadPointer.blockingEnterObject();
                if (null != j9ObjectPointer && j9ObjectPointer.notNull()) {
                    Object object4;
                    bl2 = true;
                    Object object5 = hashMap2.get(j9ObjectPointer);
                    if (object5 instanceof ObjectMonitor) {
                        object4 = (ObjectMonitor)object5;
                        structurePointer2 = ((ObjectMonitor)object4).getOwner();
                        j9ThreadAbstractMonitorPointer = ((ObjectMonitor)object4).getInflatedMonitor();
                    } else if (object5 instanceof J9ThreadMonitorPointer) {
                        object4 = (J9ThreadMonitorPointer)object5;
                        J9ThreadPointer j9ThreadPointer = ((J9ThreadMonitorPointer)object4).owner();
                        j9ThreadAbstractMonitorPointer = J9ThreadAbstractMonitorPointer.cast((AbstractPointer)object4);
                        if (j9ThreadPointer.notNull()) {
                            structurePointer2 = J9ThreadHelper.getVMThread(j9ThreadPointer);
                        }
                    }
                    if (null == structurePointer2 || structurePointer2.isNull() || structurePointer2.equals(j9VMThreadPointer)) {
                        bl2 = false;
                    } else {
                        ((JavaDeadlockGraphNode)object3).javaLock = j9ThreadAbstractMonitorPointer;
                        ((JavaDeadlockGraphNode)object3).lockObject = j9ObjectPointer;
                        ((JavaDeadlockGraphNode)object3).cycle = 0;
                        ((JavaDeadlockGraphNode)object3).nativeThread = j9VMThreadPointer.osThread();
                        hashMap.put(((NativeDeadlockGraphNode)object3).hashCode(), (NativeDeadlockGraphNode)object3);
                        if (null != object2) {
                            ((NativeDeadlockGraphNode)object2).next = object3;
                        }
                        object2 = object3;
                        ((NativeDeadlockGraphNode)object2).next = hashMap.get(((J9VMThreadPointer)structurePointer2).osThread().hashCode());
                        structurePointer = ((J9VMThreadPointer)structurePointer2).osThread();
                    }
                }
                object = object3;
            }
            if (!bl) {
                object = new NativeDeadlockGraphNode();
            }
            ((NativeDeadlockGraphNode)object).nativeThread = structurePointer;
            object3 = structurePointer.monitor();
            structurePointer2 = null;
            if (null == object3 || ((AbstractPointer)object3).isNull()) {
                if (!bl) {
                    return;
                }
            } else {
                ((NativeDeadlockGraphNode)object).nativeLock = object3;
                structurePointer2 = ((J9ThreadMonitorPointer)object3).owner();
            }
            if (bl2) continue;
            hashMap.put(((NativeDeadlockGraphNode)object).hashCode(), (NativeDeadlockGraphNode)object);
            if (null != object2) {
                ((NativeDeadlockGraphNode)object2).next = object;
            }
            if (null == structurePointer2 || structurePointer2.isNull() || structurePointer2.equals(structurePointer)) {
                return;
            }
            object2 = object;
            ((NativeDeadlockGraphNode)object2).next = hashMap.get(structurePointer2.hashCode());
            structurePointer = structurePointer2;
        } while (null == ((NativeDeadlockGraphNode)object2).next);
    }

    public static void writeDeadlockNode(NativeDeadlockGraphNode nativeDeadlockGraphNode, boolean bl, HashMap<J9ObjectPointer, Object> hashMap, PrintStream printStream) throws CorruptDataException {
        printStream.println(nativeDeadlockGraphNode.toString());
        String string = DeadlockUtils.getThreadStateDescription(nativeDeadlockGraphNode);
        if (bl) {
            printStream.println("\tis " + string);
        } else {
            printStream.println("\twhich is " + string);
        }
        if (nativeDeadlockGraphNode instanceof JavaDeadlockGraphNode) {
            DeadlockUtils.writeJavaDeadlockNode((JavaDeadlockGraphNode)nativeDeadlockGraphNode, bl, hashMap, printStream);
        } else {
            DeadlockUtils.writeNativeDeadlockNode(nativeDeadlockGraphNode, bl, hashMap, printStream);
        }
    }

    private static String getThreadStateDescription(NativeDeadlockGraphNode nativeDeadlockGraphNode) throws CorruptDataException {
        String string = "unknown state for:";
        if (nativeDeadlockGraphNode instanceof JavaDeadlockGraphNode) {
            JavaDeadlockGraphNode javaDeadlockGraphNode = (JavaDeadlockGraphNode)nativeDeadlockGraphNode;
            J9VMThreadPointerUtil.ThreadInfo threadInfo = J9VMThreadPointerUtil.getJ9State(javaDeadlockGraphNode.javaThread);
            UDATA uDATA = new UDATA(threadInfo.getState());
            if (uDATA.allBitsIn(J9VMThread.J9VMTHREAD_STATE_WAITING) || uDATA.allBitsIn(J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED)) {
                string = "waiting for:";
            } else if (uDATA.allBitsIn(J9VMThread.J9VMTHREAD_STATE_BLOCKED)) {
                string = "blocking on:";
            }
        } else {
            UDATA uDATA = nativeDeadlockGraphNode.nativeThread.flags();
            if (uDATA.allBitsIn(J9AbstractThread.J9THREAD_FLAG_BLOCKED)) {
                string = "blocking on:";
            } else if (uDATA.allBitsIn(J9AbstractThread.J9THREAD_FLAG_WAITING)) {
                string = "waiting for";
            }
        }
        return string;
    }

    private static void writeJavaDeadlockNode(JavaDeadlockGraphNode javaDeadlockGraphNode, boolean bl, HashMap<J9ObjectPointer, Object> hashMap, PrintStream printStream) throws CorruptDataException {
        if (null != javaDeadlockGraphNode.javaLock) {
            String string = "[system]";
            if (javaDeadlockGraphNode.javaLock.name().notNull()) {
                string = javaDeadlockGraphNode.javaLock.name().getCStringAtOffset(0L);
            }
            printStream.print("\t\t" + string);
            printStream.println(" lock (" + javaDeadlockGraphNode.javaLock.formatShortInteractive() + ")");
        } else if (null == javaDeadlockGraphNode.javaLock && null != javaDeadlockGraphNode.lockObject) {
            String string = J9ObjectHelper.getClassName(javaDeadlockGraphNode.lockObject);
            printStream.format("\t\t%s\t\"%s\"%n", javaDeadlockGraphNode.lockObject.formatShortInteractive(), string);
            ObjectMonitor objectMonitor = (ObjectMonitor)hashMap.get(javaDeadlockGraphNode.lockObject);
            J9ObjectMonitorPointer j9ObjectMonitorPointer = objectMonitor.getJ9ObjectMonitorPointer();
            if (null != j9ObjectMonitorPointer && j9ObjectMonitorPointer.notNull()) {
                printStream.format("\t\t%s%n", j9ObjectMonitorPointer.formatShortInteractive());
                printStream.format("\t\t%s%n", j9ObjectMonitorPointer.monitor().formatShortInteractive());
                printStream.format("\t\t%s%n", objectMonitor.getOwner().osThread().formatShortInteractive());
            }
        } else if (null != javaDeadlockGraphNode.nativeLock) {
            DeadlockUtils.printNativeLockHelper(javaDeadlockGraphNode.nativeLock, printStream);
        }
        printStream.println("\twhich is owned by:");
    }

    private static void writeNativeDeadlockNode(NativeDeadlockGraphNode nativeDeadlockGraphNode, boolean bl, HashMap<J9ObjectPointer, Object> hashMap, PrintStream printStream) throws CorruptDataException {
        DeadlockUtils.printNativeLockHelper(nativeDeadlockGraphNode.nativeLock, printStream);
        printStream.println("\twhich is owned by:");
    }

    private static void printNativeLockHelper(J9ThreadMonitorPointer j9ThreadMonitorPointer, PrintStream printStream) throws CorruptDataException {
        String string = "[system]";
        if (j9ThreadMonitorPointer.name().notNull()) {
            string = j9ThreadMonitorPointer.name().getCStringAtOffset(0L);
        }
        printStream.print("\t\t" + string);
        printStream.println(" lock (" + j9ThreadMonitorPointer.formatShortInteractive() + ")");
    }

    public static HashMap<J9ObjectPointer, Object> readObjectMonitors(J9JavaVMPointer j9JavaVMPointer) throws CorruptDataException {
        HashMap<J9ObjectPointer, Object> hashMap = new HashMap<J9ObjectPointer, Object>();
        MonitorIterator monitorIterator = new MonitorIterator(j9JavaVMPointer);
        while (monitorIterator.hasNext()) {
            StructurePointer structurePointer;
            Object object;
            Object object2 = monitorIterator.next();
            if (object2 instanceof ObjectMonitor) {
                object = (ObjectMonitor)object2;
                structurePointer = ((ObjectMonitor)object).getObject();
                hashMap.put((J9ObjectPointer)structurePointer, object);
                continue;
            }
            if (!(object2 instanceof J9ThreadMonitorPointer) || ((J9ThreadAbstractMonitorPointer)(structurePointer = J9ThreadAbstractMonitorPointer.cast((AbstractPointer)(object = (J9ThreadMonitorPointer)object2)))).userData().eq(0L)) continue;
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(((J9ThreadAbstractMonitorPointer)structurePointer).userData());
            hashMap.put(j9ObjectPointer, object);
        }
        return hashMap;
    }
}

