/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.ITool;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import java.io.PrintStream;

public class HelpTool
extends Tool {
    public static final String COMMAND = "help";
    public static final String HELP_DESCRIPTION = "to display command help messages";
    public static final String USAGE = "help:\tto display command help messages";
    public static final String JDMPVIEW_HELP_COMMAND = "help";
    public static final String COMMAND_FORMAT = "%-25s %-20s %s";

    @Override
    public boolean accept(String string, String[] stringArray) {
        return string.equalsIgnoreCase("help");
    }

    @Override
    public void process(String string, String[] stringArray, PrintStream printStream) throws CommandException {
        if (stringArray.length == 0) {
            this.printAllHelpMessages(printStream);
        } else {
            String string2 = stringArray[0];
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i - 1] = stringArray[i];
            }
            this.printHelpMessages(string2, stringArray2, printStream);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return "help";
    }

    @Override
    public String getArgumentDescription() {
        return "";
    }

    @Override
    public String getHelpDescription() {
        return null;
    }

    private void printAllHelpMessages(PrintStream printStream) {
        ToolsRegistry.executeJdmpviewCommand("help", printStream);
        for (ITool iTool : ToolsRegistry.getAllTools()) {
            if (iTool instanceof HelpTool) continue;
            printStream.format("%-25s %-20s %s%n", iTool.getCommandName(), iTool.getArgumentDescription(), iTool.getHelpDescription());
        }
    }

    private void printHelpMessages(String string, String[] stringArray, PrintStream printStream) {
        for (ITool stringArray2 : ToolsRegistry.getAllTools()) {
            if (stringArray2 instanceof HelpTool || !stringArray2.accept(string, stringArray)) continue;
            stringArray2.printDetailedHelp(printStream);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("help");
        stringBuffer.append(" ").append(string);
        for (String string2 : stringArray) {
            stringBuffer.append(" ").append(string2);
        }
        ToolsRegistry.executeJdmpviewCommand(stringBuffer.toString(), printStream);
    }
}

