/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.j9.gc.GCClassHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderSegmentIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import java.util.NoSuchElementException;

public class GCClassLoaderSegmentClassesIterator
extends GCIterator {
    private GCClassHeapIterator _classHeapIterator;
    private GCClassLoaderSegmentIterator _segmentIterator;
    private J9ClassPointer _nextClass;

    public static GCClassLoaderSegmentClassesIterator from(J9ClassLoaderPointer j9ClassLoaderPointer) throws CorruptDataException {
        return new GCClassLoaderSegmentClassesIterator(GCBase.getExtensions(), j9ClassLoaderPointer);
    }

    private GCClassLoaderSegmentClassesIterator(MM_GCExtensionsPointer mM_GCExtensionsPointer, J9ClassLoaderPointer j9ClassLoaderPointer) throws CorruptDataException {
        this._segmentIterator = GCClassLoaderSegmentIterator.fromJ9ClassLoader(j9ClassLoaderPointer, J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        if (this._segmentIterator.hasNext()) {
            this._classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(this._segmentIterator.next());
            this.advanceIterator();
        } else {
            this._nextClass = null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses.");
    }

    @Override
    public boolean hasNext() {
        return this._nextClass != null;
    }

    @Override
    public J9ClassPointer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        J9ClassPointer j9ClassPointer = this._nextClass;
        this.advanceIterator();
        return j9ClassPointer;
    }

    private void advanceIterator() {
        this._nextClass = null;
        while (this._nextClass == null) {
            if (this._classHeapIterator.hasNext()) {
                this._nextClass = this._classHeapIterator.next();
                continue;
            }
            if (!this._segmentIterator.hasNext()) break;
            try {
                this._classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(this._segmentIterator.next());
            }
            catch (CorruptDataException corruptDataException) {
                EventManager.raiseCorruptDataEvent("Problem locating the next class", corruptDataException, false);
            }
        }
    }
}

