/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCFinalizableObjectIterator;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckFinalizableList
extends Check {
    CheckFinalizableList() {
    }

    @Override
    public void check() {
        try {
            GCFinalizableObjectIterator gCFinalizableObjectIterator = GCFinalizableObjectIterator.from();
            while (gCFinalizableObjectIterator.hasNext()) {
                if (this._engine.checkSlotFinalizableList(gCFinalizableObjectIterator.next()) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "FINALIZABLE";
    }

    @Override
    public void print() {
        try {
            ScanFormatter scanFormatter = new ScanFormatter(this, "finalizableList");
            GCFinalizableObjectIterator gCFinalizableObjectIterator = GCFinalizableObjectIterator.from();
            int n = gCFinalizableObjectIterator.getState();
            while (gCFinalizableObjectIterator.hasNext()) {
                if (gCFinalizableObjectIterator.getState() != n) {
                    scanFormatter.endSection();
                    n = gCFinalizableObjectIterator.getState();
                    switch (n) {
                        case 1: {
                            scanFormatter.section("finalizable objects created by the system classloader");
                            break;
                        }
                        case 2: {
                            scanFormatter.section("finalizable objects created by application class loaders");
                            break;
                        }
                        case 3: {
                            scanFormatter.section("reference objects");
                        }
                    }
                }
                scanFormatter.entry(gCFinalizableObjectIterator.next());
            }
            scanFormatter.end("finalizableList");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

