/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.common;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.ImageInputStream;

public class ReaderUtil {
    private static void computeUpdatedPixels(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray, int n10) {
        boolean bl = false;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        for (int i = 0; i < n8; ++i) {
            int n14 = n7 + i * n9;
            if (n14 < n || (n14 - n) % n6 != 0) continue;
            if (n14 >= n + n2) break;
            int n15 = n3 + (n14 - n) / n6;
            if (n15 < n4) continue;
            if (n15 > n5) break;
            if (!bl) {
                n11 = n15;
                bl = true;
            } else if (n12 == -1) {
                n12 = n15;
            }
            n13 = n15;
        }
        nArray[n10] = n11;
        nArray[n10 + 2] = !bl ? 0 : n13 - n11 + 1;
        nArray[n10 + 4] = Math.max(n12 - n11, 1);
    }

    public static int[] computeUpdatedPixels(Rectangle rectangle, Point point, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int[] nArray = new int[6];
        ReaderUtil.computeUpdatedPixels(rectangle.x, rectangle.width, point.x, n, n3, n5, n7, n9, n11, nArray, 0);
        ReaderUtil.computeUpdatedPixels(rectangle.y, rectangle.height, point.y, n2, n4, n6, n8, n10, n12, nArray, 1);
        return nArray;
    }

    public static int readMultiByteInteger(ImageInputStream imageInputStream) throws IOException {
        byte by = imageInputStream.readByte();
        int n = by & 0x7F;
        while ((by & 0x80) == 128) {
            n <<= 7;
            by = imageInputStream.readByte();
            n |= by & 0x7F;
        }
        return n;
    }

    public static byte[] staggeredReadByteStream(ImageInputStream imageInputStream, int n) throws IOException {
        byte[] byArray;
        if (n < 1024000) {
            byArray = new byte[n];
            imageInputStream.readFully(byArray, 0, n);
        } else {
            Object object;
            int n2;
            int n3 = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = n; i != 0; i -= n2) {
                n2 = Math.min(i, 1024000);
                object = new byte[n2];
                imageInputStream.readFully((byte[])object, 0, n2);
                arrayList.add(object);
                n3 += n2;
            }
            byArray = new byte[n3];
            n2 = 0;
            object = arrayList.iterator();
            while (object.hasNext()) {
                byte[] byArray2 = (byte[])object.next();
                System.arraycopy((Object)byArray2, 0, (Object)byArray, n2, byArray2.length);
                n2 += byArray2.length;
            }
        }
        return byArray;
    }
}

