/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import sun.reflect.ByteVector;

class ByteVectorImpl
implements ByteVector {
    private byte[] data;
    private int pos;

    public ByteVectorImpl() {
        this(100);
    }

    public ByteVectorImpl(int n) {
        this.data = new byte[n];
        this.pos = -1;
    }

    @Override
    public int getLength() {
        return this.pos + 1;
    }

    @Override
    public byte get(int n) {
        if (n >= this.data.length) {
            this.resize(n);
            this.pos = n;
        }
        return this.data[n];
    }

    @Override
    public void put(int n, byte by) {
        if (n >= this.data.length) {
            this.resize(n);
            this.pos = n;
        }
        this.data[n] = by;
    }

    @Override
    public void add(byte by) {
        if (++this.pos >= this.data.length) {
            this.resize(this.pos);
        }
        this.data[this.pos] = by;
    }

    @Override
    public void trim() {
        if (this.pos != this.data.length - 1) {
            byte[] byArray = new byte[this.pos + 1];
            System.arraycopy((Object)this.data, 0, (Object)byArray, 0, this.pos + 1);
            this.data = byArray;
        }
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    private void resize(int n) {
        if (n <= 2 * this.data.length) {
            n = 2 * this.data.length;
        }
        byte[] byArray = new byte[n];
        System.arraycopy((Object)this.data, 0, (Object)byArray, 0, this.data.length);
        this.data = byArray;
    }
}

