/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.nio.ByteBuffer;

public class ProcessorSection {
    static final String[] timerDesc = new String[]{"Sequence number    ", "Special            ", "Pentium TSC        ", "Time (UTC)         ", "MSPR               ", "MFTB               ", "Time (UTC)         ", "J9 timer(UTC)      "};
    protected static final int BYTE = 1;
    protected static final int INT = 4;
    protected static final int LONG = 8;
    protected static final String SUM_TAB = "        ";
    private static final String[] Archs = new String[]{"Unknown", "x86", "S390", "Power", "IA64", "S390X", "AMD64", "RISCV", "AArch64"};
    private static final String[] SubTypes = new String[]{"i486", "i586", "Pentium II", "Pentium III", "Merced", "McKinley", "PowerRS", "PowerPC", "GigaProcessor", "ESA", "Pentium IV", "T-Rex", "Opteron", "RV64G", "Armv8-A"};
    private static final String[] trCounter = new String[]{"Sequence Counter", "Special", "RDTSC Timer", "AIX Timer", "MFSPR Timer", "MFTB Timer", "STCK Timer", "J9 timer"};
    TraceContext context;
    int arch;
    boolean big;
    int word;
    int procs;
    int subType;
    int counter;
    String textSummary;

    public ProcessorSection(TraceContext traceContext, ByteBuffer byteBuffer) throws IllegalArgumentException {
        this.context = traceContext;
        DataHeader dataHeader = new DataHeader(traceContext, byteBuffer, "UTPR");
        byteBuffer.position(byteBuffer.position() + 16);
        this.arch = byteBuffer.getInt();
        this.big = byteBuffer.getInt() != 0;
        this.word = byteBuffer.getInt();
        this.procs = byteBuffer.getInt();
        byteBuffer.position(byteBuffer.position() + 16);
        this.subType = byteBuffer.getInt();
        this.counter = byteBuffer.getInt();
        if (traceContext.debugStream != null) {
            traceContext.debug(this, 1, this.summary());
        }
    }

    public String toString() {
        return "Processor information";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder stringBuilder = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            stringBuilder.append("        Arch family:         ").append(Archs[this.arch]).append(System.getProperty("line.separator"));
            stringBuilder.append("        Processor Sub-type:  ").append(SubTypes[this.subType]).append(System.getProperty("line.separator"));
            stringBuilder.append("        Num Processors:      ").append(this.procs).append(System.getProperty("line.separator"));
            stringBuilder.append("        Big Endian:          ").append(this.big).append(System.getProperty("line.separator"));
            stringBuilder.append("        Word size:           ").append(this.word).append(System.getProperty("line.separator"));
            stringBuilder.append("        Using Trace Counter: ").append(trCounter[this.counter]).append(System.getProperty("line.separator"));
            this.textSummary = stringBuilder.toString();
        }
        return this.textSummary;
    }
}

