/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.showcommands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;

@DTFJPlugin(version=".*", runtime=false)
public class ShowLoggingCommand
extends BaseJdmpviewCommand {
    public ShowLoggingCommand() {
        this.addCommand("show logging", "", "shows the current logging options");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length > 0) {
            printStream.print("\"show logging\" does not take any parameters, ignoring ");
            for (String string2 : stringArray) {
                printStream.print(string2 + " ");
            }
            printStream.print("\n");
        }
        this.doCommand();
    }

    public void doCommand() {
        this.out.print("Logging is currently turned ");
        String string = (String)this.ctx.getProperties().get("set_logging");
        if (string == null) {
            this.out.println("off");
        } else {
            this.out.println(string);
        }
        string = (String)this.ctx.getProperties().get("current_logging_file");
        if (string == null) {
            this.out.println("Log file is not set");
        } else {
            this.out.println("Log file set to " + string);
        }
        this.out.print("Overwrite is currently turned ");
        string = (String)this.ctx.getProperties().get("set_logging_overwrite");
        if (string == null) {
            this.out.println("off");
        } else {
            this.out.println(string);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("displays the current values of logging settings\n\nparameters: none\n");
    }
}

