/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.javacore.parser.framework.parser.ILookAheadBuffer;
import com.ibm.dtfj.javacore.parser.framework.parser.ISectionParser;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.scanner.ScannerException;
import com.ibm.dtfj.javacore.parser.framework.tag.ILineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.ITagParser;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public abstract class SectionParserGrammar
implements ISectionParser {
    protected static final int FORCE_THROW = 1;
    protected ILookAheadBuffer fLookAheadBuffer;
    protected String fSectionName;
    protected J9TagManager fTagManager;
    protected ITagParser fTagParser;
    protected static final int DEFAULT_DEPTH = 3;
    protected boolean anyMatched = false;
    private final Vector fErrors;

    public SectionParserGrammar(String string) {
        this.fSectionName = string;
        this.fErrors = new Vector();
    }

    protected void setLookAheadBuffer(ILookAheadBuffer iLookAheadBuffer, int n) throws ParserException {
        this.fLookAheadBuffer = iLookAheadBuffer;
        try {
            this.fLookAheadBuffer.setLookAheadDepth(n);
        }
        catch (IOException iOException) {
            this.handleError(iOException, 1);
        }
        catch (ScannerException scannerException) {
            this.handleError(scannerException, 1);
        }
    }

    protected void setLookAheadBuffer(ILookAheadBuffer iLookAheadBuffer) throws ParserException {
        this.setLookAheadBuffer(iLookAheadBuffer, 3);
    }

    protected ILookAheadBuffer getLookAheadBuffer() {
        return this.fLookAheadBuffer;
    }

    protected void setTagManager(J9TagManager j9TagManager) {
        this.fTagManager = j9TagManager;
        this.fTagParser = this.fTagManager.getTagParser(this.fSectionName);
    }

    protected void handleRequiredMismatch(String string, String string2, String string3) throws ParserException {
        this.handleErrorAtLineNumber(this.getCurrentFileLineNumber(), "Expected Type: " + string + " / Actual Type: " + string2 + ": " + string3, null);
    }

    protected void handleUnknownMismatch(String string, String string2) throws ParserException {
        this.handleErrorAtLineNumber(this.getCurrentFileLineNumber(), "Unknown data -> " + string + ": " + string2, null);
    }

    protected IParserToken lookAhead(int n) throws ParserException {
        IParserToken iParserToken = null;
        try {
            iParserToken = this.fLookAheadBuffer.lookAhead(n);
        }
        catch (IOException iOException) {
            this.handleError(iOException, 1);
        }
        catch (ScannerException scannerException) {
            this.handleError(scannerException, 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.handleError(indexOutOfBoundsException, 1);
        }
        return iParserToken;
    }

    @Override
    public String getSectionName() {
        return this.fSectionName;
    }

    protected void consume() throws ParserException {
        try {
            this.fLookAheadBuffer.consume();
        }
        catch (IOException iOException) {
            this.handleError(iOException, 1);
        }
        catch (ScannerException scannerException) {
            this.handleError(scannerException, 1);
        }
    }

    protected boolean match(String string, boolean bl) throws ParserException {
        boolean bl2 = false;
        boolean bl3 = true;
        IParserToken iParserToken = null;
        String string2 = null;
        String string3 = null;
        while (bl3 && !this.fLookAheadBuffer.allConsumed() && !(bl2 = this.fLookAheadBuffer.match(string))) {
            iParserToken = this.lookAhead(1);
            if (iParserToken != null) {
                string2 = iParserToken.getType();
                string3 = iParserToken.getValue();
            }
            if (this.isValidJavaCoreTag(iParserToken)) {
                bl3 = false;
                if (!bl) continue;
                this.handleRequiredMismatch(string, string2, string3);
                continue;
            }
            this.consume();
        }
        this.anyMatched |= bl2;
        return bl2;
    }

    protected IAttributeValueMap getLineRuleResults(IParserToken iParserToken) throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        if (iParserToken != null) {
            ILineRule iLineRule = this.fTagParser.getLineRule(iParserToken.getType());
            iParserToken = this.lookAhead(1);
            if (iParserToken != null && iParserToken.getType().equals("UNPARSED")) {
                this.consume();
                if (iLineRule != null) {
                    iAttributeValueMap = iLineRule.parseLine(iParserToken.getValue(), iParserToken.getLineNumber(), iParserToken.getOffset());
                }
            }
        } else {
            this.handleError("Cannot get line rule for a null token.");
        }
        return iAttributeValueMap;
    }

    protected boolean matchRequired(String string) throws ParserException {
        return this.match(string, true);
    }

    protected boolean matchOptional(String string) throws ParserException {
        return this.match(string, false);
    }

    protected IAttributeValueMap processTagLineRequired(String string) throws ParserException {
        return this.processTagLine(string, true);
    }

    protected IAttributeValueMap processTagLineOptional(String string) throws ParserException {
        return this.processTagLine(string, false);
    }

    private IAttributeValueMap processTagLine(String string, boolean bl) throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        if (bl ? this.matchRequired(string) : this.matchOptional(string)) {
            IParserToken iParserToken = this.lookAhead(1);
            this.consume();
            iAttributeValueMap = this.getLineRuleResults(iParserToken);
        }
        return iAttributeValueMap;
    }

    protected boolean isValidSectionTag(String string) {
        return this.fTagManager.isTagInSection(string, this.fSectionName);
    }

    protected boolean isValidJavaCoreTag(IParserToken iParserToken) {
        return iParserToken != null ? this.fTagManager.isTagInSection(iParserToken.getType(), "check_all") : false;
    }

    public int getCurrentFileLineNumber() throws ParserException {
        IParserToken iParserToken;
        int n = -1;
        if (!this.fLookAheadBuffer.allConsumed() && (iParserToken = this.lookAhead(1)) != null) {
            n = iParserToken.getLineNumber();
        }
        return n;
    }

    @Override
    public Iterator getErrors() {
        return this.fErrors.iterator();
    }

    protected void handleError(String string, Exception exception) throws ParserException {
        this.handleError(string + exception.getMessage());
    }

    protected void handleError(String string) throws ParserException {
        if (string != null) {
            this.fErrors.add(string);
        }
    }

    protected void handleErrorAtLineNumber(int n, String string, Exception exception) throws ParserException {
        String string2 = "In Section " + this.getSectionName() + " at line " + n + " :: ";
        if (string != null) {
            string2 = string2 + string;
        }
        if (exception != null) {
            this.handleError(string2, exception);
        } else {
            this.handleError(string2);
        }
    }

    protected void handleError(String string, int n, int n2) throws ParserException {
        this.handleError(string);
    }

    protected void handleError(Exception exception) throws ParserException {
        this.handleError(exception.getMessage());
    }

    protected void handleError(Exception exception, int n) throws ParserException {
        if (n == 1) {
            throw new ParserException(exception);
        }
    }

    @Override
    public boolean anyMatched() {
        return this.anyMatched;
    }
}

