/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptJavaThread;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import java.util.ArrayList;
import java.util.Iterator;

public class PHDJavaMonitor
implements JavaMonitor {
    private ImagePointer id;
    private String name;
    private CorruptData name_cd;
    private JavaObject object;
    private JavaThread owner;
    private CorruptData owner_cd;
    private ArrayList<JavaThread> enterWaiters = new ArrayList();
    private ArrayList<JavaThread> notifyWaiters = new ArrayList();

    PHDJavaMonitor(ImageAddressSpace imageAddressSpace, PHDJavaRuntime pHDJavaRuntime, JavaMonitor javaMonitor) {
        PHDCorruptJavaThread pHDCorruptJavaThread;
        Object e;
        Object object;
        this.id = imageAddressSpace.getPointer(javaMonitor.getID().getAddress());
        try {
            this.name = javaMonitor.getName();
        }
        catch (CorruptDataException corruptDataException) {
            this.name_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        JavaObject javaObject = javaMonitor.getObject();
        if (javaObject != null) {
            try {
                this.object = pHDJavaRuntime.getObjectAtAddress(imageAddressSpace.getPointer(javaObject.getID().getAddress()));
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (DataUnavailable dataUnavailable) {
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }
        try {
            object = javaMonitor.getOwner();
            if (object != null) {
                this.owner = pHDJavaRuntime.getThread((JavaThread)object);
            }
        }
        catch (CorruptDataException corruptDataException) {
            this.owner_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        object = javaMonitor.getEnterWaiters();
        while (object.hasNext()) {
            e = object.next();
            if (e instanceof CorruptData) {
                pHDCorruptJavaThread = new PHDCorruptJavaThread(imageAddressSpace, (CorruptData)e);
                this.enterWaiters.add(pHDCorruptJavaThread);
                continue;
            }
            this.enterWaiters.add(pHDJavaRuntime.getThread((JavaThread)e));
        }
        object = javaMonitor.getNotifyWaiters();
        while (object.hasNext()) {
            e = object.next();
            if (e instanceof CorruptData) {
                pHDCorruptJavaThread = new PHDCorruptJavaThread(imageAddressSpace, (CorruptData)e);
                this.notifyWaiters.add(pHDCorruptJavaThread);
                continue;
            }
            this.notifyWaiters.add(pHDJavaRuntime.getThread((JavaThread)e));
        }
    }

    @Override
    public Iterator<JavaThread> getEnterWaiters() {
        return this.enterWaiters.iterator();
    }

    @Override
    public ImagePointer getID() {
        return this.id;
    }

    @Override
    public String getName() throws CorruptDataException {
        if (this.name_cd != null) {
            throw new CorruptDataException(this.name_cd);
        }
        return this.name;
    }

    @Override
    public Iterator<JavaThread> getNotifyWaiters() {
        return this.notifyWaiters.iterator();
    }

    @Override
    public JavaObject getObject() {
        return this.object;
    }

    @Override
    public JavaThread getOwner() throws CorruptDataException {
        if (this.owner_cd != null) {
            throw new CorruptDataException(this.owner_cd);
        }
        return this.owner;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.id == ((PHDJavaMonitor)object).id;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}

