/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.util;

public final class BitStream {
    private int[] bits = new int[100];
    private int wordOffset;
    private int bitOffset;
    private static final boolean dbg = false;

    void reset() {
        this.wordOffset = 0;
        this.bitOffset = 0;
    }

    public void rewind() {
        this.reset();
    }

    public void clear() {
        this.reset();
        if (this.bits.length > 262144) {
            this.bits = new int[100];
        }
        this.bits[0] = 0;
    }

    private void writeIntInWord(int n, int n2) {
        if (n2 < 32) {
            n &= (1 << n2) - 1;
        }
        if (n2 <= 0) {
            throw new Error("bad length: " + n2);
        }
        int n3 = this.bits[this.wordOffset];
        this.bits[this.wordOffset] = n3 |= n << 32 - (this.bitOffset + n2);
        this.bitOffset += n2;
    }

    public void writeLongBits(long l, int n) {
        BitStream.Assert(n < 64);
        this.writeIntBits((int)(l >> 32), n - 32);
        this.writeIntBits((int)l, 32);
    }

    public void writeIntBits(int n, int n2) {
        if (n2 > 32 || n2 < 0) {
            throw new Error("bad length: " + n2);
        }
        if (n2 < 32 - this.bitOffset) {
            this.writeIntInWord(n, n2);
        } else {
            int n3 = 32 - this.bitOffset;
            int n4 = n2 + this.bitOffset - 32;
            if (n3 > 0) {
                this.writeIntInWord(n >>> n4, n3);
            }
            if (n4 > 0) {
                this.nextWord(true);
                this.bits[this.wordOffset] = 0;
                this.writeIntInWord(n, n4);
            }
        }
    }

    public void writeIntBits(int n, int n2, int n3, int n4) {
        int n5 = this.wordOffset;
        int n6 = this.bitOffset;
        this.wordOffset = n3;
        this.bitOffset = n4;
        this.writeIntBits(n, n2);
        this.wordOffset = n5;
        this.bitOffset = n6;
    }

    public void nextWord(boolean bl) {
        ++this.wordOffset;
        if (this.wordOffset >= this.bits.length) {
            int[] nArray = new int[(this.bits.length * 3 + 1) / 2];
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        } else if (bl) {
            this.bits[this.wordOffset] = 0;
        }
        this.bitOffset = 0;
    }

    public void compact() {
        int[] nArray = new int[this.wordOffset + 1];
        System.arraycopy(this.bits, 0, nArray, 0, nArray.length);
        this.bits = nArray;
    }

    public int getOffset() {
        return this.wordOffset;
    }

    public void setOffset(int n) {
        this.wordOffset = n;
        this.bitOffset = 0;
    }

    private int readIntInWord(int n) {
        BitStream.Assert(n > 0);
        int n2 = this.bits[this.wordOffset] >> 32 - (this.bitOffset + n);
        if (n < 32) {
            n2 &= (1 << n) - 1;
        }
        this.bitOffset += n;
        return n2;
    }

    public int readIntBits(int n) {
        if (n > 32 || n <= 0) {
            throw new Error("bad length: " + n);
        }
        if (n < 32 - this.bitOffset) {
            return this.readIntInWord(n);
        }
        int n2 = 32 - this.bitOffset;
        int n3 = n + this.bitOffset - 32;
        int n4 = 0;
        if (n2 > 0) {
            n4 = this.readIntInWord(n2);
        }
        int n5 = 0;
        if (n3 > 0) {
            this.nextWord(false);
            n5 = this.readIntInWord(n3);
        }
        return n4 << n3 | n5;
    }

    public long readLongBits(int n) {
        BitStream.Assert(n < 64);
        if (n <= 32) {
            return this.readIntBits(n);
        }
        long l = this.readIntBits(n - 32);
        BitStream.Assert(l >= 0L);
        long l2 = this.readIntBits(32);
        return l << 32 | l2 & 0xFFFFFFFFL;
    }

    public int readIntBits(int n, int n2, int n3) {
        int n4 = this.wordOffset;
        int n5 = this.bitOffset;
        this.wordOffset = n2;
        this.bitOffset = n3;
        int n6 = this.readIntBits(n);
        this.wordOffset = n4;
        this.bitOffset = n5;
        return n6;
    }

    public int memoryUsage() {
        return this.bits.length * 4;
    }

    static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed");
        }
    }

    static String hex(long l) {
        return Long.toHexString(l);
    }
}

