/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.addressspace.DumpReaderAddressSpace;
import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.J9RASReader;
import com.ibm.dtfj.corereaders.MemoryRange;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressRange;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.Dump;
import com.ibm.dtfj.corereaders.zos.le.Caa;
import com.ibm.dtfj.corereaders.zos.le.CaaNotFound;
import com.ibm.dtfj.corereaders.zos.le.Dll;
import com.ibm.dtfj.corereaders.zos.le.DllFunction;
import com.ibm.dtfj.corereaders.zos.le.DllVariable;
import com.ibm.dtfj.corereaders.zos.le.DsaStackFrame;
import com.ibm.dtfj.corereaders.zos.le.Edb;
import com.ibm.dtfj.corereaders.zos.mvs.RegisterSet;
import com.ibm.dtfj.corereaders.zos.mvs.Tcb;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class NewZosDump
implements ICoreFileReader {
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static final int SHARED_MEMORY_ASID = -910042680;
    private static final int RECORD_HEADER_LEN = 64;
    private static final int RECORD_BODY_LEN = 4096;
    private static final int RECORD_LEN = 4160;
    private List _additionalFileNames = new ArrayList();
    private IAbstractAddressSpace _space;
    private ImageInputStream stream;
    private boolean _is64Bit;
    private Object _failingThread = null;
    private HashMap _javaAddressSpaces = new LinkedHashMap();
    private static Logger log = Logger.getLogger(NewZosDump.class.getName());
    private Dump _dump;
    private AddressSpace[] _zebedeeAddressSpaces;
    private boolean zebedeeInitialized;
    private J9RASReader _j9rasReader = null;

    private NewZosDump(ImageInputStream imageInputStream) {
        this.stream = imageInputStream;
        this._is64Bit = false;
        List list = this.readTDUMP();
        List list2 = null;
        for (int[] nArray : this._javaAddressSpaces.values()) {
            List list3 = this.keepMemoryRangesWithAsid(nArray, list);
            if (list2 != null) {
                list2.addAll(list3);
            } else {
                list2 = list3;
            }
            if (nArray[1] == 0) continue;
            this._is64Bit = true;
        }
        if (list2 != null) {
            MemoryRange[] memoryRangeArray = list2.toArray(new MemoryRange[list2.size()]);
            this._space = new DumpReaderAddressSpace(memoryRangeArray, new DumpReader(this.stream, this._is64Bit), false, this._is64Bit);
        }
        this._j9rasReader = new J9RASReader(this._space, this._is64Bit);
    }

    public String format(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public String format(long l) {
        return "0x" + Long.toHexString(l);
    }

    private void initializeZebedeeDump(ClosingFileReader closingFileReader) {
        if (!this.zebedeeInitialized) {
            try {
                log.fine("Building Zebedee dump from " + closingFileReader);
                String string = closingFileReader.getAbsolutePath();
                if (closingFileReader.isMVSFile()) {
                    string = string.substring(string.lastIndexOf(47) + 1);
                }
                this._dump = new Dump(string, closingFileReader, false);
                this._zebedeeAddressSpaces = this._dump.getAddressSpaces();
                this.zebedeeInitialized = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.log(Level.FINE, "Problem for Zebedee finding dump file", fileNotFoundException);
            }
        }
    }

    private void initializeZebedeeDump(ImageInputStream imageInputStream) {
        if (!this.zebedeeInitialized) {
            try {
                log.fine("Building Zebedee dump from stream");
                this._dump = new Dump("Stream", imageInputStream, false);
                this._zebedeeAddressSpaces = this._dump.getAddressSpaces();
                this.zebedeeInitialized = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.log(Level.FINE, "Problem for Zebedee finding dump file", fileNotFoundException);
            }
        }
    }

    private AddressSpace findZebedeeAddressSpace(int n) {
        AddressSpace addressSpace = null;
        if (this._zebedeeAddressSpaces != null) {
            for (int i = 0; i < this._zebedeeAddressSpaces.length; ++i) {
                if (n != this._zebedeeAddressSpaces[i].getAsid()) continue;
                addressSpace = this._zebedeeAddressSpaces[i];
                break;
            }
        }
        return addressSpace;
    }

    private Edb[] getEdbs(AddressSpace addressSpace) {
        HashMap<Long, Edb> hashMap = new HashMap<Long, Edb>();
        Tcb[] tcbArray = Tcb.getTcbs(addressSpace);
        if (tcbArray != null) {
            for (int i = 0; i < tcbArray.length; ++i) {
                try {
                    Caa caa = new Caa(tcbArray[i]);
                    Edb edb = caa.getEdb();
                    if (edb.getFirstDll() == null) continue;
                    hashMap.put(edb.address(), edb);
                    continue;
                }
                catch (CaaNotFound caaNotFound) {
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Edb[] edbArray = new Edb[hashMap.size()];
        hashMap.values().toArray(edbArray);
        return edbArray;
    }

    private List getThreads(Builder builder, Object object, AddressSpace addressSpace, Edb edb, Map map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l = -1L;
        if (null != this._j9rasReader) {
            try {
                l = this._j9rasReader.getThreadID();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AddressRange[] addressRangeArray = addressSpace.getAddressRanges();
        Tcb[] tcbArray = Tcb.getTcbs(addressSpace);
        if (tcbArray != null) {
            for (int i = 0; i < tcbArray.length; ++i) {
                try {
                    Object object2;
                    Object object3;
                    ArrayList<Object> arrayList2;
                    ArrayList<Object> arrayList3;
                    Properties properties;
                    ArrayList<Object> arrayList4;
                    Caa caa;
                    block31: {
                        RegisterSet registerSet;
                        log.fine("TCB " + this.format(tcbArray[i].address()));
                        caa = new Caa(tcbArray[i]);
                        log.fine("CAA " + this.format(caa.address()) + " " + caa.whereFound());
                        if (caa.getEdb().address() != edb.address()) {
                            log.fine("Skipping CAA as edb " + this.format(caa.getEdb().address()) + " != edb for process " + this.format(edb.address()));
                            continue;
                        }
                        try {
                            registerSet = tcbArray[i].getRegisters();
                        }
                        catch (IOException iOException) {
                            try {
                                registerSet = tcbArray[i].getRegistersFromBPXGMSTA();
                            }
                            catch (IOException iOException2) {
                                registerSet = caa.getCurrentFrame().getRegisterSet();
                            }
                        }
                        arrayList4 = new ArrayList<Object>();
                        long l2 = registerSet.getPSW();
                        String string = null;
                        switch ((int)(l2 >> 31) & 3) {
                            case 0: {
                                string = "PSW:24";
                                break;
                            }
                            case 1: {
                                string = "PSW:31";
                                break;
                            }
                            default: {
                                string = "PSW:64";
                            }
                        }
                        arrayList4.add(builder.buildRegister("PSW", l2));
                        for (int j = 0; j < 16; ++j) {
                            arrayList4.add(builder.buildRegister("R" + j, registerSet.getRegister(j)));
                        }
                        properties = new Properties();
                        properties.setProperty("TCB", this.format(caa.getTcb().address()));
                        properties.setProperty("CAA", this.format(caa.address()));
                        properties.setProperty("EDB", this.format(caa.getEdb().address()));
                        properties.setProperty(string, this.format(l2));
                        try {
                            properties.setProperty("Stack direction", caa.ceecaa_stackdirection() == 0 ? "up" : "down");
                            properties.setProperty("CAA CEL level", this.format(caa.ceecaalevel()));
                        }
                        catch (IOException iOException) {
                            log.log(Level.FINE, "Problem finding stack information", iOException);
                        }
                        try {
                            int n = tcbArray[i].space().readInt(tcbArray[i].address() + 16L);
                            properties.setProperty("Task Completion Code", this.format(n));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        arrayList3 = new ArrayList<Object>();
                        arrayList2 = new ArrayList<Object>();
                        boolean[] blArray = new boolean[addressRangeArray.length];
                        try {
                            long l3;
                            if (object3 == null) {
                                log.fine("Null current frame for CAA " + this.format(caa.address()));
                                arrayList2.add(builder.buildCorruptData(object, "Null stack frame so no stack sections with CAA", caa.address()));
                                break block31;
                            }
                            try {
                                for (object3 = caa.getCurrentFrame(); object3 != null; object3 = ((DsaStackFrame)object3).getParentFrame()) {
                                    object2 = builder.buildStackFrame(object, ((DsaStackFrame)object3).getDsaAddress(), ((DsaStackFrame)object3).getEntryPoint() + ((DsaStackFrame)object3).getEntryOffset());
                                    map.put(((DsaStackFrame)object3).getEntryPoint(), ((DsaStackFrame)object3).getEntryName());
                                    arrayList3.add(object2);
                                    l3 = ((DsaStackFrame)object3).getDsaAddress();
                                    int n = this.findRange(l3, blArray, addressRangeArray);
                                    if (n >= 0) {
                                        arrayList2.add(builder.buildStackSection(object, addressRangeArray[n].getStartAddress(), addressRangeArray[n].getStartAddress() + addressRangeArray[n].getLength()));
                                        continue;
                                    }
                                    if (n != -2) continue;
                                    log.fine("Unable to find stack section for DSA " + this.format(((DsaStackFrame)object3).getDsaAddress()));
                                }
                            }
                            catch (Error error) {
                                l3 = object3 != null ? ((DsaStackFrame)object3).getDsaAddress() : 0L;
                                log.log(Level.FINE, "Problem finding parent frame for DSA " + this.format(l3), error);
                                arrayList3.add(builder.buildCorruptData(object, "Corrupt stack frame with DSA " + error.getMessage(), l3));
                                arrayList2.add(builder.buildCorruptData(object, "Corrupt stack frame with DSA " + error.getMessage(), l3));
                            }
                        }
                        catch (Error error) {
                            log.log(Level.FINE, "Problem finding current frame for CAA " + this.format(caa.address()), error);
                            arrayList3.add(builder.buildCorruptData(object, "Corrupt stack frames with CAA " + error.getMessage(), caa.address()));
                            arrayList2.add(builder.buildCorruptData(object, "Corrupt stack frames with CAA " + error.getMessage(), caa.address()));
                        }
                    }
                    object3 = "";
                    try {
                        object3 = this.format(caa.getPThreadID());
                    }
                    catch (IOException iOException) {
                        object3 = "<unknown>";
                    }
                    log.fine("Building thread " + (String)object3 + " with " + arrayList2.size() + " sections");
                    object2 = builder.buildThread((String)object3, arrayList4.iterator(), arrayList2.iterator(), arrayList3.iterator(), properties, 0);
                    if (-1L != l && this.format(l).equals(object3)) {
                        this._failingThread = object2;
                    }
                    arrayList.add(object2);
                    continue;
                }
                catch (CaaNotFound caaNotFound) {
                    log.log(Level.FINE, "Problem finding CAA for TCB " + this.format(tcbArray[i].address()), caaNotFound);
                }
            }
        }
        return arrayList;
    }

    private Dll closestDll(Edb edb, long l) throws IOException {
        Dll dll = null;
        long l2 = Long.MAX_VALUE;
        for (Dll dll2 = edb.getFirstDll(); dll2 != null; dll2 = dll2.getNext()) {
            DllFunction[] dllFunctionArray = dll2.getFunctions();
            for (int i = 0; i < dllFunctionArray.length; ++i) {
                long l3 = Math.abs(dllFunctionArray[i].address - l);
                if (l3 >= l2) continue;
                dll = dll2;
                l2 = l3;
            }
            DllVariable[] dllVariableArray = dll2.getVariables();
            for (int i = 0; i < dllVariableArray.length; ++i) {
                long l4 = Math.abs(dllVariableArray[i].address - l);
                if (l4 >= l2) continue;
                dll = dll2;
                l2 = l4;
            }
        }
        return dll;
    }

    private List getModules(Builder builder, Object object, AddressSpace addressSpace, Edb edb, Map map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AddressRange[] addressRangeArray = addressSpace.getAddressRanges();
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            DllFunction[] dllFunctionArray;
            HashMap<DllFunction[], Dll> hashMap = new HashMap<DllFunction[], Dll>();
            Object object6 = map.keySet().iterator();
            while (object6.hasNext()) {
                dllFunctionArray = (DllFunction[])object6.next();
                long l = dllFunctionArray.longValue();
                object5 = this.closestDll(edb, l);
                hashMap.put(dllFunctionArray, (Dll)object5);
            }
            for (object6 = edb.getFirstDll(); object6 != null; object6 = ((Dll)object6).getNext()) {
                int n;
                Object object7;
                long l;
                Serializable serializable;
                int n2;
                dllFunctionArray = ((Dll)object6).getFunctions();
                DllVariable[] dllVariableArray = ((Dll)object6).getVariables();
                object4 = ((Dll)object6).getName();
                object5 = new ArrayList();
                object3 = new boolean[addressRangeArray.length];
                object2 = new boolean[addressRangeArray.length];
                for (n2 = 0; n2 < dllFunctionArray.length; ++n2) {
                    ((ArrayList)object5).add(builder.buildSymbol(object, dllFunctionArray[n2].name, dllFunctionArray[n2].address));
                    this.findRange(dllFunctionArray[n2].address, (boolean[])object3, addressRangeArray);
                }
                for (n2 = 0; n2 < dllVariableArray.length; ++n2) {
                    ((ArrayList)object5).add(builder.buildSymbol(object, dllVariableArray[n2].name, dllVariableArray[n2].address));
                    this.findRange(dllVariableArray[n2].address, (boolean[])object2, addressRangeArray);
                }
                Object object8 = map.keySet().iterator();
                while (object8.hasNext()) {
                    serializable = (Long)object8.next();
                    l = (Long)serializable;
                    object7 = (Dll)hashMap.get(serializable);
                    if (object7 == null || !((Dll)object6).getName().equals(((Dll)object7).getName()) || (n = this.findRange(l, addressRangeArray)) < 0 || object3[n] == false) continue;
                    String string = (String)map.get(serializable);
                    ((ArrayList)object5).add(builder.buildSymbol(object, string, l));
                    object8.remove();
                }
                object8 = new Properties();
                serializable = new ArrayList();
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    if (object3[i] != false) {
                        ((ArrayList)serializable).add(builder.buildModuleSection(object, ".text", addressRangeArray[i].getStartAddress(), addressRangeArray[i].getStartAddress() + addressRangeArray[i].getLength()));
                        continue;
                    }
                    if (object2[i] == false) continue;
                    ((ArrayList)serializable).add(builder.buildModuleSection(object, ".data", addressRangeArray[i].getStartAddress(), addressRangeArray[i].getStartAddress() + addressRangeArray[i].getLength()));
                }
                try {
                    l = ((Dll)object6).getLoadAddress();
                }
                catch (Error error) {
                    l = Long.MAX_VALUE;
                    for (n = 0; n < dllFunctionArray.length; ++n) {
                        l = Math.min(dllFunctionArray[n].address, l);
                    }
                    l = this.guessLoadAddress(l, addressRangeArray);
                }
                ((Properties)object8).setProperty("Load address", this.format(l));
                ((Properties)object8).setProperty("Writable Static Area address", this.format(((Dll)object6).getWsa()));
                object7 = builder.buildModule((String)object4, (Properties)object8, ((ArrayList)serializable).iterator(), ((ArrayList)object5).iterator(), l);
                arrayList.add(object7);
            }
            if (map.size() > 0) {
                long l = Long.MAX_VALUE;
                object4 = new ArrayList();
                object5 = new boolean[addressRangeArray.length];
                object3 = map.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = (Long)object3.next();
                    long l2 = (Long)object2;
                    l = Math.min(l2, l);
                    this.findRange(l2, (boolean[])object5, addressRangeArray);
                    String string = (String)map.get(object2);
                    ((ArrayList)object4).add(builder.buildSymbol(object, string, l2));
                    object3.remove();
                }
                l = this.guessLoadAddress(l, addressRangeArray);
                object3 = new Properties();
                ((Properties)object3).setProperty("Load address", this.format(l));
                object2 = new ArrayList();
                for (int i = 0; i < ((Object)object5).length; ++i) {
                    if (object5[i] == false) continue;
                    ((ArrayList)object2).add(builder.buildModuleSection(object, ".text", addressRangeArray[i].getStartAddress(), addressRangeArray[i].getStartAddress() + addressRangeArray[i].getLength()));
                }
                Object object9 = builder.buildModule("ExtraSymbolsModule", (Properties)object3, ((ArrayList)object2).iterator(), ((ArrayList)object4).iterator(), l);
                arrayList.add(object9);
            }
        }
        catch (IOException iOException) {
            log.log(Level.FINE, "Problem for Zebedee finding module information", iOException);
        }
        return arrayList;
    }

    private long guessLoadAddress(long l, AddressRange[] addressRangeArray) {
        if (l != Long.MAX_VALUE) {
            int n = this.findRange(l, addressRangeArray);
            if (n >= 0) {
                l = addressRangeArray[n].getStartAddress();
            }
        } else {
            l = 0L;
        }
        return l;
    }

    private int findRange(long l, boolean[] blArray, AddressRange[] addressRangeArray) {
        int n = this.findRange(l, addressRangeArray);
        if (n >= 0) {
            if (blArray[n]) {
                n = -1;
            } else {
                blArray[n] = true;
            }
        }
        return n;
    }

    private int findRange(long l, AddressRange[] addressRangeArray) {
        for (int i = 0; i < addressRangeArray.length; ++i) {
            if (addressRangeArray[i].getStartAddress() > l || l > addressRangeArray[i].getEndAddress()) continue;
            log.fine("Found address " + this.format(l) + " at " + this.format(addressRangeArray[i].getStartAddress()) + ":" + this.format(addressRangeArray[i].getEndAddress()));
            return i;
        }
        log.fine("Didn't find address " + this.format(l));
        return -2;
    }

    private Properties getEnvironment(Builder builder, AddressSpace addressSpace, Edb edb) {
        try {
            log.fine("Get environment for EDB = " + edb);
            Properties properties = edb.getEnvVars();
            return properties;
        }
        catch (IOException iOException) {
            log.log(Level.FINE, "Problem for Zebedee environment", iOException);
            return new Properties();
        }
    }

    private long getCreationTime() {
        long l = this._dump.getCreationDate().getTime();
        log.fine("Java time of dump:" + this.format(l) + " as date:" + new Date(l));
        return this._dump.getCreationDate().getTime();
    }

    private List keepMemoryRangesWithAsid(int[] nArray, List list) {
        ArrayList<MemoryRange> arrayList = new ArrayList<MemoryRange>();
        for (MemoryRange memoryRange : list) {
            boolean bl;
            boolean bl2 = bl = memoryRange.getVirtualAddress() + memoryRange.getSize() >= 0x100000000L;
            if (bl) {
                log.finer("Found 64-bit address range " + this.format(memoryRange.getVirtualAddress()) + ":" + this.format(memoryRange.getSize()) + " in address space " + this.format(memoryRange.getAsid()));
            }
            if (memoryRange.getAsid() == nArray[0]) {
                arrayList.add(memoryRange);
                if (bl && nArray[1] == 0) {
                    log.fine("Found 64-bit address in Java address space");
                    nArray[1] = 1;
                }
            }
            if (memoryRange.getAsid() != -910042680) continue;
            MemoryRange memoryRange2 = new MemoryRange(memoryRange, nArray[0]);
            arrayList.add(memoryRange2);
        }
        return arrayList;
    }

    private boolean bufferHasJ9RASEyeCatcher(byte[] byArray) {
        byte[] byArray2 = new byte[]{74, 57, 86, 77, 82, 65, 83, 0};
        for (int i = 0; i < byArray.length; i += 8) {
            boolean bl = true;
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray[i + j] == byArray2[j]) continue;
                bl = false;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator getAdditionalFileNames() {
        return this._additionalFileNames.iterator();
    }

    @Override
    public void extract(Builder builder) {
        builder.setOSType("z/OS");
        builder.setCPUType("s390");
        builder.setCPUSubType("");
        log.fine("Address spaces " + this._javaAddressSpaces.size());
        for (int[] nArray : this._javaAddressSpaces.values()) {
            this.buildAddressSpace(builder, nArray[0], nArray[1] != 0);
        }
        if (this._dump != null) {
            builder.setCreationTime(this.getCreationTime());
        }
    }

    private void buildAddressSpace(Builder builder, int n, boolean bl) {
        AddressSpace addressSpace;
        log.fine("Building address space " + this.format(n));
        Object object = builder.buildAddressSpace("z/OS Address Space", n);
        if (object.getClass() == Object.class) {
            addressSpace = null;
        } else {
            if (this.stream instanceof ClosingFileReader) {
                this.initializeZebedeeDump((ClosingFileReader)this.stream);
            } else {
                this.initializeZebedeeDump(this.stream);
            }
            addressSpace = this.findZebedeeAddressSpace(n);
        }
        Edb[] edbArray = addressSpace != null ? this.getEdbs(addressSpace) : new Edb[1];
        for (int i = 0; i < edbArray.length; ++i) {
            String string;
            String string2;
            Object var14_14;
            Edb edb = edbArray[i];
            Properties properties = edb == null ? new Properties() : this.getEnvironment(builder, addressSpace, edb);
            HashMap hashMap = new HashMap();
            List list = edb == null ? Collections.singletonList(builder.buildCorruptData(object, "unable to extract thread information this time!", 0L)) : this.getThreads(builder, object, addressSpace, edb, hashMap);
            List list2 = edb == null ? Collections.EMPTY_LIST : this.getModules(builder, object, addressSpace, edb, hashMap);
            Iterator iterator = list2.iterator();
            Object v0 = var14_14 = iterator.hasNext() ? iterator.next() : null;
            if (var14_14 == null) {
                builder.setExecutableUnavailable("unable to extract executable information");
            }
            if ((string2 = properties.getProperty("OPENJ9_JAVA_COMMAND_LINE", null)) == null) {
                string2 = properties.getProperty("IBM_JAVA_COMMAND_LINE", "");
            }
            String string3 = string = edb != null ? this.format(edb.address()) : this.format(n);
            if (null != this._j9rasReader) {
                try {
                    string = this.format(this._j9rasReader.getProcessID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null == this._failingThread) {
                this._failingThread = addressSpace == null ? null : list.get(0);
            }
            int n2 = 31;
            n2 = addressSpace != null ? (addressSpace.getWordLength() == 8 ? 64 : 31) : (bl ? 64 : 32);
            Object object2 = builder.buildProcess(object, string, string2, properties, this._failingThread, list.iterator(), var14_14, iterator, n2);
            log.fine("Built process " + object2);
        }
    }

    public static boolean isSupportedDump(ImageInputStream imageInputStream) throws IOException, CorruptCoreException {
        imageInputStream.seek(0L);
        int n = imageInputStream.readInt();
        if (17490 == (0xFFFF & n >> 16)) {
            throw new CorruptCoreException("This is a z/OS core file which has been corrupted by EBCDIC to ASCII conversion.  Reverse the conversion and try again.");
        }
        return n == -992349888 || n == -992349632;
    }

    public static ICoreFileReader dumpFromFile(ImageInputStream imageInputStream) throws IOException {
        block3: {
            try {
                assert (NewZosDump.isSupportedDump(imageInputStream)) : "Tried to create a core reader from an unsupported file type";
            }
            catch (CorruptCoreException corruptCoreException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"Tried to create a core reader from a corrupt core");
            }
        }
        return new NewZosDump(imageInputStream);
    }

    protected List readTDUMP() {
        log.fine("Reading address ranges");
        ArrayList<MemoryRange> arrayList = new ArrayList<MemoryRange>();
        byte[] byArray = new byte[4096];
        try {
            long l = 0L;
            while (true) {
                MemoryRange memoryRange = this.readRecord(l);
                l += 4160L;
                if (null == memoryRange || 0 == memoryRange.getAsid() || 0L == memoryRange.getVirtualAddress()) continue;
                arrayList.add(memoryRange);
                int n = memoryRange.getAsid();
                if (this._javaAddressSpaces.containsKey(n)) continue;
                this.stream.seek(memoryRange.getFileOffset());
                this.stream.readFully(byArray);
                if (!this.bufferHasJ9RASEyeCatcher(byArray)) continue;
                this._javaAddressSpaces.put(n, new int[]{n, 0});
                log.fine("Found Java asid " + this.format(n) + " at " + this.format(memoryRange.getVirtualAddress()));
            }
        }
        catch (IOException iOException) {
            log.fine("Read " + arrayList.size() + " address ranges");
            return arrayList;
        }
    }

    protected MemoryRange readRecord(long l) throws IOException {
        this.stream.seek(l);
        int n = this.stream.readInt();
        if (n != -992349888 && n != -992349632) {
            throw new IOException("Unrecognized dump record");
        }
        this.stream.seek(l + 12L);
        int n2 = this.stream.readInt();
        this.stream.seek(l + 20L);
        long l2 = n == -992349632 ? this.stream.readLong() : this.stream.readUnsignedInt();
        return new MemoryRange(l2, l + 64L, 4096L, n2);
    }

    @Override
    public IAbstractAddressSpace getAddressSpace() {
        return this._space;
    }

    @Override
    public boolean isTruncated() {
        return false;
    }

    @Override
    public void releaseResources() throws IOException {
        if (this.stream instanceof ClosingFileReader) {
            ((ClosingFileReader)this.stream).releaseResources();
        }
    }
}

