/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import jdk.crypto.jniprovider.NativeCrypto;
import sun.security.ec.ECDHKeyAgreement;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.NativeECUtil;

public final class NativeECDHKeyAgreement
extends KeyAgreementSpi {
    private static NativeCrypto nativeCrypto;
    private static final boolean nativeCryptTrace;
    private static final Map<String, Boolean> curveSupported;
    private ECPrivateKey privateKey;
    private long nativePrivateKey;
    private ECPublicKey publicKey;
    private long nativePublicKey;
    private String curve;
    private int secretLen;
    private ECDHKeyAgreement javaImplementation;

    private void init(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.privateKey = null;
        this.publicKey = null;
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of PrivateKey");
        }
        ECKey eCKey = ECKeyFactory.toECKey(key);
        if (eCKey instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey;
            this.privateKey = eCPrivateKey = (ECPrivateKey)eCKey;
            this.nativePrivateKey = NativeECUtil.getPrivateKeyNativePtr(eCPrivateKey);
            if (this.nativePrivateKey == -1L) {
                if (nativeCryptTrace) {
                    System.err.println("Init: Could not create a pointer to a native private key. Using Java implementation.");
                }
                this.initializeJavaImplementation(key);
                return;
            }
            ECParameterSpec eCParameterSpec = this.privateKey.getParams();
            this.curve = NativeECUtil.getCurveName(eCParameterSpec);
            if (this.curve != null && NativeECUtil.isCurveSupported(this.curve, eCParameterSpec)) {
                this.javaImplementation = null;
            } else {
                this.initializeJavaImplementation(key);
            }
        } else {
            boolean bl = NativeECUtil.putCurveIfAbsent("ECKeyImpl", Boolean.FALSE);
            if (bl && nativeCryptTrace) {
                System.err.println("Only ECPrivateKey is supported by the native implementation, using Java crypto implementation for key agreement.");
            }
            this.initializeJavaImplementation(key);
        }
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.init(key);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.init(key);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        ECPublicKey eCPublicKey;
        if (this.javaImplementation != null) {
            return this.javaImplementation.engineDoPhase(key, bl);
        }
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicKey != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!bl) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        this.publicKey = eCPublicKey = (ECPublicKey)key;
        this.nativePublicKey = NativeECUtil.getPublicKeyNativePtr(eCPublicKey);
        if (this.nativePublicKey == -1L) {
            if (nativeCryptTrace) {
                System.err.println("DoPhase: Could not create a pointer to a native public key. Using Java implementation.");
            }
            try {
                this.initializeJavaImplementation(this.privateKey);
                this.javaImplementation.engineDoPhase(eCPublicKey, true);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InternalError(invalidKeyException);
            }
        }
        int n = this.publicKey.getParams().getCurve().getField().getFieldSize();
        this.secretLen = n + 7 >> 3;
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.javaImplementation != null) {
            return this.javaImplementation.engineGenerateSecret();
        }
        byte[] byArray = new byte[this.secretLen];
        try {
            this.engineGenerateSecret(byArray, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new InternalError(shortBufferException);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        int n2;
        if (this.javaImplementation != null) {
            return this.javaImplementation.engineGenerateSecret(byArray, n);
        }
        if (n + this.secretLen > byArray.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (byArray.length - n) + " available");
        }
        if (this.privateKey == null || this.publicKey == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        boolean bl = NativeECUtil.putCurveIfAbsent(this.curve, Boolean.TRUE);
        if (bl && nativeCryptTrace) {
            System.err.println(this.curve + " is supported by OpenSSL, using native crypto implementation for generating secret.");
        }
        if (nativeCrypto == null) {
            nativeCrypto = NativeCrypto.getNativeCrypto();
        }
        ECPrivateKey eCPrivateKey = this.privateKey;
        synchronized (eCPrivateKey) {
            n2 = nativeCrypto.ECDeriveKey(this.nativePublicKey, this.nativePrivateKey, byArray, n, this.secretLen);
        }
        if (n2 == -1) {
            throw new ProviderException("Could not derive key");
        }
        this.publicKey = null;
        return this.secretLen;
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (string == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!string.equals("TlsPremasterSecret")) {
            throw new NoSuchAlgorithmException("Only supported for algorithm TlsPremasterSecret");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), "TlsPremasterSecret");
    }

    private void initializeJavaImplementation(Key key) throws InvalidKeyException {
        this.javaImplementation = new ECDHKeyAgreement();
        this.javaImplementation.engineInit(key, null);
    }

    static {
        nativeCryptTrace = NativeCrypto.isTraceEnabled();
        curveSupported = new ConcurrentHashMap<String, Boolean>();
    }
}

