/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DDRSymbolFinder;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.J9DDRClassLoader;
import com.ibm.j9ddr.StructureHeader;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.blobs.BlobFactory;
import com.ibm.j9ddr.blobs.IBlobFactory;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IMemoryImageInputStream;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.exceptions.CorruptStructuresException;
import com.ibm.j9ddr.exceptions.JVMNotDDREnabledException;
import com.ibm.j9ddr.exceptions.JVMNotFoundException;
import com.ibm.j9ddr.exceptions.MissingDDRStructuresException;
import com.ibm.j9ddr.exceptions.UnknownArchitectureException;
import com.ibm.j9ddr.util.WeakValueMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCacheImageInputStream;

public abstract class VMDataFactory {
    private static final String STRUCTUREFILE_PROPERTY = "com.ibm.j9ddr.structurefile";
    private static final String SEARCHEYECATCHER_PROPERTY = "com.ibm.j9ddr.searcheyecatcher";
    private static final String NOEXTRASEARCHFORNODE_PROPERTY = "com.ibm.j9ddr.noextrasearchfornode";
    public static final String J9RAS_SYMBOL = "_j9ras_";
    private static final byte[] eyecatcher = "J9VMRAS".getBytes(StandardCharsets.US_ASCII);
    private static final long integrityCheck = -6172840429334713771L;
    private static final int BIT_PATTERNS_OFFSET = 8;
    private static final int J9RAS_VERSION_OFFSET = 16;
    private static final int DDR_DATA_POINTER_OFFSET = 24;
    private static final int MINIMUM_J9RAS_MAJOR_VERSION = 2;
    private static long j9RASAddress;
    private static WeakValueMap<IProcess, List<IVMData>> vmDataCache;

    public static IVMData getVMData(IProcess iProcess) throws IOException {
        List<IVMData> list = VMDataFactory.getAllVMData(iProcess);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static synchronized List<IVMData> getAllVMData(IProcess iProcess) throws IOException {
        Object object;
        long l;
        List<IVMData> list = vmDataCache.get(iProcess);
        if (list != null) {
            return list;
        }
        ArrayList<IVMData> arrayList = new ArrayList<IVMData>();
        HashSet<Long> hashSet = new HashSet<Long>();
        j9RASAddress = 0L;
        while (hashSet.add(l = j9RASAddress + 1L)) {
            try {
                object = VMDataFactory.getStructureDataFile(iProcess, l);
                if (object == null) break;
                IVMData iVMData = VMDataFactory.getVMData(iProcess, (ImageInputStream)object);
                arrayList.add(iVMData);
                if (iVMData.getClassLoader().getHeader().getCoreVersion() != 1 && object instanceof IMemoryImageInputStream) continue;
                break;
            }
            catch (JVMNotFoundException jVMNotFoundException) {
                break;
            }
            catch (JVMNotDDREnabledException jVMNotDDREnabledException) {
                if (iProcess.getPlatform() != Platform.ZOS) continue;
                break;
            }
            catch (MissingDDRStructuresException missingDDRStructuresException) {
                if (iProcess.getPlatform() != Platform.ZOS) continue;
                break;
            }
            catch (CorruptStructuresException corruptStructuresException) {
                if (iProcess.getPlatform() != Platform.ZOS) continue;
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (arrayList.isEmpty() && System.getProperty(NOEXTRASEARCHFORNODE_PROPERTY) == null) {
            ImageInputStream imageInputStream;
            StructureHeader structureHeader;
            try {
                structureHeader = VMDataFactory.findNodeVersion(iProcess);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception2) {
                throw new IOException(exception2);
            }
            if (structureHeader != null && (imageInputStream = VMDataFactory.getBlobFromLibrary(iProcess, structureHeader)) != null) {
                object = VMDataFactory.getVMData(iProcess, imageInputStream);
                arrayList.add((IVMData)object);
            }
        }
        vmDataCache.put(iProcess, arrayList);
        return arrayList;
    }

    private static IVMData getVMData(IProcess iProcess, ImageInputStream imageInputStream) throws IOException {
        final StructureReader structureReader = new StructureReader(imageInputStream);
        J9DDRClassLoader j9DDRClassLoader = AccessController.doPrivileged(new PrivilegedAction<J9DDRClassLoader>(){

            @Override
            public J9DDRClassLoader run() {
                return new J9DDRClassLoader(structureReader, VMDataFactory.class.getClassLoader());
            }
        });
        try {
            IVMData iVMData = j9DDRClassLoader.getIVMData(iProcess, j9RASAddress);
            Class<?> clazz = j9DDRClassLoader.loadClassRelativeToStream("j9.DataType", false);
            Method method = clazz.getDeclaredMethod("init", IProcess.class, StructureReader.class);
            method.invoke(null, iProcess, structureReader);
            String string = structureReader.getPackageName(StructureReader.PackageNameType.POINTER_PACKAGE_DOT_NAME);
            Class<?> clazz2 = j9DDRClassLoader.loadClass(string + ".J9RASPointer");
            Method method2 = clazz2.getDeclaredMethod("cast", Long.TYPE);
            Object object = method2.invoke(null, j9RASAddress);
            Method method3 = clazz.getDeclaredMethod("setJ9RASPointer", object.getClass());
            method3.invoke((Object)iVMData, object);
            VMDataFactory.addFragments(clazz2, object, structureReader, iVMData);
            if (!Boolean.FALSE.toString().equals(System.getProperty("com.ibm.j9ddr.symbols.from.pointers"))) {
                DDRSymbolFinder.addSymbols(iProcess, j9RASAddress, structureReader);
            }
            return iVMData;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, classNotFoundException);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", classNotFoundException.getMessage()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, noSuchMethodException);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", noSuchMethodException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, illegalAccessException);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", illegalAccessException.getMessage()));
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, invocationTargetException);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", invocationTargetException.getMessage()));
        }
        catch (InstantiationException instantiationException) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, instantiationException);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", instantiationException.getMessage()));
        }
    }

    private static void addFragments(Class<?> clazz, Object object, StructureReader structureReader, IVMData iVMData) {
        try {
            InputStream inputStream = clazz.getResourceAsStream("/fragments/fragments.properties");
            if (inputStream == null) {
                Logger logger = Logger.getLogger("j9ddr.structure_reader");
                logger.log(Level.FINE, "Failed to find fragments property file");
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            Method method = clazz.getDeclaredMethod("buildID", null);
            Object object2 = method.invoke(object, (Object[])null);
            method = object2.getClass().getMethod("getHexValue", null);
            Object object3 = method.invoke(object2, (Object[])null);
            String string = object3.toString();
            if (string.length() < 8) {
                return;
            }
            String string2 = string.substring(string.length() - 8);
            String string3 = iVMData.getVersion() + "-" + string;
            if (VMDataFactory.hasFragmentBeenLoaded(clazz, properties, structureReader, string3)) {
                return;
            }
            string3 = iVMData.getVersion() + "-" + string2;
            if (VMDataFactory.hasFragmentBeenLoaded(clazz, properties, structureReader, string3)) {
                return;
            }
        }
        catch (Exception exception2) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, "Failed to process blob fragments", exception2);
        }
    }

    private static boolean hasFragmentBeenLoaded(Class<?> clazz, Properties properties, StructureReader structureReader, String string) throws IOException {
        if (properties.containsKey(string)) {
            InputStream inputStream = clazz.getResourceAsStream("/fragments/" + properties.getProperty(string));
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(inputStream);
            structureReader.addStructures(memoryCacheImageInputStream);
            memoryCacheImageInputStream.close();
            return true;
        }
        return false;
    }

    private static ImageInputStream getStructureDataFile(IProcess iProcess, long l) throws IOException {
        try {
            if (iProcess.getPlatform() == Platform.ZOS) {
                return VMDataFactory.getStructureDataFileFromSymbol(iProcess);
            }
            return VMDataFactory.getStructureDataFileFromRASEyecatcher(iProcess, l);
        }
        catch (JVMNotFoundException jVMNotFoundException) {
            String string = System.getProperty(STRUCTUREFILE_PROPERTY);
            if (string != null) {
                try {
                    return VMDataFactory.getStructureDataFromFile(string, iProcess);
                }
                catch (Exception exception2) {
                    throw new IOException(jVMNotFoundException);
                }
            }
            if (iProcess.getPlatform() == Platform.ZOS && System.getProperty(SEARCHEYECATCHER_PROPERTY) != null) {
                return VMDataFactory.getStructureDataFileFromRASEyecatcher(iProcess, l);
            }
            throw jVMNotFoundException;
        }
    }

    private static ImageInputStream getStructureDataFileFromRASEyecatcher(IProcess iProcess, long l) throws IOException {
        try {
            long l2 = iProcess.findPattern(eyecatcher, 1, l);
            while (l2 != -1L) {
                long l3 = iProcess.getLongAt(l2 + 8L);
                if (l3 == -6172840429334713771L) {
                    return VMDataFactory.foundRAS(iProcess, l2);
                }
                l2 = iProcess.findPattern(eyecatcher, 1, l2 + (long)eyecatcher.length);
            }
            throw new JVMNotFoundException(iProcess, "Could not find J9RAS structure. No Java in process?");
        }
        catch (MemoryFault memoryFault) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            memoryFault.printStackTrace(printWriter);
            logger.logp(Level.FINE, null, null, stringWriter.toString());
            throw new IOException(memoryFault.getMessage());
        }
    }

    private static ImageInputStream getStructureDataFileFromSymbol(IProcess iProcess) throws IOException {
        try {
            for (IModule iModule : iProcess.getModules()) {
                for (ISymbol iSymbol : iModule.getSymbols()) {
                    if (!iSymbol.getName().equals(J9RAS_SYMBOL)) continue;
                    return VMDataFactory.foundRAS(iProcess, iSymbol.getAddress());
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new IOException(corruptDataException.getMessage());
        }
        catch (DataUnavailableException dataUnavailableException) {
            throw new IOException(dataUnavailableException.getMessage());
        }
        throw new JVMNotFoundException(iProcess, "Could not find _j9ras_ symbol in process");
    }

    private static ImageInputStream getStructureDataFromFile(String string, IProcess iProcess) throws IOException {
        File file = new File(string);
        FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
        fileImageInputStream.setByteOrder(iProcess.getByteOrder());
        return fileImageInputStream;
    }

    private static ImageInputStream foundRAS(IProcess iProcess, long l) throws IOException {
        try {
            long l2;
            j9RASAddress = l;
            String string = System.getProperty(STRUCTUREFILE_PROPERTY);
            if (string != null) {
                try {
                    return VMDataFactory.getStructureDataFromFile(string, iProcess);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return VMDataFactory.getBlobFromArchive(string, iProcess);
                }
            }
            int n = iProcess.getIntAt(l + 16L);
            short s = (short)(n >> 16);
            if (s < 2) {
                return VMDataFactory.locateInServiceVMStructure(iProcess);
            }
            long l3 = iProcess.getPointerAt(l + 24L);
            if (0L == l3) {
                try {
                    return VMDataFactory.locateInServiceVMStructure(iProcess);
                }
                catch (IOException iOException) {
                    MissingDDRStructuresException missingDDRStructuresException = new MissingDDRStructuresException(iProcess, "System dump was generated by a DDR-enabled JVM, but did not contain embedded DDR structures. This dump cannot be analyzed by DDR. You can specify the location of a DDR structure file to use with the com.ibm.j9ddr.structurefile system property");
                    missingDDRStructuresException.initCause(iOException);
                    throw missingDDRStructuresException;
                }
            }
            long l4 = l2 = iProcess.bytesPerPointer() == 4 ? 0xFFFFFFFF00000000L | l3 : l3;
            if (l2 == -2L) {
                StructureHeader structureHeader = new StructureHeader(1);
                l3 = l + 24L + (long)(iProcess.bytesPerPointer() * 2);
                IMemoryImageInputStream iMemoryImageInputStream = new IMemoryImageInputStream(iProcess, l3);
                structureHeader.readBlobVersion(iMemoryImageInputStream);
                return VMDataFactory.getBlobFromLibrary(iProcess, structureHeader);
            }
            if (l2 == -1L) {
                if (n == 0x100000) {
                    l3 = l + 24L + (long)(iProcess.bytesPerPointer() * 2);
                } else {
                    MissingDDRStructuresException missingDDRStructuresException = new MissingDDRStructuresException(iProcess, "System dump was generated by a DDR-enabled JVM, but did not contain embedded DDR structures. This dump cannot be analyzed by DDR. You can specify the location of a DDR structure file to use with the com.ibm.j9ddr.structurefile system property");
                    throw missingDDRStructuresException;
                }
            }
            return new IMemoryImageInputStream(iProcess, l3);
        }
        catch (MemoryFault memoryFault) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            memoryFault.printStackTrace(printWriter);
            logger.logp(Level.FINE, null, null, stringWriter.toString());
            throw new IOException(memoryFault.getMessage());
        }
    }

    private static ImageInputStream locateInServiceVMStructure(IProcess iProcess) throws IOException {
        String string = VMDataFactory.getBlobBasedirInArchive(iProcess);
        String string2 = VMDataFactory.getJ9VMBuildInCore(iProcess);
        try {
            return VMDataFactory.getBlobFromArchive(string + string2, iProcess);
        }
        catch (IOException iOException) {
            InputStream inputStream = VMDataFactory.class.getResourceAsStream("/ddr.structurefiles.index");
            if (inputStream == null) {
                throw new JVMNotDDREnabledException(iProcess, "DDR could not find VM structure data archive index. J9VM build ID: " + string2 + ". Platform: " + string + ". You can specify a structure file to use manually with the " + STRUCTUREFILE_PROPERTY + " system property.");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string3 = bufferedReader.readLine();
            String[] stringArray = string3.split(":");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string)) continue;
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
            throw new JVMNotDDREnabledException(iProcess, "DDR could not find VM structure data file. J9VM build ID: " + string2 + ". Platform: " + string + ". You can specify a structure file to use manually with the " + STRUCTUREFILE_PROPERTY + " system property." + (stringBuffer.length() > 0 ? " Possible structure file matches: " + stringBuffer.toString() + "." : ""));
        }
    }

    private static ImageInputStream getBlobFromArchive(String string, IProcess iProcess) throws IOException {
        InputStream inputStream = VMDataFactory.class.getResourceAsStream('/' + string);
        if (inputStream != null) {
            InputStreamImageWrapper inputStreamImageWrapper = new InputStreamImageWrapper(inputStream);
            inputStreamImageWrapper.setByteOrder(iProcess.getByteOrder());
            return inputStreamImageWrapper;
        }
        throw new JVMNotDDREnabledException(iProcess, "DDR could not find VM structure data file " + string);
    }

    private static String getJ9VMBuildInCore(IProcess iProcess) throws IOException {
        try {
            byte[] byArray = "J9VM - ".getBytes(StandardCharsets.US_ASCII);
            long l = iProcess.findPattern(byArray, 1, 0L);
            if (l != -1L) {
                long l2 = -1L;
                for (long i = 0L; i < 30L; ++i) {
                    if (iProcess.getByteAt(l + i) != 95) continue;
                    if (l2 == -1L) {
                        l2 = l + i + 1L;
                        continue;
                    }
                    byte[] byArray2 = new byte[(int)(l + i - l2)];
                    int n = 0;
                    while ((long)n < l + i - l2) {
                        byArray2[n] = iProcess.getByteAt(l2 + (long)n);
                        ++n;
                    }
                    return new String(byArray2, StandardCharsets.UTF_8);
                }
            }
        }
        catch (MemoryFault memoryFault) {
            throw new IOException(memoryFault.getMessage());
        }
        throw new JVMNotDDREnabledException(iProcess, "No J9VM build ID found in process");
    }

    private static String getBlobBasedirInArchive(IProcess iProcess) throws IOException {
        ICore iCore = iProcess.getAddressSpace().getCore();
        Platform platform = iCore.getPlatform();
        int n = iProcess.bytesPerPointer();
        switch (platform) {
            case AIX: {
                if (n == 4) {
                    return "aix/ppc-32/";
                }
                return "aix/ppc-64/";
            }
            case LINUX: {
                String string = iCore.getProperties().getProperty("cpu.type");
                if (n == 4) {
                    if (string.equals("x86")) {
                        return "linux/ia32/";
                    }
                    if (string.equals("ppc")) {
                        return "linux/ppc-32/";
                    }
                    if (string.equals("s390")) {
                        return "linux/s390-31/";
                    }
                } else {
                    if (string.equals("amd64")) {
                        return "linux/amd64/";
                    }
                    if (string.equals("ppc")) {
                        return "linux/ppc-64/";
                    }
                    if (string.equals("s390")) {
                        return "linux/s390-64/";
                    }
                }
                throw new UnknownArchitectureException(iProcess, "Could not determine architecture for Linux core file.");
            }
            case WINDOWS: {
                if (n == 4) {
                    return "win/ia32/";
                }
                return "win/amd64/";
            }
            case ZOS: {
                if (n == 4) {
                    return "zos/s390-31/";
                }
                return "zos/s390-64/";
            }
        }
        throw new UnknownArchitectureException(iProcess, "Could not determine platform of core file.");
    }

    public static void clearCache() {
        vmDataCache.clear();
    }

    private static ImageInputStream getBlobFromLibrary(IProcess iProcess, StructureHeader structureHeader) throws JVMNotFoundException {
        try {
            if (structureHeader != null) {
                IBlobFactory iBlobFactory = BlobFactory.getInstance();
                IBlobFactory.Platforms platforms = null;
                switch (iProcess.getPlatform()) {
                    case LINUX: {
                        platforms = iProcess.bytesPerPointer() == 4 ? IBlobFactory.Platforms.xi32 : IBlobFactory.Platforms.xa64;
                        break;
                    }
                }
                if (platforms != null) {
                    int[] nArray = structureHeader.getBlobVersionArray();
                    return iBlobFactory.getBlob(platforms, structureHeader.getPackageID(), nArray[2], nArray[1], nArray[0]);
                }
            }
            return null;
        }
        catch (Exception exception2) {
            throw new JVMNotFoundException(iProcess, (Throwable)exception2);
        }
    }

    private static StructureHeader findNodeVersion(IProcess iProcess) throws Exception {
        byte[] byArray = "v0.".getBytes();
        long l = 0L;
        do {
            Object object;
            int[] nArray = new int[3];
            nArray[0] = 0;
            int n = 1;
            if ((l = iProcess.findPattern(byArray, 0, l)) == -1L) continue;
            l += (long)(byArray.length - 1);
            StringBuilder stringBuilder = new StringBuilder();
            while (n < 3) {
                try {
                    char c = (char)iProcess.getByteAt(++l);
                    if (c >= '0' && c <= '9') {
                        stringBuilder.append(c);
                        continue;
                    }
                    try {
                        object = Integer.parseInt(stringBuilder.toString());
                        nArray[n++] = (Integer)object;
                        stringBuilder = new StringBuilder();
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                catch (MemoryFault memoryFault) {
                    // empty catch block
                    break;
                }
            }
            if (n != 3) continue;
            int n2 = nArray[0] << 16 | nArray[1] << 8 | nArray[2];
            object = new StructureHeader(StructureHeader.BlobID.node, n2, "node");
            return object;
        } while (l != -1L);
        return null;
    }

    static {
        vmDataCache = new WeakValueMap();
    }

    private static class InputStreamImageWrapper
    extends ImageInputStreamImpl {
        private ByteArrayInputStream is;

        public InputStreamImageWrapper(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read(byArray, 0, byArray.length);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray, 0, byArray.length);
            }
            this.is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }

        @Override
        public int read() throws IOException {
            int n = this.is.read();
            ++this.streamPos;
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.is.read(byArray, n, n2);
            if (n3 != -1) {
                this.streamPos += (long)n3;
            }
            return n3;
        }

        @Override
        public long getStreamPosition() throws IOException {
            return this.streamPos;
        }

        @Override
        public void seek(long l) throws IOException {
            super.seek(l);
            this.is.reset();
            this.is.skip(this.streamPos);
        }
    }
}

