/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf.unwind;

import com.ibm.j9ddr.corereaders.elf.unwind.CIE;
import com.ibm.j9ddr.corereaders.elf.unwind.FDE;
import com.ibm.j9ddr.corereaders.elf.unwind.Unwind;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class UnwindTable {
    private FDE fde;
    private Unwind unwinder;
    private static final int CFA_RULE_ID = -1;
    private RuleState state;
    private long cfa = -1L;
    private Long[] registers;
    private Stack<RuleState> ruleStack = new Stack();

    public UnwindTable(FDE fDE, Unwind unwind, long l) throws IOException {
        this.fde = fDE;
        this.unwinder = unwind;
        this.buildRuleTable(fDE, l);
    }

    private void buildRuleTable(FDE fDE, long l) throws IOException {
        PrintStream printStream = System.err;
        this.state = new RuleState();
        this.state.registerRules = new HashMap();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fDE.getCIE().getInitialInstructions());
        MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
        memoryCacheImageInputStream.setByteOrder(fDE.getCIE().byteOrder);
        while (memoryCacheImageInputStream.getStreamPosition() < (long)fDE.getCIE().getInitialInstructions().length) {
            this.processInstruction(memoryCacheImageInputStream, fDE.getCIE(), this.state, 0L);
        }
        this.state.cieRegisterRules = new HashMap();
        this.state.cieRegisterRules.putAll(this.state.registerRules);
        byteArrayInputStream = new ByteArrayInputStream(fDE.getCallFrameInstructions());
        memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
        memoryCacheImageInputStream.setByteOrder(fDE.getCIE().byteOrder);
        HashMap hashMap = new HashMap();
        long l2 = fDE.getBaseAddress();
        while (memoryCacheImageInputStream.getStreamPosition() < (long)fDE.getCallFrameInstructions().length && l >= l2) {
            l2 = this.processInstruction(memoryCacheImageInputStream, fDE.getCIE(), this.state, l2);
        }
    }

    public Map<String, Number> apply(Map<String, Number> map, String[] stringArray) throws MemoryFault {
        this.registers = new Long[stringArray.length + 1];
        int n = this.registers.length - 1;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = null;
            Number number = null;
            object = stringArray[i];
            if (object != null) {
                number = map.get(object);
            }
            this.registers[i] = number != null ? Long.valueOf(map.get(stringArray[i]).longValue()) : Long.valueOf(0L);
        }
        this.state.cfaRule.apply(this.registers, n, this.unwinder.process);
        for (Object object : this.state.registerRules.values()) {
            if (object == null) continue;
            ((RegisterRule)object).apply(this.registers, n, this.unwinder.process);
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], this.registers[i]);
        }
        this.cfa = this.registers[n];
        return hashMap;
    }

    public long getFrameAddress() {
        return this.cfa;
    }

    public long getReturnAddress() {
        Long l = this.registers[(int)this.fde.cie.returnAddressRegister];
        return l == null ? 0L : l;
    }

    public static void dumpInstructions(PrintStream printStream, byte[] byArray, CIE cIE) throws IOException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
            memoryCacheImageInputStream.setByteOrder(cIE.byteOrder);
            while (memoryCacheImageInputStream.getStreamPosition() < (long)byArray.length) {
                UnwindTable.dumpInstruction(printStream, memoryCacheImageInputStream, cIE);
                printStream.println();
            }
        }
        catch (Exception exception) {
            printStream.println("Error dumping instructions: " + exception);
            exception.printStackTrace(printStream);
        }
    }

    private static void dumpInstruction(PrintStream printStream, ImageInputStream imageInputStream, CIE cIE) throws IOException {
        byte by = imageInputStream.readByte();
        switch (by & 0xC0) {
            case 64: {
                byte by2 = (byte)(by & 0x3F);
                printStream.printf("advance_loc: 0x%x, %d", by2, (long)by2 * cIE.codeAlignmentFactor);
                return;
            }
            case 128: {
                byte by3 = (byte)(by & 0x3F);
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                printStream.printf("offset: r%d offset cfa%+d", by3, l *= cIE.dataAlignmentFactor);
                return;
            }
            case 192: {
                byte by4 = (byte)(by & 0x3F);
                printStream.printf("restore: r%d", by4);
                return;
            }
        }
        switch (by) {
            case 0: {
                break;
            }
            case 1: {
                long l = cIE.wordSize == 8 ? imageInputStream.readLong() : (long)(imageInputStream.readInt() & 0xFFFFFFFF);
                printStream.printf("set_loc: 0x%x", l);
                break;
            }
            case 2: {
                long l = (long)imageInputStream.readByte() & 0xFFL;
                printStream.printf("advance_loc1: 0x%x, %d", l, l * cIE.codeAlignmentFactor);
                break;
            }
            case 3: {
                long l = (long)imageInputStream.readShort() & 0xFFFFL;
                printStream.printf("advance_loc2: 0x%x, %d", l, l * cIE.codeAlignmentFactor);
                break;
            }
            case 4: {
                long l = (long)imageInputStream.readInt() & 0xFFFFFFFFFFFFFFFFL;
                printStream.printf("advance_loc4: 0x%x, %d", l, l * cIE.codeAlignmentFactor);
                break;
            }
            case 5: {
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                long l2 = Unwind.readUnsignedLEB128(imageInputStream);
                printStream.printf("offset_extended: r%d offset cfa%+d", l, l2 *= cIE.dataAlignmentFactor);
                break;
            }
            case 7: {
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                printStream.printf("undefined: r%d ", l);
                break;
            }
            case 8: {
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                printStream.printf("same_value: r%d ", l);
                break;
            }
            case 9: {
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                long l3 = Unwind.readUnsignedLEB128(imageInputStream);
                printStream.printf("register: r%d is in r%d", l, l3);
                break;
            }
            case 10: {
                printStream.printf("remember_state", new Object[0]);
                break;
            }
            case 11: {
                printStream.printf("restore_state", new Object[0]);
                break;
            }
            case 12: {
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                long l4 = Unwind.readUnsignedLEB128(imageInputStream);
                printStream.printf("def_cfa: r%d offset: %d", l, l4);
                break;
            }
            case 13: {
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                printStream.printf("def_cfa_register: r%d", l);
                break;
            }
            case 14: {
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                printStream.printf("def_cfa_offset: offset: %d", l);
                break;
            }
            case 18: {
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                long l5 = Unwind.readSignedLEB128(imageInputStream);
                long l6 = l5 * cIE.dataAlignmentFactor;
                printStream.printf("def_cfa_sf: r%d offset: %d (%d)", l, l5, l6);
                break;
            }
            case 17: {
                long l = Unwind.readUnsignedLEB128(imageInputStream);
                long l7 = Unwind.readSignedLEB128(imageInputStream);
                printStream.printf("offset_extended_sf: r%d offset cfa%+d", l, l7 *= cIE.dataAlignmentFactor);
                break;
            }
            default: {
                printStream.printf("?? 0x%x", by);
            }
        }
    }

    private long processInstruction(ImageInputStream imageInputStream, CIE cIE, RuleState ruleState, long l) throws IOException {
        byte by = imageInputStream.readByte();
        switch (by & 0xC0) {
            case 64: {
                byte by2 = (byte)(by & 0x3F);
                return l + (long)by2 * cIE.codeAlignmentFactor;
            }
            case 128: {
                byte by3 = (byte)(by & 0x3F);
                long l2 = Unwind.readUnsignedLEB128(imageInputStream);
                ruleState.registerRules.put(Integer.valueOf(by3), new CFAOffsetRegisterRule(by3, l2 *= cIE.dataAlignmentFactor));
                return l;
            }
            case 192: {
                byte by4 = (byte)(by & 0x3F);
                return l;
            }
        }
        switch (by) {
            case 0: {
                break;
            }
            case 1: {
                long l3 = cIE.wordSize == 8 ? imageInputStream.readLong() : (long)(imageInputStream.readInt() & 0xFFFFFFFF);
                l = l3;
                break;
            }
            case 2: {
                long l4 = (long)imageInputStream.readByte() & 0xFFL;
                l += l4 * cIE.codeAlignmentFactor;
                break;
            }
            case 3: {
                long l5 = (long)imageInputStream.readShort() & 0xFFFFL;
                l += l5 * cIE.codeAlignmentFactor;
                break;
            }
            case 4: {
                long l6 = (long)imageInputStream.readInt() & 0xFFFFFFFFFFFFFFFFL;
                l += l6 * cIE.codeAlignmentFactor;
                break;
            }
            case 5: {
                long l7 = Unwind.readUnsignedLEB128(imageInputStream);
                long l8 = Unwind.readUnsignedLEB128(imageInputStream);
                ruleState.registerRules.put((int)l7, new CFAOffsetRegisterRule((int)l7, l8 *= cIE.dataAlignmentFactor));
                break;
            }
            case 7: {
                long l9 = Unwind.readUnsignedLEB128(imageInputStream);
                ruleState.registerRules.put((int)l9, new UndefinedRegisterRule((int)l9));
                break;
            }
            case 8: {
                long l10 = Unwind.readUnsignedLEB128(imageInputStream);
                ruleState.registerRules.put((int)l10, new SameValueRegisterRule((int)l10));
                break;
            }
            case 9: {
                long l11 = Unwind.readUnsignedLEB128(imageInputStream);
                long l12 = Unwind.readUnsignedLEB128(imageInputStream);
                ruleState.registerRules.put((int)l11, new RegisterRegisterRule((int)l11, (int)l12));
                break;
            }
            case 10: {
                RuleState ruleState2 = new RuleState();
                ruleState2.registerRules = new HashMap();
                ruleState2.cieRegisterRules = new HashMap();
                ruleState2.registerRules.putAll(ruleState.registerRules);
                ruleState2.cieRegisterRules.putAll(ruleState.cieRegisterRules);
                ruleState2.cfaRule = ruleState.cfaRule;
                this.ruleStack.push(ruleState2);
                break;
            }
            case 11: {
                RuleState ruleState3 = this.ruleStack.pop();
                ruleState.cfaRule = ruleState3.cfaRule;
                ruleState.registerRules = ruleState3.registerRules;
                ruleState.cieRegisterRules = ruleState3.cieRegisterRules;
                break;
            }
            case 12: {
                long l13 = Unwind.readUnsignedLEB128(imageInputStream);
                long l14 = Unwind.readUnsignedLEB128(imageInputStream);
                ruleState.cfaRule = new RegisterOffsetCFARule(UnwindTable.CFA_RULE_ID, (int)l13, l14);
                break;
            }
            case 13: {
                long l15 = Unwind.readUnsignedLEB128(imageInputStream);
                RegisterOffsetCFARule registerOffsetCFARule = ruleState.cfaRule;
                ruleState.cfaRule = new RegisterOffsetCFARule(UnwindTable.CFA_RULE_ID, (int)l15, ((CFARule)registerOffsetCFARule).getOffset());
                break;
            }
            case 14: {
                long l16 = Unwind.readUnsignedLEB128(imageInputStream);
                RegisterOffsetCFARule registerOffsetCFARule = ruleState.cfaRule;
                ruleState.cfaRule = new RegisterOffsetCFARule(UnwindTable.CFA_RULE_ID, ((CFARule)registerOffsetCFARule).getBaseRegister(), l16);
                break;
            }
            case 18: {
                long l17 = Unwind.readUnsignedLEB128(imageInputStream);
                long l18 = Unwind.readSignedLEB128(imageInputStream);
                long l19 = l18 * cIE.dataAlignmentFactor;
                ruleState.cfaRule = new RegisterOffsetCFARule(UnwindTable.CFA_RULE_ID, (int)l17, l19);
                break;
            }
            case 17: {
                long l20 = Unwind.readUnsignedLEB128(imageInputStream);
                long l21 = Unwind.readSignedLEB128(imageInputStream);
                ruleState.registerRules.put((int)l20, new CFAOffsetRegisterRule((int)l20, l21 *= cIE.dataAlignmentFactor));
                break;
            }
        }
        return l;
    }

    private static class RegisterOffsetCFARule
    extends CFARule {
        int register;
        long offset;

        private RegisterOffsetCFARule(int n, int n2, long l) {
            super(n);
            this.register = n2;
            this.offset = l;
        }

        @Override
        public int getBaseRegister() {
            return this.register;
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        @Override
        public void apply(Long[] longArray, int n, IProcess iProcess) {
            long l = longArray[this.register];
            long l2 = l + this.offset;
            longArray[n] = l2;
        }
    }

    private static abstract class CFARule
    extends RegisterRule {
        protected CFARule(int n) {
            super(n);
        }

        public abstract long getOffset();

        public abstract int getBaseRegister();
    }

    private static class CFAOffsetRegisterRule
    extends RegisterRule {
        private long offset;

        private CFAOffsetRegisterRule(int n, long l) {
            super(n);
            this.offset = l;
        }

        @Override
        public void apply(Long[] longArray, int n, IProcess iProcess) throws MemoryFault {
            long l = longArray[n];
            long l2 = l + this.offset;
            longArray[this.getRegister()] = iProcess.getPointerAt(l2);
        }
    }

    private static class UndefinedRegisterRule
    extends RegisterRule {
        private int sourceRegisterNum;

        private UndefinedRegisterRule(int n) {
            super(n);
        }

        @Override
        public void apply(Long[] longArray, int n, IProcess iProcess) throws MemoryFault {
            longArray[this.getRegister()] = null;
        }
    }

    private static class SameValueRegisterRule
    extends RegisterRegisterRule {
        private SameValueRegisterRule(int n) {
            super(n, n);
        }
    }

    private static class RegisterRegisterRule
    extends RegisterRule {
        private int sourceRegisterNum;

        private RegisterRegisterRule(int n, int n2) {
            super(n);
            this.sourceRegisterNum = n2;
        }

        @Override
        public void apply(Long[] longArray, int n, IProcess iProcess) throws MemoryFault {
            longArray[this.getRegister()] = longArray[this.sourceRegisterNum];
        }
    }

    private static abstract class RegisterRule {
        private int registerNum;

        protected RegisterRule(int n) {
            this.registerNum = n;
        }

        public int getRegister() {
            return this.registerNum;
        }

        public abstract void apply(Long[] var1, int var2, IProcess var3) throws MemoryFault;
    }

    private static class DW_CFA {
        static final int advance_loc = 64;
        static final int offset = 128;
        static final int restore = 192;
        static final int nop = 0;
        static final int set_loc = 1;
        static final int advance_loc1 = 2;
        static final int advance_loc2 = 3;
        static final int advance_loc4 = 4;
        static final int offset_extended = 5;
        static final int undefined = 7;
        static final int same_value = 8;
        static final int register = 9;
        static final int remember_state = 10;
        static final int restore_state = 11;
        static final int def_cfa = 12;
        static final int def_cfa_register = 13;
        static final int def_cfa_offset = 14;
        static final int offset_extended_sf = 17;
        static final int def_cfa_sf = 18;

        private DW_CFA() {
        }
    }

    private class RuleState {
        private RegisterOffsetCFARule cfaRule;
        private Map<Integer, RegisterRule> registerRules;
        private Map<Integer, RegisterRule> cieRegisterRules;

        private RuleState() {
        }
    }
}

