/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.command.CommandParser;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.text.ParseException;

public class TimeCommand
extends Command {
    public TimeCommand() {
        this.addCommand("time", "<command>", "run another command and print out elapsed time");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        String[] stringArray2 = null;
        if (stringArray.length < 1) {
            printStream.println("The time command requires another command to run as an argument.");
            return;
        }
        if (stringArray.length > 1) {
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        } else {
            stringArray2 = new String[]{};
        }
        try {
            CommandParser commandParser = new CommandParser(stringArray[0], stringArray2);
            long l = System.currentTimeMillis();
            context.execute(commandParser, printStream);
            long l2 = System.currentTimeMillis();
            double d = ((double)l2 - (double)l) / 1000.0;
            printStream.printf("\n---\nCommand '%s' took %f seconds\n", commandParser.toString(), d);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace(printStream);
        }
    }
}

