/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageAddressSpace;
import java.util.Properties;

public class J9DDRImagePointer
implements ImagePointer {
    private final IProcess proc;
    private final long address;

    public J9DDRImagePointer(IProcess iProcess, long l) {
        this.proc = iProcess;
        this.address = l;
    }

    public ImagePointer add(long l) {
        return new J9DDRImagePointer(this.proc, this.address + l);
    }

    public long getAddress() {
        return this.address;
    }

    public ImageAddressSpace getAddressSpace() {
        return new J9DDRImageAddressSpace(this.proc.getAddressSpace());
    }

    public byte getByteAt(long l) throws MemoryAccessException, CorruptDataException {
        try {
            return this.proc.getByteAt(this.address + l);
        }
        catch (MemoryFault memoryFault) {
            MemoryAccessException memoryAccessException = new MemoryAccessException(this.add(l));
            memoryAccessException.initCause((Throwable)memoryFault);
            throw memoryAccessException;
        }
    }

    public double getDoubleAt(long l) throws MemoryAccessException, CorruptDataException {
        try {
            long l2 = this.proc.getLongAt(this.address + l);
            return Double.longBitsToDouble(l2);
        }
        catch (MemoryFault memoryFault) {
            MemoryAccessException memoryAccessException = new MemoryAccessException(this.add(l));
            memoryAccessException.initCause((Throwable)memoryFault);
            throw memoryAccessException;
        }
    }

    public float getFloatAt(long l) throws MemoryAccessException, CorruptDataException {
        try {
            int n = this.proc.getIntAt(this.address + l);
            return Float.intBitsToFloat(n);
        }
        catch (MemoryFault memoryFault) {
            MemoryAccessException memoryAccessException = new MemoryAccessException(this.add(l));
            memoryAccessException.initCause((Throwable)memoryFault);
            throw memoryAccessException;
        }
    }

    public int getIntAt(long l) throws MemoryAccessException, CorruptDataException {
        try {
            return this.proc.getIntAt(this.address + l);
        }
        catch (MemoryFault memoryFault) {
            MemoryAccessException memoryAccessException = new MemoryAccessException(this.add(l));
            memoryAccessException.initCause((Throwable)memoryFault);
            throw memoryAccessException;
        }
    }

    public long getLongAt(long l) throws MemoryAccessException, CorruptDataException {
        try {
            return this.proc.getLongAt(this.address + l);
        }
        catch (MemoryFault memoryFault) {
            MemoryAccessException memoryAccessException = new MemoryAccessException(this.add(l));
            memoryAccessException.initCause((Throwable)memoryFault);
            throw memoryAccessException;
        }
    }

    public ImagePointer getPointerAt(long l) throws MemoryAccessException, CorruptDataException {
        try {
            long l2 = this.proc.getPointerAt(this.address + l);
            return new J9DDRImagePointer(this.proc, l2);
        }
        catch (MemoryFault memoryFault) {
            MemoryAccessException memoryAccessException = new MemoryAccessException(this.add(l));
            memoryAccessException.initCause((Throwable)memoryFault);
            throw memoryAccessException;
        }
    }

    public short getShortAt(long l) throws MemoryAccessException, CorruptDataException {
        try {
            return this.proc.getShortAt(this.address + l);
        }
        catch (MemoryFault memoryFault) {
            MemoryAccessException memoryAccessException = new MemoryAccessException(this.add(l));
            memoryAccessException.initCause((Throwable)memoryFault);
            throw memoryAccessException;
        }
    }

    public boolean isExecutable() throws DataUnavailable {
        return this.proc.isExecutable(this.address);
    }

    public boolean isReadOnly() throws DataUnavailable {
        return this.proc.isReadOnly(this.address);
    }

    public boolean isShared() throws DataUnavailable {
        return this.proc.isShared(this.address);
    }

    public String toString() {
        return Long.toHexString(this.address);
    }

    public boolean equals(Object object) {
        if (object instanceof J9DDRImagePointer) {
            J9DDRImagePointer j9DDRImagePointer = (J9DDRImagePointer)object;
            if (j9DDRImagePointer.address != this.address) {
                return false;
            }
            return j9DDRImagePointer.proc.getAddressSpace().equals(this.proc.getAddressSpace());
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.address >>> 3);
    }

    public Properties getProperties() {
        return this.proc.getProperties(this.address);
    }
}

