/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.view.dtfj.image.J9DDRBaseImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageRegister;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageStackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class J9DDRImageThread
extends J9DDRBaseImageThread
implements ImageThread {
    private final IOSThread thread;
    private long overriddenThreadId;
    private boolean threadIdOverridden;

    public J9DDRImageThread(IProcess iProcess, IOSThread iOSThread) {
        super(iProcess);
        this.thread = iOSThread;
        this.threadIdOverridden = false;
    }

    public J9DDRImageThread(IProcess iProcess, IOSThread iOSThread, long l) {
        this(iProcess, iOSThread);
        this.threadIdOverridden = true;
        this.overriddenThreadId = l;
    }

    @Override
    public long getThreadId() throws CorruptDataException {
        if (this.threadIdOverridden) {
            return this.overriddenThreadId;
        }
        return this.thread.getThreadId();
    }

    public Properties getProperties() {
        return this.thread.getProperties();
    }

    public Iterator<?> getRegisters() {
        Collection<? extends IRegister> collection = this.thread.getRegisters();
        ArrayList<J9DDRImageRegister> arrayList = new ArrayList<J9DDRImageRegister>(collection.size());
        for (IRegister iRegister : collection) {
            arrayList.add(new J9DDRImageRegister(iRegister));
        }
        return arrayList.iterator();
    }

    public Iterator<?> getStackFrames() throws DataUnavailable {
        List<? extends IOSStackFrame> list = this.thread.getStackFrames();
        ArrayList<J9DDRImageStackFrame> arrayList = new ArrayList<J9DDRImageStackFrame>(list.size());
        for (IOSStackFrame iOSStackFrame : list) {
            arrayList.add(new J9DDRImageStackFrame(this.process, iOSStackFrame, this));
        }
        return arrayList.iterator();
    }

    public Iterator<?> getStackSections() {
        Collection<? extends IMemoryRange> collection = this.thread.getMemoryRanges();
        ArrayList<J9DDRImageSection> arrayList = new ArrayList<J9DDRImageSection>(collection.size());
        for (IMemoryRange iMemoryRange : collection) {
            arrayList.add(new J9DDRImageSection(this.process, iMemoryRange.getBaseAddress(), iMemoryRange.getSize(), "stack section at " + Long.toHexString(iMemoryRange.getBaseAddress())));
        }
        return arrayList.iterator();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.thread == null ? 0 : this.thread.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof J9DDRImageThread)) {
            return false;
        }
        J9DDRImageThread j9DDRImageThread = (J9DDRImageThread)object;
        return !(this.thread == null ? j9DDRImageThread.thread != null : !this.thread.equals(j9DDRImageThread.thread));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ImageThread 0x");
        try {
            stringBuilder.append(Long.toHexString(this.thread.getThreadId()));
        }
        catch (CorruptDataException corruptDataException) {
            stringBuilder.append("[corrupt ID]");
        }
        return stringBuilder.toString();
    }
}

