/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.HiddenInstanceField;
import com.ibm.j9ddr.vm29.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.ArrayList;
import java.util.LinkedList;

public class ObjectFieldInfo {
    ValueTypeHelper valueTypeHelper = ValueTypeHelper.getValueTypeHelper();
    J9ROMClassPointer romClass;
    int superclassFieldsSize;
    boolean objectCanUseBackfill;
    public static final int fj9object_t_SizeOf = J9ObjectHelper.compressObjectReferences ? 4 : UDATA.SIZEOF;
    public static final int j9objectmonitor_t_SizeOf;
    int instanceObjectCount = 0;
    int instanceSingleCount = 0;
    int instanceDoubleCount = 0;
    int totalObjectCount = 0;
    int totalSingleCount = 0;
    int totalDoubleCount = 0;
    boolean instanceFieldBackfillEligible;
    int hiddenFieldCount = 0;
    int superclassBackfillOffset;
    int myBackfillOffset;
    int subclassBackfillOffset;
    boolean isValue = false;
    J9ClassPointer containerClazz = J9ClassPointer.NULL;
    int totalFlatFieldDoubleBytes = 0;
    int totalFlatFieldRefBytes = 0;
    int totalFlatFieldSingleBytes = 0;
    int flatAlignedObjectInstanceBackfill = 0;
    int flatAlignedSingleInstanceBackfill = 0;
    int flatUnAlignedObjectInstanceBackfill = 0;
    int flatUnAlignedSingleInstanceBackfill = 0;
    boolean classRequiresPrePadding = false;
    boolean isBackFillPostPadded = false;
    public static final int NO_BACKFILL_AVAILABLE = -1;
    public static final int BACKFILL_SIZE = 4;
    public static final int LOCKWORD_SIZE;
    public static final int FINALIZE_LINK_SIZE;
    private static final int OBJECT_SIZE_INCREMENT_IN_BYTES = 8;

    ObjectFieldInfo(J9ROMClassPointer j9ROMClassPointer) {
        this.romClass = j9ROMClassPointer;
        this.superclassFieldsSize = -1;
        this.superclassBackfillOffset = -1;
        this.myBackfillOffset = -1;
        this.subclassBackfillOffset = -1;
        this.objectCanUseBackfill = fj9object_t_SizeOf == 4;
        this.instanceFieldBackfillEligible = false;
    }

    ObjectFieldInfo(J9ROMClassPointer j9ROMClassPointer, J9ClassPointer j9ClassPointer) throws CorruptDataException {
        this(j9ROMClassPointer);
        this.containerClazz = j9ClassPointer;
        this.isValue = this.valueTypeHelper.isRomClassAValueType(j9ROMClassPointer);
        this.totalFlatFieldDoubleBytes = 0;
        this.totalFlatFieldRefBytes = 0;
        this.totalFlatFieldSingleBytes = 0;
    }

    int getTotalDoubleCount() {
        return this.totalDoubleCount;
    }

    int getTotalObjectCount() {
        return this.totalObjectCount;
    }

    int getTotalSingleCount() {
        return this.totalSingleCount;
    }

    int getNonBackfilledObjectCount() {
        int n = this.totalObjectCount;
        if (this.isBackfillSuitableObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 != n) {
            --n;
        }
        return n;
    }

    int getNonBackfilledSingleCount() {
        int n = this.totalSingleCount;
        if (this.isBackfillSuitableSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 != n) {
            --n;
        }
        return n;
    }

    int getNonBackfilledInstanceObjectCount() {
        int n = this.instanceObjectCount;
        if (this.isBackfillSuitableInstanceObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 != n) {
            --n;
        }
        return n;
    }

    int getNonBackfilledInstanceSingleCount() {
        int n = this.instanceSingleCount;
        if (this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 != n) {
            --n;
        }
        return n;
    }

    int getInstanceDoubleCount() {
        return this.instanceDoubleCount;
    }

    int getInstanceObjectCount() {
        return this.instanceObjectCount;
    }

    int getInstanceSingleCount() {
        return this.instanceSingleCount;
    }

    int getHiddenFieldCount() {
        return this.hiddenFieldCount;
    }

    boolean isBackfillSuitableSingleAvailable() {
        return 0 != this.getTotalSingleCount() || 0 != this.getFlatAlignedSingleInstanceBackfillSize() || 0 != this.getFlatUnAlignedSingleInstanceBackfillSize();
    }

    boolean isBackfillSuitableObjectAvailable() {
        return this.objectCanUseBackfill && 0 != this.getTotalObjectCount() || 0 != this.getFlatAlignedObjectInstanceBackfillSize() || 0 != this.getFlatUnAlignedObjectInstanceBackfillSize();
    }

    boolean isBackfillSuitableInstanceSingleAvailable() {
        return 0 != this.getInstanceSingleCount();
    }

    boolean isBackfillSuitableFlatInstanceSingleAvailable() {
        return 0 != this.getFlatAlignedSingleInstanceBackfillSize() || 0 != this.getFlatUnAlignedSingleInstanceBackfillSize();
    }

    boolean isBackfillSuitableInstanceObjectAvailable() {
        return this.objectCanUseBackfill && 0 != this.getInstanceObjectCount() || 0 != this.getFlatAlignedObjectInstanceBackfillSize() || 0 != this.getFlatUnAlignedObjectInstanceBackfillSize();
    }

    boolean isBackfillSuitableFieldAvailable() {
        return this.isBackfillSuitableSingleAvailable() || this.isBackfillSuitableObjectAvailable();
    }

    UDATA getMyBackfillOffsetForHiddenField() {
        return new UDATA((long)this.myBackfillOffset + J9ObjectHelper.headerSize());
    }

    int getSuperclassFieldsSize() {
        return this.superclassFieldsSize;
    }

    long getSuperclassObjectSize() {
        return (long)this.superclassFieldsSize + J9ObjectHelper.headerSize();
    }

    void setSuperclassFieldsSize(int n) {
        this.superclassFieldsSize = n;
    }

    boolean isMyBackfillSlotAvailable() {
        return this.myBackfillOffset >= 0;
    }

    boolean isSuperclassBackfillSlotAvailable() {
        return this.superclassBackfillOffset >= 0;
    }

    int calculateFieldDataStart() {
        boolean bl;
        int n = this.getSuperclassFieldsSize();
        boolean bl2 = bl = this.totalDoubleCount > 0 || this.totalFlatFieldDoubleBytes > 0;
        if (this.getSuperclassObjectSize() % 8L != 0L && (bl || !this.objectCanUseBackfill && this.totalObjectCount > 0) && !this.isBackfillTypeEndAligned(n += this.getBackfillSize())) {
            n += 4;
            this.isBackFillPostPadded = true;
        }
        return n;
    }

    int addDoublesArea(int n) {
        return n + this.totalDoubleCount * 8;
    }

    int addObjectsArea(int n) {
        int n2 = this.getNonBackfilledObjectCount();
        return n + n2 * fj9object_t_SizeOf;
    }

    int getMyBackfillOffset() {
        return this.myBackfillOffset;
    }

    int getBackfillSize() {
        int n = 4;
        if (0 == this.getInstanceSingleCount() && 0 == this.getInstanceObjectCount()) {
            if (0 != this.getFlatAlignedSingleInstanceBackfillSize()) {
                n = this.getFlatAlignedSingleInstanceBackfillSize();
            } else if (0 != this.getFlatAlignedObjectInstanceBackfillSize()) {
                n = this.getFlatAlignedObjectInstanceBackfillSize();
            } else if (0 != this.getFlatUnAlignedSingleInstanceBackfillSize()) {
                n = this.getFlatUnAlignedSingleInstanceBackfillSize();
            } else if (0 != this.getFlatUnAlignedObjectInstanceBackfillSize()) {
                n = this.getFlatUnAlignedObjectInstanceBackfillSize();
            }
        }
        return n;
    }

    int getSubclassBackfillOffset() {
        return this.subclassBackfillOffset;
    }

    void setSuperclassBackfillOffset(int n) {
        this.superclassBackfillOffset = n;
    }

    int getSuperclassBackfillOffset() {
        return this.superclassBackfillOffset;
    }

    boolean isInstanceFieldBackfillEligible() {
        return this.instanceFieldBackfillEligible;
    }

    void countInstanceFields() throws CorruptDataException {
        J9ROMFieldShapeIterator j9ROMFieldShapeIterator = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
        for (J9ROMFieldShapePointer j9ROMFieldShapePointer : j9ROMFieldShapeIterator) {
            UDATA uDATA = j9ROMFieldShapePointer.modifiers();
            if (uDATA.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) continue;
            if (uDATA.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                if (this.valueTypeHelper.isFlattenableFieldSignature(J9ROMFieldShapeHelper.getSignature(j9ROMFieldShapePointer)) || uDATA.anyBitsIn(J9FieldFlags.J9FieldFlagIsNullRestricted)) {
                    boolean bl;
                    UDATA uDATA2;
                    int n = 0;
                    J9ClassPointer j9ClassPointer = this.valueTypeHelper.findJ9ClassInFlattenedClassCacheWithFieldName(this.containerClazz, J9ROMFieldShapeHelper.getName(j9ROMFieldShapePointer));
                    if (!this.valueTypeHelper.isJ9FieldIsFlattened(j9ClassPointer, j9ROMFieldShapePointer)) {
                        ++this.instanceObjectCount;
                        ++this.totalObjectCount;
                        continue;
                    }
                    if (fj9object_t_SizeOf == 4) {
                        uDATA2 = j9ClassPointer.totalInstanceSize();
                        UDATA uDATA3 = new UDATA(8L);
                        if (this.valueTypeHelper.classRequires4BytePrePadding(j9ClassPointer)) {
                            uDATA2 = uDATA2.sub(4L);
                        }
                        bl = uDATA.allBitsIn(J9JavaAccessFlags.J9AccVolatile) && uDATA2.eq(uDATA3);
                    } else {
                        bl = true;
                    }
                    if (bl || this.valueTypeHelper.isJ9ClassLargestAlignmentConstraintDouble(j9ClassPointer)) {
                        uDATA2 = j9ClassPointer.totalInstanceSize();
                        if (this.valueTypeHelper.classRequires4BytePrePadding(j9ClassPointer)) {
                            uDATA2 = uDATA2.sub(4L);
                        }
                        n = Scalar.roundToSizeofU64(uDATA2).intValue();
                        this.totalFlatFieldDoubleBytes += n;
                        continue;
                    }
                    if (this.valueTypeHelper.isJ9ClassLargestAlignmentConstraintReference(j9ClassPointer)) {
                        n = Scalar.roundToSizeToFJ9object(j9ClassPointer.totalInstanceSize()).intValue();
                        this.totalFlatFieldRefBytes += n;
                        this.setPotentialFlatObjectInstanceBackfill(n);
                        continue;
                    }
                    n = j9ClassPointer.totalInstanceSize().intValue();
                    this.totalFlatFieldSingleBytes += n;
                    this.setPotentialFlatSingleInstanceBackfill(n);
                    continue;
                }
                ++this.instanceObjectCount;
                ++this.totalObjectCount;
                continue;
            }
            if (uDATA.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this.instanceDoubleCount;
                ++this.totalDoubleCount;
                continue;
            }
            ++this.instanceSingleCount;
            ++this.totalSingleCount;
        }
        this.instanceFieldBackfillEligible = this.instanceSingleCount > 0 || this.objectCanUseBackfill && this.instanceSingleCount > 0;
    }

    int countAndCopyHiddenFields(LinkedList<HiddenInstanceField> linkedList, ArrayList<HiddenInstanceField> arrayList) throws CorruptDataException {
        String string = J9UTF8Helper.stringValue(this.romClass.className());
        this.hiddenFieldCount = 0;
        for (HiddenInstanceField hiddenInstanceField : linkedList) {
            if (hiddenInstanceField.className() != null && !string.equals(hiddenInstanceField.className())) continue;
            UDATA uDATA = hiddenInstanceField.shape().modifiers();
            if (uDATA.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                ++this.totalObjectCount;
            } else if (uDATA.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this.totalDoubleCount;
            } else {
                ++this.totalSingleCount;
            }
            arrayList.add(hiddenInstanceField);
            ++this.hiddenFieldCount;
        }
        return this.hiddenFieldCount;
    }

    int calculateTotalFieldsSizeAndBackfill() {
        long l = (long)this.superclassFieldsSize + (long)this.totalObjectCount * J9ObjectHelper.headerSize() + (long)(this.totalSingleCount * 4) + (long)(this.totalDoubleCount * 8);
        l += (long)(this.totalFlatFieldDoubleBytes + this.totalFlatFieldRefBytes + this.totalFlatFieldSingleBytes);
        if (this.isValue) {
            int n = this.calculateFieldDataStart();
            if (0 < n) {
                if (this.isBackfillSuitableFieldAvailable()) {
                    this.myBackfillOffset = 0;
                    if (this.isBackFillPostPadded()) {
                        l += 4L;
                    }
                } else {
                    l += (long)n;
                    this.setClassRequiresPrePadding();
                }
            }
        } else {
            if (this.getSuperclassObjectSize() % 8L != 0L && (this.totalDoubleCount > 0 || !this.objectCanUseBackfill && this.totalObjectCount > 0)) {
                this.superclassBackfillOffset = this.getSuperclassFieldsSize();
                l += 4L;
            }
            if (this.isSuperclassBackfillSlotAvailable() && this.isBackfillSuitableFieldAvailable()) {
                l -= 4L;
                this.myBackfillOffset = this.superclassBackfillOffset;
                this.superclassBackfillOffset = -1;
            }
            if ((l + J9ObjectHelper.headerSize()) % 8L != 0L) {
                this.subclassBackfillOffset = (int)l;
                l += 4L;
            } else {
                this.subclassBackfillOffset = this.superclassBackfillOffset;
            }
        }
        return (int)l;
    }

    int addFlatDoublesArea(int n) {
        return n + this.totalFlatFieldDoubleBytes;
    }

    int addFlatObjectsArea(int n) {
        return n + this.getNonBackfilledFlatInstanceObjectSize();
    }

    int addFlatSinglesArea(int n) {
        return n + this.getNonBackfilledFlatInstanceSingleSize();
    }

    int getFlatAlignedSingleInstanceBackfillSize() {
        return this.flatAlignedSingleInstanceBackfill;
    }

    int getFlatUnAlignedSingleInstanceBackfillSize() {
        return this.flatUnAlignedSingleInstanceBackfill;
    }

    int getFlatAlignedObjectInstanceBackfillSize() {
        return this.flatAlignedObjectInstanceBackfill;
    }

    int getFlatUnAlignedObjectInstanceBackfillSize() {
        return this.flatUnAlignedObjectInstanceBackfill;
    }

    void setFlatAlignedSingleInstanceBackfill(int n) {
        this.flatAlignedSingleInstanceBackfill = n;
    }

    void setFlatUnAlignedSingleInstanceBackfill(int n) {
        this.flatUnAlignedSingleInstanceBackfill = n;
    }

    void setFlatAlignedObjectInstanceBackfill(int n) {
        this.flatAlignedObjectInstanceBackfill = n;
    }

    void setFlatUnAlignedObjectInstanceBackfill(int n) {
        this.flatUnAlignedObjectInstanceBackfill = n;
    }

    void setPotentialFlatObjectInstanceBackfill(int n) {
        if (this.isValue) {
            if (4 == n % 8) {
                if (0 == this.getFlatAlignedObjectInstanceBackfillSize()) {
                    this.setFlatAlignedObjectInstanceBackfill(n);
                }
            } else if (0 == this.getFlatUnAlignedObjectInstanceBackfillSize()) {
                this.setFlatUnAlignedObjectInstanceBackfill(n);
            }
        }
    }

    void setPotentialFlatSingleInstanceBackfill(int n) {
        if (this.isValue) {
            if (4 == n % 8) {
                if (0 == this.getFlatAlignedSingleInstanceBackfillSize()) {
                    this.setFlatAlignedSingleInstanceBackfill(n);
                }
            } else if (0 == this.getFlatUnAlignedSingleInstanceBackfillSize()) {
                this.setFlatUnAlignedSingleInstanceBackfill(n);
            }
        }
    }

    int getNonBackfilledFlatInstanceObjectSize() {
        int n = this.totalFlatFieldRefBytes;
        if (this.isBackfillSuitableInstanceObjectAvailable() && this.isMyBackfillSlotAvailable() && 0 == this.getInstanceSingleCount() && this.objectCanUseBackfill && 0 == this.getInstanceObjectCount() && 0 == this.getFlatAlignedSingleInstanceBackfillSize()) {
            int n2 = this.getFlatAlignedObjectInstanceBackfillSize();
            if (0 == n2 && 0 == this.getFlatUnAlignedSingleInstanceBackfillSize()) {
                n2 = this.getFlatUnAlignedObjectInstanceBackfillSize();
            }
            n -= n2;
        }
        return n;
    }

    int getNonBackfilledFlatInstanceSingleSize() {
        int n = this.totalFlatFieldSingleBytes;
        if (this.isBackfillSuitableFlatInstanceSingleAvailable() && this.isMyBackfillSlotAvailable() && 0 == this.getInstanceSingleCount() && this.objectCanUseBackfill && 0 == this.getInstanceObjectCount()) {
            int n2 = this.getFlatAlignedSingleInstanceBackfillSize();
            if (0 == n2 && 0 == this.getFlatAlignedObjectInstanceBackfillSize()) {
                n2 = this.getFlatUnAlignedSingleInstanceBackfillSize();
            }
            n -= n2;
        }
        return n;
    }

    boolean doesClassRequiresPrePadding() {
        return this.classRequiresPrePadding;
    }

    void setClassRequiresPrePadding() {
        this.classRequiresPrePadding = true;
    }

    boolean isBackfillTypeEndAligned(int n) {
        return 4 == n % 8;
    }

    boolean isBackFillPostPadded() {
        return this.isBackFillPostPadded;
    }

    static {
        LOCKWORD_SIZE = j9objectmonitor_t_SizeOf = J9ObjectHelper.compressObjectReferences ? 4 : UDATA.SIZEOF;
        FINALIZE_LINK_SIZE = fj9object_t_SizeOf;
    }
}

