/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackmap;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.BCNames;
import com.ibm.j9ddr.vm29.j9.PCStack;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackmap.MapHelpers;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StackMap {
    private static Logger logger = Logger.getLogger("j9ddr.stackwalker.stackmap");
    private static IStackMap impl;

    public static int j9stackmap_StackBitsForPC(UDATA uDATA, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, int[] nArray, int n) throws CorruptDataException {
        IStackMap iStackMap = StackMap.getImpl();
        return iStackMap.j9stackmap_StackBitsForPC(uDATA, j9ROMClassPointer, j9ROMMethodPointer, nArray, n);
    }

    private static IStackMap getImpl() {
        if (impl == null) {
            impl = StackMap.getImpl("ALG_STACK_MAP_VERSION");
        }
        return impl;
    }

    private static IStackMap getImpl(String string) {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf(string);
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new StackMap_V1();
    }

    private static class StackMap_V1
    implements IStackMap {
        public static final byte INT = 0;
        public static final byte OBJ = 1;
        public static final byte WALKED = 1;
        public static final byte STACK_REQUEST = 2;
        public static final int BCT_ERR_NO_ERROR = 0;
        public static final int BCT_ERR_STACK_MAP_FAILED = -5;
        private J9MappingStack resultStack;
        private J9MappingStack startStack;
        private J9MappingStack liveStack;
        private U8Pointer bcStart;
        private U8Pointer bcIndex;
        private U8Pointer bcEnd;
        private int exceptionsToWalk;
        private J9ExceptionInfoPointer exceptionData;
        private Stack<J9MappingStack> branchStack = new Stack();

        protected StackMap_V1() {
        }

        @Override
        public int j9stackmap_StackBitsForPC(UDATA uDATA, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, int[] nArray, int n) throws CorruptDataException {
            logger.logp(Level.FINE, "StackMap_V1", "j9stackmap_StackBitsForPC", "romClass={0}, romMethod={1}, pc={2}", new Object[]{Long.toHexString(j9ROMClassPointer.getAddress()), Long.toHexString(j9ROMMethodPointer.getAddress()), uDATA});
            UDATA uDATA2 = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer);
            U16 u16 = j9ROMMethodPointer.maxStack();
            byte[] byArray = new byte[uDATA2.intValue()];
            byArray[uDATA.intValue()] = 2;
            int n2 = this.mapStack(u16, byArray, j9ROMClassPointer, j9ROMMethodPointer);
            if (n2 == 0) {
                n2 = this.outputStackMap(nArray, n);
            }
            return n2;
        }

        private int mapStack(U16 u16, byte[] byArray, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer) throws CorruptDataException {
            this.exceptionData = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(j9ROMMethodPointer);
            J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer = J9ROMConstantPoolItemPointer.cast(j9ROMClassPointer.add(1L));
            if (j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo)) {
                this.exceptionsToWalk = this.exceptionData.catchCount().intValue();
            }
            this.liveStack = this.startStack = new J9MappingStack(u16.intValue());
            this.bcIndex = this.bcStart = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(j9ROMMethodPointer);
            UDATA uDATA = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer);
            this.bcEnd = this.bcStart.add(uDATA);
            block7: while (this.bcIndex.lt(this.bcEnd)) {
                int n;
                block55: {
                    char c;
                    J9UTF8Pointer j9UTF8Pointer;
                    int n2;
                    int n3;
                    int n4;
                    block65: {
                        block66: {
                            block63: {
                                block64: {
                                    block62: {
                                        byte by;
                                        int n5;
                                        block61: {
                                            int n6;
                                            block60: {
                                                block59: {
                                                    block58: {
                                                        block57: {
                                                            block56: {
                                                                block54: {
                                                                    int n7;
                                                                    int n8 = (int)this.bcIndex.sub(UDATA.cast(this.bcStart)).getAddress();
                                                                    n4 = this.bcIndex.at(0L).intValue();
                                                                    if (byArray[n8] != 0) {
                                                                        if ((byArray[n8] & 2) != 0) {
                                                                            this.resultStack = this.liveStack;
                                                                            return 0;
                                                                        }
                                                                        n7 = this.nextRoot();
                                                                        if (n7 == 0) continue;
                                                                        return n7;
                                                                    }
                                                                    byArray[n8] = 1;
                                                                    n = 0xFF & PCStack.J9JavaInstructionSizeAndBranchActionTable[n4];
                                                                    int n9 = 0xFF & PCStack.JavaStackActionTable[n4];
                                                                    if (logger.isLoggable(Level.FINER)) {
                                                                        logger.logp(Level.FINER, "StackMap_V1", "mapStack", "bcIndex=0x{0} pc={1}, bc={2}, size={3}, action=0x{4}", new Object[]{Long.toHexString(this.bcIndex.getAddress()), n8, n4, n, Long.toHexString(n9)});
                                                                    }
                                                                    if (n9 != 128) {
                                                                        for (n3 = 0; n3 != (n9 & 7); ++n3) {
                                                                            this.POP();
                                                                        }
                                                                        if (n9 >= 16) {
                                                                            if (n9 >= 80) {
                                                                                this.PUSH((byte)1);
                                                                            } else {
                                                                                this.PUSH((byte)0);
                                                                                if (n9 >= 32) {
                                                                                    this.PUSH((byte)0);
                                                                                }
                                                                            }
                                                                        }
                                                                        if (n >>> 4 == 0) {
                                                                            this.bcIndex = this.bcIndex.add(n);
                                                                            if (n != 0) continue;
                                                                            return -5;
                                                                        }
                                                                        switch (n >> 4) {
                                                                            case 1: {
                                                                                int n10 = new I16(MapHelpers.PARAM_16(this.bcIndex, 1)).intValue();
                                                                                int n11 = n8 + n10;
                                                                                if ((byArray[n11] & 1) == 0) {
                                                                                    this.liveStack = this.pushStack(n11);
                                                                                }
                                                                                this.bcIndex = this.bcIndex.add(n & 7);
                                                                                continue block7;
                                                                            }
                                                                            case 2: {
                                                                                int n11;
                                                                                int n10;
                                                                                if (n4 == 167) {
                                                                                    n10 = new I16(MapHelpers.PARAM_16(this.bcIndex, 1)).intValue();
                                                                                    n11 = n8 + n10;
                                                                                } else {
                                                                                    n10 = new I32(MapHelpers.PARAM_32(this.bcIndex, 1)).intValue();
                                                                                    n11 = n8 + n10;
                                                                                }
                                                                                this.bcIndex = this.bcStart.add(n11);
                                                                                continue block7;
                                                                            }
                                                                            case 4: {
                                                                                n7 = this.nextRoot();
                                                                                if (n7 == 0) continue block7;
                                                                                return n7;
                                                                            }
                                                                            case 5: {
                                                                                int n12;
                                                                                int n11;
                                                                                this.bcIndex = this.bcIndex.add(4 - (n8 & 3));
                                                                                int n10 = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                this.bcIndex = this.bcIndex.add(4L);
                                                                                n6 = n8 + n10;
                                                                                int n13 = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                this.bcIndex = this.bcIndex.add(4L);
                                                                                if (n4 == 170) {
                                                                                    int n14 = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                    this.bcIndex = this.bcIndex.add(4L);
                                                                                    n12 = n14 - n13 + 1;
                                                                                    n5 = 0;
                                                                                } else {
                                                                                    n12 = n13;
                                                                                    n5 = 4;
                                                                                }
                                                                                while (n12 > 0) {
                                                                                    this.bcIndex = this.bcIndex.add(n5);
                                                                                    n10 = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                    this.bcIndex = this.bcIndex.add(4L);
                                                                                    n11 = n8 + n10;
                                                                                    if ((byArray[n11] & 1) == 0) {
                                                                                        this.liveStack = this.pushStack(n11);
                                                                                    }
                                                                                    --n12;
                                                                                }
                                                                                this.bcIndex = this.bcStart.add(n6);
                                                                                continue block7;
                                                                            }
                                                                            case 7: {
                                                                                return -5;
                                                                            }
                                                                        }
                                                                        this.bcIndex.add(n & 7);
                                                                        continue;
                                                                    }
                                                                    if (n4 != 18 && n4 != 19) break block54;
                                                                    n2 = n4 == 18 ? MapHelpers.PARAM_8(this.bcIndex, 1).intValue() : MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                                                    if (j9ROMConstantPoolItemPointer.add(n2).slot2().longValue() != 0L) {
                                                                        this.PUSH((byte)1);
                                                                    } else {
                                                                        this.PUSH((byte)0);
                                                                    }
                                                                    break block55;
                                                                }
                                                                if (n4 != 89) break block56;
                                                                by = this.POP();
                                                                this.PUSH(by);
                                                                this.PUSH(by);
                                                                break block55;
                                                            }
                                                            if (n4 != 90) break block57;
                                                            by = this.POP();
                                                            n5 = this.POP();
                                                            this.PUSH(by);
                                                            this.PUSH(n5);
                                                            this.PUSH(by);
                                                            break block55;
                                                        }
                                                        if (n4 != 91) break block58;
                                                        by = this.POP();
                                                        n5 = this.POP();
                                                        n6 = this.POP();
                                                        this.PUSH(by);
                                                        this.PUSH(n6);
                                                        this.PUSH(n5);
                                                        this.PUSH(by);
                                                        break block55;
                                                    }
                                                    if (n4 != 92) break block59;
                                                    n5 = this.POP();
                                                    n6 = this.POP();
                                                    this.PUSH(n6);
                                                    this.PUSH(n5);
                                                    this.PUSH(n6);
                                                    this.PUSH(n5);
                                                    break block55;
                                                }
                                                if (n4 != 93) break block60;
                                                by = this.POP();
                                                n5 = this.POP();
                                                n6 = this.POP();
                                                this.PUSH(n5);
                                                this.PUSH(by);
                                                this.PUSH(n6);
                                                this.PUSH(n5);
                                                this.PUSH(by);
                                                break block55;
                                            }
                                            if (n4 != 94) break block61;
                                            by = this.POP();
                                            n5 = this.POP();
                                            n6 = this.POP();
                                            byte by2 = this.POP();
                                            this.PUSH(n5);
                                            this.PUSH(by);
                                            this.PUSH((int)by2);
                                            this.PUSH(n6);
                                            this.PUSH(n5);
                                            this.PUSH(by);
                                            break block55;
                                        }
                                        if (n4 != 95) break block62;
                                        by = this.POP();
                                        n5 = this.POP();
                                        this.PUSH(by);
                                        this.PUSH(n5);
                                        break block55;
                                    }
                                    if (n4 != 180) break block63;
                                    this.POP();
                                    n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                    j9UTF8Pointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                                    c = J9UTF8Helper.stringValue(j9UTF8Pointer).charAt(0);
                                    if (!J9ClassHelper.isClassSignature(c) && c != '[') break block64;
                                    this.PUSH((byte)1);
                                    break block55;
                                }
                                this.PUSH((byte)0);
                                if (c != 'J' && c != 'D') break block55;
                                this.PUSH((byte)0);
                                break block55;
                            }
                            if (n4 != 178) break block65;
                            n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                            j9UTF8Pointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                            c = J9UTF8Helper.stringValue(j9UTF8Pointer).charAt(0);
                            if (!J9ClassHelper.isClassSignature(c) && c != '[') break block66;
                            this.PUSH((byte)1);
                            break block55;
                        }
                        this.PUSH((byte)0);
                        if (c != 'J' && c != 'D') break block55;
                        this.PUSH((byte)0);
                        break block55;
                    }
                    if (n4 == 181) {
                        this.POP();
                        n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                        j9UTF8Pointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                        c = J9UTF8Helper.stringValue(j9UTF8Pointer).charAt(0);
                        this.POP();
                        if (c == 'D' || c == 'J') {
                            this.POP();
                        }
                    } else if (n4 == 179) {
                        n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                        j9UTF8Pointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                        c = J9UTF8Helper.stringValue(j9UTF8Pointer).charAt(0);
                        this.POP();
                        if (c == 'D' || c == 'J') {
                            this.POP();
                        }
                    } else {
                        if (n4 == BCNames.JBinvokeinterface2) {
                            this.bcIndex = this.bcIndex.add(2L);
                            continue;
                        }
                        if (n4 == BCNames.JBinvokehandle || n4 == BCNames.JBinvokehandlegeneric || n4 == 182 || n4 == 183 || n4 == BCNames.JBinvokespecialsplit || n4 == 185 || n4 == 184 || n4 == BCNames.JBinvokestaticsplit) {
                            if (n4 != 184 && n4 != BCNames.JBinvokestaticsplit) {
                                this.POP();
                            }
                            n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                            if (n4 == BCNames.JBinvokestaticsplit) {
                                n2 = j9ROMClassPointer.staticSplitMethodRefIndexes().at(n2).intValue();
                            } else if (n4 == BCNames.JBinvokespecialsplit) {
                                n2 = j9ROMClassPointer.specialSplitMethodRefIndexes().at(n2).intValue();
                            }
                            j9UTF8Pointer = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                            char[] cArray = J9UTF8Helper.stringValue(j9UTF8Pointer).toCharArray();
                            int n15 = 0;
                            n15 = 1;
                            while (cArray[n15] != ')') {
                                this.POP();
                                if (cArray[n15] == 'D' || cArray[n15] == 'J') {
                                    this.POP();
                                } else {
                                    while (cArray[n15] == '[') {
                                        ++n15;
                                    }
                                    if (J9ClassHelper.isClassSignature(cArray[n15])) {
                                        while (cArray[++n15] != ';') {
                                        }
                                    }
                                }
                                ++n15;
                            }
                            c = cArray[n15 + 1];
                            if (c != 'V') {
                                if (J9ClassHelper.isClassSignature(c) || c == '[') {
                                    this.PUSH((byte)1);
                                } else {
                                    this.PUSH((byte)0);
                                    if (c == 'J' || c == 'D') {
                                        this.PUSH((byte)0);
                                    }
                                }
                            }
                            if (n4 == BCNames.JBinvokeinterface2) {
                                this.bcIndex = this.bcIndex.sub(2L);
                            }
                        } else if (n4 == 197) {
                            n2 = MapHelpers.PARAM_8(this.bcIndex, 3).intValue();
                            for (n3 = 0; n3 < n2; ++n3) {
                                this.POP();
                            }
                            this.PUSH((byte)1);
                            break;
                        }
                    }
                }
                this.bcIndex = this.bcIndex.add(n & 7);
            }
            return -5;
        }

        private J9MappingStack pushStack(int n) {
            logger.logp(Level.FINEST, "StackMap_V1", "pushStack", "pushStack");
            this.liveStack.pc = n;
            this.branchStack.push(this.liveStack);
            this.liveStack = new J9MappingStack(this.liveStack);
            return this.liveStack;
        }

        private void popStack() {
            logger.logp(Level.FINEST, "StackMap_V1", "popStack", "popStack");
            this.liveStack = this.branchStack.pop();
            this.bcIndex = this.bcStart.add(this.liveStack.pc);
        }

        private int nextRoot() throws CorruptDataException {
            if (this.liveStack == this.startStack) {
                if (this.exceptionsToWalk != 0) {
                    J9ExceptionHandlerPointer j9ExceptionHandlerPointer = ROMHelp.J9EXCEPTIONINFO_HANDLERS(this.exceptionData);
                    this.liveStack.reset();
                    this.PUSH((byte)1);
                    while (this.exceptionsToWalk > 0) {
                        this.pushStack(j9ExceptionHandlerPointer.add(--this.exceptionsToWalk).handlerPC().intValue());
                    }
                } else {
                    return -5;
                }
            }
            this.popStack();
            return 0;
        }

        public byte POP() throws CorruptDataException {
            logger.logp(Level.FINEST, "StackMap_V1", "POP", "POP()");
            return this.liveStack.POP();
        }

        private void PUSH(int n) throws CorruptDataException {
            this.PUSH((byte)n);
        }

        public void PUSH(byte by) throws CorruptDataException {
            logger.logp(Level.FINEST, "StackMap_V1", "PUSH", "PUSH({0})", by);
            this.liveStack.PUSH(by);
        }

        private int outputStackMap(int[] nArray, int n) throws CorruptDataException {
            int n2 = this.resultStack.stackSize();
            if (n2 > 0 && nArray != null) {
                for (int i = 0; i < n2 - n; ++i) {
                    this.resultStack.POP();
                }
                int n3 = n - 1 >> 5;
                nArray[n3] = 0;
                while (true) {
                    int n4 = n3;
                    nArray[n4] = nArray[n4] << 1;
                    if (this.resultStack.POP() == 1) {
                        int n5 = n3;
                        nArray[n5] = nArray[n5] | 1;
                    }
                    if (--n == 0) break;
                    if ((n & 0x1F) != 0) continue;
                    nArray[++n3] = 0;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("outputStackMap. bits = ");
                stringBuffer.append(n);
                if (nArray != null) {
                    stringBuffer.append(" resultsArray size = ");
                    stringBuffer.append(nArray.length);
                    stringBuffer.append(" result: ");
                    for (int i = 0; i < nArray.length; ++i) {
                        stringBuffer.append(Integer.toHexString(nArray[i]));
                    }
                } else {
                    stringBuffer.append(" resultsArray = null");
                }
                logger.logp(Level.FINE, "StackMap_V1", "outputStackMap", stringBuffer.toString());
            }
            return n2;
        }
    }

    private static class J9MappingStack {
        public int pc;
        private int topOfStack = 0;
        private byte[] stack;

        public J9MappingStack(int n) {
            this.stack = new byte[n];
        }

        public J9MappingStack(J9MappingStack j9MappingStack) {
            this.stack = new byte[j9MappingStack.stack.length];
            System.arraycopy(j9MappingStack.stack, 0, this.stack, 0, j9MappingStack.topOfStack);
            this.topOfStack = j9MappingStack.topOfStack;
        }

        public void PUSH(byte by) throws CorruptDataException {
            if (this.topOfStack >= this.stack.length) {
                throw new CorruptDataException("Operand stack overflow. Stack size = " + this.stack.length + ", top of stack " + this.topOfStack);
            }
            this.stack[this.topOfStack++] = by;
        }

        public byte POP() throws CorruptDataException {
            if (this.topOfStack == 0) {
                throw new CorruptDataException("Operand stack underflow in StackMap");
            }
            return this.stack[--this.topOfStack];
        }

        public void reset() {
            this.topOfStack = 0;
        }

        public int stackSize() {
            return this.topOfStack;
        }
    }

    private static interface IStackMap {
        public int j9stackmap_StackBitsForPC(UDATA var1, J9ROMClassPointer var2, J9ROMMethodPointer var3, int[] var4, int var5) throws CorruptDataException;
    }
}

