/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.structure.WSAData;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=WSAData.class)
public class WSADataPointer
extends StructurePointer {
    public static final WSADataPointer NULL = new WSADataPointer(0L);

    protected WSADataPointer(long l) {
        super(l);
    }

    public static WSADataPointer cast(AbstractPointer abstractPointer) {
        return WSADataPointer.cast(abstractPointer.getAddress());
    }

    public static WSADataPointer cast(UDATA uDATA) {
        return WSADataPointer.cast(uDATA.longValue());
    }

    public static WSADataPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new WSADataPointer(l);
    }

    @Override
    public WSADataPointer add(long l) {
        return WSADataPointer.cast(this.address + WSAData.SIZEOF * l);
    }

    @Override
    public WSADataPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public WSADataPointer addOffset(long l) {
        return WSADataPointer.cast(this.address + l);
    }

    @Override
    public WSADataPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public WSADataPointer sub(long l) {
        return WSADataPointer.cast(this.address - WSAData.SIZEOF * l);
    }

    @Override
    public WSADataPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public WSADataPointer subOffset(long l) {
        return WSADataPointer.cast(this.address - l);
    }

    @Override
    public WSADataPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public WSADataPointer untag(long l) {
        return WSADataPointer.cast(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public WSADataPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return WSAData.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_iMaxSocketsOffset_", declaredType="U16")
    public U16 iMaxSockets() throws CorruptDataException {
        return new U16(this.getShortAtOffset(WSAData._iMaxSocketsOffset_));
    }

    public U16Pointer iMaxSocketsEA() throws CorruptDataException {
        return U16Pointer.cast(this.nonNullFieldEA(WSAData._iMaxSocketsOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_iMaxUdpDgOffset_", declaredType="U16")
    public U16 iMaxUdpDg() throws CorruptDataException {
        return new U16(this.getShortAtOffset(WSAData._iMaxUdpDgOffset_));
    }

    public U16Pointer iMaxUdpDgEA() throws CorruptDataException {
        return U16Pointer.cast(this.nonNullFieldEA(WSAData._iMaxUdpDgOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_lpVendorInfoOffset_", declaredType="U8*")
    public U8Pointer lpVendorInfo() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(WSAData._lpVendorInfoOffset_));
    }

    public PointerPointer lpVendorInfoEA() throws CorruptDataException {
        return PointerPointer.cast(this.nonNullFieldEA(WSAData._lpVendorInfoOffset_));
    }

    public U8Pointer szDescriptionEA() throws CorruptDataException {
        return U8Pointer.cast(this.nonNullFieldEA(WSAData._szDescriptionOffset_));
    }

    public U8Pointer szSystemStatusEA() throws CorruptDataException {
        return U8Pointer.cast(this.nonNullFieldEA(WSAData._szSystemStatusOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_wHighVersionOffset_", declaredType="U16")
    public U16 wHighVersion() throws CorruptDataException {
        return new U16(this.getShortAtOffset(WSAData._wHighVersionOffset_));
    }

    public U16Pointer wHighVersionEA() throws CorruptDataException {
        return U16Pointer.cast(this.nonNullFieldEA(WSAData._wHighVersionOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_wVersionOffset_", declaredType="U16")
    public U16 wVersion() throws CorruptDataException {
        return new U16(this.getShortAtOffset(WSAData._wVersionOffset_));
    }

    public U16Pointer wVersionEA() throws CorruptDataException {
        return U16Pointer.cast(this.nonNullFieldEA(WSAData._wVersionOffset_));
    }
}

