/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9LineNumberPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm29.types.U32;

public class J9MethodDebugInfoHelper {
    public static U32 getLineNumberCount(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
        U32 u32 = new U32(j9MethodDebugInfoPointer.lineNumberCount());
        if (AlgorithmVersion.getVersionOf("VM_LINE_NUMBER_TABLE_VERSION").getAlgorithmVersion() < 1) {
            return u32;
        }
        if (u32.bitAnd(1).eq(0L)) {
            return u32.rightShift(1).bitAnd(Short.MAX_VALUE);
        }
        return u32.rightShift(1);
    }

    public static J9LineNumberPointer getLineNumberTableForROMClass(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
        if (!j9MethodDebugInfoPointer.lineNumberCount().eq(0L)) {
            return J9LineNumberPointer.cast(j9MethodDebugInfoPointer.add(1L));
        }
        return J9LineNumberPointer.NULL;
    }

    public static U8Pointer getCompressedLineNumberTableForROMClassV1(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
        if (!J9MethodDebugInfoHelper.getLineNumberCount(j9MethodDebugInfoPointer).eq(0L)) {
            if (j9MethodDebugInfoPointer.lineNumberCount().bitAnd(1).eq(1L)) {
                return U8Pointer.cast(j9MethodDebugInfoPointer.add(1L)).add(4L);
            }
            return U8Pointer.cast(j9MethodDebugInfoPointer.add(1L));
        }
        return U8Pointer.NULL;
    }

    public static U32 getLineNumberCompressedSize(J9MethodDebugInfoPointer j9MethodDebugInfoPointer) throws CorruptDataException {
        U32 u32 = new U32(j9MethodDebugInfoPointer.lineNumberCount());
        if (u32.bitAnd(1).eq(0L)) {
            return u32.rightShift(16).bitAnd(65535);
        }
        return U32Pointer.cast(j9MethodDebugInfoPointer.add(1L)).at(0L);
    }
}

