/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPuddlePointer;
import java.io.PrintStream;

public class DumpAllClassloadersCommand
extends Command {
    public DumpAllClassloadersCommand() {
        this.addCommand("dumpallclassloaders", "", "dump all class loaders");
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("dumpallclassloaders - dump all class loaders");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 0) {
            this.printUsage(printStream);
            return;
        }
        try {
            if (J9BuildFlags.J9VM_ENV_DATA64) {
                printStream.append("+------------------------------------------------------------------------- \n");
                printStream.append("|    ClassLoader    | SharedLibraries | ClassHashTable  |   jniIDs Pool   |\n");
                printStream.append("|                   |      Pool       |                 |                 |\n");
                printStream.append("|                   |-----------------+-----------------+-----------------| \n");
                printStream.append("|      Address      | used | capacity | used | capacity | used | capacity |\n");
                printStream.append("+-------------------+-----------------+-----------------+----------------- \n");
            } else {
                printStream.append("+----------------------------------------------------------------- \n");
                printStream.append("|ClassLoader| SharedLibraries | ClassHashTable  |   jniIDs Pool   |\n");
                printStream.append("|           |      Pool       |                 |                 |\n");
                printStream.append("|           |-----------------+-----------------+-----------------| \n");
                printStream.append("| Address   | used | capacity | used | capacity | used | capacity |\n");
                printStream.append("+-----------+-----------------+-----------------+----------------- \n");
            }
            GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
            while (gCClassLoaderIterator.hasNext()) {
                long l;
                long l2;
                long l3;
                long l4;
                Object object;
                J9PoolPointer j9PoolPointer;
                long l5;
                long l6;
                Object object2;
                J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
                String string2 = j9ClassLoaderPointer.getHexAddress();
                J9PoolPointer j9PoolPointer2 = j9ClassLoaderPointer.sharedLibraries();
                if (!j9PoolPointer2.isNull()) {
                    object2 = Pool.fromJ9Pool(j9PoolPointer2, J9PoolPuddlePointer.class);
                    l6 = ((Pool)object2).numElements();
                    l5 = ((Pool)object2).capacity();
                } else {
                    l6 = 0L;
                    l5 = 0L;
                }
                object2 = j9ClassLoaderPointer.classHashTable();
                if (!((AbstractPointer)object2).isNull()) {
                    if (!((J9HashTablePointer)object2).listNodePool().isNull()) {
                        j9PoolPointer = ((J9HashTablePointer)object2).listNodePool();
                        object = Pool.fromJ9Pool(j9PoolPointer, J9PoolPuddlePointer.class);
                        l4 = ((Pool)object).numElements();
                        l3 = ((Pool)object).capacity();
                    } else {
                        l4 = ((J9HashTablePointer)object2).numberOfNodes().longValue();
                        l3 = ((J9HashTablePointer)object2).tableSize().longValue();
                    }
                } else {
                    l4 = 0L;
                    l3 = 0L;
                }
                j9PoolPointer = j9ClassLoaderPointer.jniIDs();
                if (!j9PoolPointer.isNull()) {
                    object = Pool.fromJ9Pool(j9PoolPointer, J9PoolPuddlePointer.class);
                    l2 = ((Pool)object).numElements();
                    l = ((Pool)object).capacity();
                } else {
                    l2 = 0L;
                    l = 0L;
                }
                object = this.format(string2, l6, l5, l4, l3, l2, l);
                printStream.println((String)object);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private String format(String string, long l, long l2, long l3, long l4, long l5, long l6) {
        String string2 = " %s%4d%" + (7 - Long.toString(l).length() + Long.toString(l2).length()) + "d%" + (11 - Long.toString(l2).length() + Long.toString(l3).length()) + "d%" + (7 - Long.toString(l3).length() + Long.toString(l4).length()) + "d%" + (11 - Long.toString(l4).length() + Long.toString(l5).length()) + "d%" + (7 - Long.toString(l5).length() + Long.toString(l6).length()) + "d";
        String string3 = String.format(string2, string, l, l2, l3, l4, l5, l6);
        return string3;
    }
}

