/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpModuleCommand
extends Command {
    public DumpModuleCommand() {
        this.addCommand("dumpmodule", "[all|requires|exports|classes|packages] <moduleAddress>|help", "List details about a module");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        Subcommand subcommand;
        ModularityHelper.ClassIteratorFilter classIteratorFilter = null;
        ModularityHelper.ClassOutput classOutput = null;
        ModularityHelper.ModuleIteratorFilter moduleIteratorFilter = null;
        ModularityHelper.ModuleOutput moduleOutput = null;
        ModularityHelper.PackageIteratorFilter packageIteratorFilter = null;
        ModularityHelper.PackageOutput packageOutput = null;
        String string2 = null;
        block2 : switch (stringArray.length) {
            case 1: {
                switch (stringArray[0]) {
                    case "help": {
                        subcommand = Subcommand.HELP;
                        break block2;
                    }
                }
                string2 = stringArray[0];
                subcommand = Subcommand.ALL;
                break;
            }
            case 2: {
                string2 = stringArray[1];
                switch (stringArray[0]) {
                    case "all": {
                        subcommand = Subcommand.ALL;
                        break block2;
                    }
                    case "requires": {
                        moduleIteratorFilter = DumpModuleCommand::filterModuleRequired;
                        moduleOutput = ModularityHelper::printJ9Module;
                        subcommand = Subcommand.MODULE;
                        break block2;
                    }
                    case "exports": {
                        packageIteratorFilter = DumpModuleCommand::filterPackageModuleAndExport;
                        packageOutput = ModularityHelper::printPackageExportVerbose;
                        subcommand = Subcommand.PACKAGE;
                        break block2;
                    }
                    case "classes": {
                        classIteratorFilter = DumpModuleCommand::filterClassByModule;
                        classOutput = ModularityHelper::printJ9Class;
                        subcommand = Subcommand.CLASS;
                        break block2;
                    }
                    case "packages": {
                        packageIteratorFilter = DumpModuleCommand::filterPackageModule;
                        packageOutput = ModularityHelper::printJ9Package;
                        subcommand = Subcommand.PACKAGE;
                        break block2;
                    }
                }
                subcommand = Subcommand.INVALID;
                break;
            }
            default: {
                subcommand = Subcommand.INVALID;
            }
        }
        try {
            J9ModulePointer j9ModulePointer = null;
            J9ClassLoaderPointer j9ClassLoaderPointer = null;
            if (null != string2) {
                try {
                    j9ModulePointer = J9ModulePointer.cast(Long.decode(string2));
                    j9ClassLoaderPointer = j9ModulePointer.classLoader();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DDRInteractiveCommandException("The argument \"" + string2 + "\" is not a valid number. It should be the address of a J9Module.");
                }
                catch (NullPointerException nullPointerException) {
                    throw new DDRInteractiveCommandException("The argument \"" + string2 + "\" is not the address of a valid J9Module.");
                }
                catch (MemoryFault memoryFault) {
                    System.out.println(memoryFault.getMessage());
                    throw new DDRInteractiveCommandException("The argument \"" + string2 + "\" is not the address of a valid J9Module.");
                }
            }
            switch (subcommand) {
                case CLASS: {
                    int n = ModularityHelper.iterateClassLoaderClasses(printStream, classIteratorFilter, classOutput, string2, j9ClassLoaderPointer);
                    System.out.printf("Found %d class%s%n", n, 1 == n ? "" : "es");
                    break;
                }
                case MODULE: {
                    int n = ModularityHelper.iterateModules(printStream, moduleIteratorFilter, moduleOutput, string2);
                    System.out.printf("Found %d module%s%n", n, 1 == n ? "" : "s");
                    break;
                }
                case PACKAGE: {
                    int n = ModularityHelper.iterateClassLoaderPackages(printStream, packageIteratorFilter, packageOutput, string2, j9ClassLoaderPointer);
                    System.out.printf("Found %d package%s%n", n, 1 == n ? "" : "s");
                    break;
                }
                case ALL: {
                    printStream.println("Module:");
                    ModularityHelper.printJ9Module(j9ModulePointer, printStream);
                    printStream.println("Requires:");
                    moduleIteratorFilter = DumpModuleCommand::filterModuleRequired;
                    moduleOutput = ModularityHelper::printJ9Module;
                    int n = ModularityHelper.iterateModules(printStream, moduleIteratorFilter, moduleOutput, string2);
                    System.out.printf("Found %d required module%s%n", n, 1 == n ? "" : "s");
                    printStream.println("Exports:");
                    packageIteratorFilter = DumpModuleCommand::filterPackageModuleAndExport;
                    packageOutput = ModularityHelper::printPackageExportVerbose;
                    n = ModularityHelper.iteratePackages(printStream, packageIteratorFilter, packageOutput, string2);
                    System.out.printf("Found %d exported package%s%n", n, 1 == n ? "" : "s");
                    break;
                }
                case HELP: {
                    DumpModuleCommand.printHelp(printStream);
                    break;
                }
                default: {
                    printStream.println("Argument failed to parse or was parsed to an unhandled subcommand.");
                    DumpModuleCommand.printHelp(printStream);
                    break;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private static boolean filterClassByModule(J9ClassPointer j9ClassPointer, String string) throws CorruptDataException {
        String string2 = j9ClassPointer.module().getHexAddress();
        return string.equalsIgnoreCase(string2);
    }

    private static boolean filterModuleRequired(J9ModulePointer j9ModulePointer, String string) throws CorruptDataException {
        boolean bl = false;
        J9HashTablePointer j9HashTablePointer = j9ModulePointer.readAccessHashTable();
        HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9HashTablePointer);
        Iterator iterator = hashTable.iterator();
        while (iterator.hasNext()) {
            J9ModulePointer j9ModulePointer2 = (J9ModulePointer)iterator.next();
            String string2 = j9ModulePointer2.getHexAddress();
            if (!string.equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean filterPackageExported(J9PackagePointer j9PackagePointer, String string) throws CorruptDataException {
        boolean bl = false;
        if (j9PackagePointer.exportToAll().isZero() && j9PackagePointer.exportToAllUnnamed().isZero()) {
            J9HashTablePointer j9HashTablePointer = j9PackagePointer.exportsHashTable();
            HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9HashTablePointer);
            Iterator iterator = hashTable.iterator();
            if (iterator.hasNext()) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private static boolean filterPackageModule(J9PackagePointer j9PackagePointer, String string) throws CorruptDataException {
        return j9PackagePointer.module().getHexAddress().equals(string);
    }

    private static boolean filterPackageModuleAndExport(J9PackagePointer j9PackagePointer, String string) throws CorruptDataException {
        return DumpModuleCommand.filterPackageModule(j9PackagePointer, string) && DumpModuleCommand.filterPackageExported(j9PackagePointer, string);
    }

    private static void printHelp(PrintStream printStream) {
        printStream.println("Usage:");
        printStream.println("  !dumpmodule <moduleAddress>");
        printStream.println("      Lists !dumpmodule all <moduleAddress>");
        printStream.println("  !dumpmodule all <moduleAddress>");
        printStream.println("      Lists the requires and exports of the target module");
        printStream.println("  !dumpmodule requires <moduleAddress>");
        printStream.println("      Lists all modules required by the target module");
        printStream.println("  !dumpmodule exports <moduleAddress>");
        printStream.println("      Lists all packages exported by the target module");
        printStream.println("  !dumpmodule classes <moduleAddress>");
        printStream.println("      Lists all loaded classes in the target module");
        printStream.println("  !dumpmodule packages <moduleAddress>");
        printStream.println("      Lists all packages in the target module");
    }

    static enum Subcommand {
        CLASS,
        MODULE,
        PACKAGE,
        ALL,
        HELP,
        INVALID;

    }
}

