/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.Message;
import java.util.ArrayList;

public class Component {
    private String name;
    private byte[] nameBytes;
    ArrayList messageList;
    private int base;

    public Component(String string) {
        this.name = string;
        this.nameBytes = string.getBytes();
        this.messageList = new ArrayList();
        this.base = -1;
    }

    public void setBase(int n) {
        this.base = n;
    }

    public String getName() {
        return this.name;
    }

    public void addMessage(Message message) {
        this.messageList.add(message);
    }

    public Message getMessageByID(int n) {
        if (n < 0) {
            return null;
        }
        if (this.base == -1) {
            if (n >= this.messageList.size()) {
                return null;
            }
            return (Message)this.messageList.get(n);
        }
        if (n - this.base >= this.messageList.size()) {
            return null;
        }
        return (Message)this.messageList.get(n - this.base);
    }

    public void addMessage(Message message, int n) {
        if (this.base == -1) {
            throw new Error("must set base before adding an IDed message");
        }
        int n2 = this.messageList.size();
        n -= this.base;
        for (int i = 0; i < n + 1 - n2; ++i) {
            this.messageList.add(null);
        }
        this.messageList.add(n, message);
        this.messageList.remove(n + 1);
    }

    public int compareTo(byte[] byArray) {
        int n = this.nameBytes.length;
        if (n > byArray.length) {
            return 1;
        }
        if (n < byArray.length) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (this.nameBytes[i] == byArray[i]) continue;
            return this.nameBytes[i] > byArray[i] ? 1 : -1;
        }
        return 0;
    }
}

