/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.util.Msg;
import java.io.File;
import java.io.IOException;
import openj9.internal.tools.attach.target.Advertisement;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.CommonDirectory;
import openj9.internal.tools.attach.target.IPC;

public final class TargetDirectory {
    private static final int VARIANT_LIMIT = 100;
    static final int ADVERTISEMENT_FILE_PERMISSIONS = 384;
    static final String ATTACH_NOTIFICATION_SYNC_FILENAME = "attachNotificationSync";
    public static final int SYNC_FILE_PERMISSIONS = 438;
    private static final int TARGET_DIRECTORY_PERMISSIONS = 438;
    private static volatile File targetDirectoryFileObject;
    private static volatile File syncFileObject;
    private static volatile File advertisementFileObject;

    static String createMyDirectory(String string, boolean bl) throws IOException {
        Object object;
        int n;
        String string2 = string;
        File file = new File(TargetDirectory.getTargetDirectoryPath(string2));
        if (file.exists()) {
            IPC.logMessage("target directory file conflict: ", file.getAbsolutePath());
            if (bl) {
                TargetDirectory.deleteMyDirectory(false, string2);
            }
            CommonDirectory.deleteStaleDirectories(null);
        }
        String string3 = Advertisement.getFilename();
        if (!bl) {
            for (n = 0; file.exists() && n < 100; ++n) {
                string2 = string + '_' + n;
                IPC.logMessage("try VMID ", string2);
                file = new File(TargetDirectory.getTargetDirectoryPath(string2));
            }
        }
        if (!file.exists() && n <= 100) {
            object = file.getAbsolutePath();
            IPC.mkdirWithPermissions((String)object, 438);
            IPC.checkOwnerAccessOnly((String)object);
        } else {
            if (!bl) {
                IPC.logMessage("Attach API target directory already exists but is unusable for VMID ", string);
                throw new IOException(Msg.getString("K0547", string));
            }
            IPC.logMessage("Attach API target directory already exists and reused for VMID: ", string);
        }
        object = new File(file, "replyInfo");
        if (((File)object).exists()) {
            String string4 = ((File)object).getAbsolutePath();
            IPC.logMessage("Illegal file in target directory: ", string4);
            throw new IOException(Msg.getString("K0804", string4));
        }
        targetDirectoryFileObject = file;
        syncFileObject = TargetDirectory.createSyncFileObject(string2);
        if (null == syncFileObject) {
            string2 = null;
            IPC.logMessage("createSyncFileObject failed");
        } else {
            TargetDirectory.createMySyncFile();
            advertisementFileObject = new File(targetDirectoryFileObject, string3);
            if (advertisementFileObject.exists() && !advertisementFileObject.delete()) {
                String string5 = advertisementFileObject.getAbsolutePath();
                IPC.logMessage("Illegal file found in target directory:", string5);
                throw new IOException(Msg.getString("K0804", string5));
            }
        }
        return string2;
    }

    static boolean deleteMyFiles() {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("deleting my files: attachInfo files and attachNotificationSync files.");
        }
        if (null == advertisementFileObject || !advertisementFileObject.delete()) {
            return false;
        }
        IPC.logMessage("deleted ", advertisementFileObject.getAbsolutePath());
        advertisementFileObject = null;
        if (null == syncFileObject || !syncFileObject.delete()) {
            return false;
        }
        IPC.logMessage("deleted ", syncFileObject.getAbsolutePath());
        syncFileObject = null;
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("deleted my files with success.");
        }
        return true;
    }

    private static boolean isHeavyweightRequiredAfterFastpathDeletion(boolean bl) {
        if (1 != IPC.loggingStatus) {
            IPC.logMessage("deleting my directory ");
        }
        return !bl && !TargetDirectory.deleteMyFiles() || null == targetDirectoryFileObject || !targetDirectoryFileObject.delete();
    }

    static void deleteMyDirectory(boolean bl) {
        if (TargetDirectory.isHeavyweightRequiredAfterFastpathDeletion(bl)) {
            TargetDirectory.deleteTargetDirectory(AttachHandler.getVmId());
        }
    }

    static void deleteMyDirectory(boolean bl, String string) {
        if (TargetDirectory.isHeavyweightRequiredAfterFastpathDeletion(bl)) {
            IPC.logMessage("fast path for deleting files and dirs fail, trying the heavyweight path for vmId: ", string);
            TargetDirectory.deleteTargetDirectory(string);
        }
    }

    public static void deleteTargetDirectory(String string) {
        if (null != string && 0 != string.length()) {
            File file = new File(TargetDirectory.getTargetDirectoryPath(string));
            File[] fileArray = file.listFiles();
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("deleting target directory ", file.getAbsolutePath());
            }
            if (null != fileArray) {
                for (File file2 : fileArray) {
                    if (!file2.delete()) {
                        IPC.logMessage("error deleting directory ", file2.getAbsolutePath());
                        continue;
                    }
                    if (1 == IPC.loggingStatus) continue;
                    IPC.logMessage("deleted file ", file2.getAbsolutePath());
                }
            }
            if (!file.delete()) {
                IPC.logMessage("error deleting directory ", file.getAbsolutePath());
            } else if (1 != IPC.loggingStatus) {
                IPC.logMessage("deleted directory ", file.getAbsolutePath());
            }
        } else {
            IPC.logMessage("skip deleteTargetDirectory since the vmid was never set - we didn't create the directory");
        }
    }

    static boolean ensureMyAdvertisementExists(String string) {
        if (!AttachHandler.isAttachApiInitialized()) {
            IPC.logMessage("ensureTargetDirectoryExists: attach API not initialized");
            return false;
        }
        if (!advertisementFileObject.exists()) {
            IPC.logMessage("ensureTargetDirectoryExists: advertisement file missing");
            try {
                if (null == TargetDirectory.createMyDirectory(string, true)) {
                    IPC.logMessage("ensureTargetDirectoryExists: error creating target directory");
                    return false;
                }
                Advertisement.createAdvertisementFile(string, AttachHandler.getMainHandler().getDisplayName());
            }
            catch (IOException iOException) {
                IPC.logMessage("ensureTargetDirectoryExists: IOException creating advertisement file");
                return false;
            }
        }
        return true;
    }

    static void createMySyncFile() throws IOException {
        if (!AttachHandler.isAttachApiTerminated()) {
            File file = syncFileObject;
            if (null == file) {
                IPC.logMessage("createMySyncFile aborted due to null syncFileObject");
            } else if (!file.exists()) {
                if (!file.createNewFile()) {
                    IPC.logMessage(file.getName(), " already exists");
                }
                IPC.chmod(file.getAbsolutePath(), 438);
            }
        }
    }

    public static File createSyncFileObject(String string) {
        String string2 = TargetDirectory.getTargetDirectoryPath(string);
        if (null == string2) {
            return null;
        }
        File file = new File(string2, ATTACH_NOTIFICATION_SYNC_FILENAME);
        return file;
    }

    public static String getTargetDirectoryPath(String string) {
        File file = CommonDirectory.getCommonDirFileObject();
        if (null == string || null == file) {
            return null;
        }
        return new File(file, string).getPath();
    }

    static File getTargetDirectoryFileObject() {
        return targetDirectoryFileObject;
    }

    static File getSyncFileObject() {
        return syncFileObject;
    }

    static File getAdvertisementFileObject() {
        return advertisementFileObject;
    }
}

