/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.ImageWatched;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;
import sun.awt.image.ToolkitImage;

public class ImageRepresentation
extends ImageWatched
implements ImageConsumer {
    InputStreamImageSource src;
    ToolkitImage image;
    int tag;
    long pData;
    int width = -1;
    int height = -1;
    int hints;
    int availinfo;
    Rectangle newbits;
    BufferedImage bimage;
    WritableRaster biRaster;
    protected ColorModel cmodel;
    ColorModel srcModel = null;
    int[] srcLUT = null;
    int srcLUTtransIndex = -1;
    int numSrcLUT = 0;
    boolean forceCMhint;
    int sstride;
    boolean isDefaultBI = false;
    boolean isSameCM = false;
    static boolean s_useNative;
    private boolean consuming = false;
    private int numWaiters;

    private static native void initIDs();

    public ImageRepresentation(ToolkitImage toolkitImage, ColorModel colorModel, boolean bl) {
        this.image = toolkitImage;
        if (this.image.getSource() instanceof InputStreamImageSource) {
            this.src = (InputStreamImageSource)this.image.getSource();
        }
        this.setColorModel(colorModel);
        this.forceCMhint = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reconstruct(int n) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        int n2 = n & ~this.availinfo;
        if ((this.availinfo & 0x40) == 0 && n2 != 0) {
            ++this.numWaiters;
            try {
                this.startProduction();
                n2 = n & ~this.availinfo;
                while ((this.availinfo & 0x40) == 0 && n2 != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        this.decrementWaiters();
                        return;
                    }
                    n2 = n & ~this.availinfo;
                }
            }
            finally {
                this.decrementWaiters();
            }
        }
    }

    @Override
    public void setDimensions(int n, int n2) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.image.setDimensions(n, n2);
        this.newInfo(this.image, 3, 0, 0, n, n2);
        if (n <= 0 || n2 <= 0) {
            this.imageComplete(1);
            return;
        }
        if (this.width != n || this.height != n2) {
            this.bimage = null;
        }
        this.width = n;
        this.height = n2;
        this.availinfo |= 3;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    ColorModel getColorModel() {
        return this.cmodel;
    }

    BufferedImage getBufferedImage() {
        return this.bimage;
    }

    protected BufferedImage createImage(ColorModel colorModel, WritableRaster writableRaster, boolean bl, Hashtable hashtable) {
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, bl, null);
        bufferedImage.setAccelerationPriority(this.image.getAccelerationPriority());
        return bufferedImage;
    }

    @Override
    public void setProperties(Hashtable<?, ?> hashtable) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.image.setProperties(hashtable);
        this.newInfo(this.image, 4, 0, 0, 0, 0);
    }

    @Override
    public void setColorModel(ColorModel colorModel) {
        DirectColorModel directColorModel;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.srcModel = colorModel;
        if (colorModel instanceof IndexColorModel) {
            if (colorModel.getTransparency() == 3) {
                this.cmodel = ColorModel.getRGBdefault();
                this.srcLUT = null;
            } else {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                this.numSrcLUT = indexColorModel.getMapSize();
                this.srcLUT = new int[Math.max(this.numSrcLUT, 256)];
                indexColorModel.getRGBs(this.srcLUT);
                this.srcLUTtransIndex = indexColorModel.getTransparentPixel();
                this.cmodel = colorModel;
            }
        } else if (this.cmodel == null) {
            this.cmodel = colorModel;
            this.srcLUT = null;
        } else if (colorModel instanceof DirectColorModel && (directColorModel = (DirectColorModel)colorModel).getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255) {
            this.cmodel = colorModel;
            this.srcLUT = null;
        }
        this.isSameCM = this.cmodel == colorModel;
    }

    void createBufferedImage() {
        DirectColorModel directColorModel;
        this.isDefaultBI = false;
        try {
            this.biRaster = this.cmodel.createCompatibleWritableRaster(this.width, this.height);
            this.bimage = this.createImage(this.cmodel, this.biRaster, this.cmodel.isAlphaPremultiplied(), null);
        }
        catch (Exception exception) {
            this.cmodel = ColorModel.getRGBdefault();
            this.biRaster = this.cmodel.createCompatibleWritableRaster(this.width, this.height);
            this.bimage = this.createImage(this.cmodel, this.biRaster, false, null);
        }
        int n = this.bimage.getType();
        if (this.cmodel == ColorModel.getRGBdefault() || n == 1 || n == 3) {
            this.isDefaultBI = true;
        } else if (this.cmodel instanceof DirectColorModel && (directColorModel = (DirectColorModel)this.cmodel).getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255) {
            this.isDefaultBI = true;
        }
    }

    private void convertToRGB() {
        Object object;
        int n = this.bimage.getWidth();
        int n2 = this.bimage.getHeight();
        int n3 = n * n2;
        DataBufferInt dataBufferInt = new DataBufferInt(n3);
        int[] nArray = SunWritableRaster.stealData(dataBufferInt, 0);
        if (this.cmodel instanceof IndexColorModel && this.biRaster instanceof ByteComponentRaster && this.biRaster.getNumDataElements() == 1) {
            object = (ByteComponentRaster)this.biRaster;
            byte[] byArray = ((ByteComponentRaster)object).getDataStorage();
            int n4 = ((ByteComponentRaster)object).getDataOffset(0);
            for (int i = 0; i < n3; ++i) {
                nArray[i] = this.srcLUT[byArray[n4 + i] & 0xFF];
            }
        } else {
            object = null;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    object = this.biRaster.getDataElements(j, i, object);
                    nArray[n5++] = this.cmodel.getRGB(object);
                }
            }
        }
        SunWritableRaster.markDirty(dataBufferInt);
        this.isSameCM = false;
        this.cmodel = ColorModel.getRGBdefault();
        object = new int[]{0xFF0000, 65280, 255, -16777216};
        this.biRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, (int[])object, null);
        this.bimage = this.createImage(this.cmodel, this.biRaster, this.cmodel.isAlphaPremultiplied(), null);
        this.srcLUT = null;
        this.isDefaultBI = true;
    }

    @Override
    public void setHints(int n) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.hints = n;
    }

    private native boolean setICMpixels(int var1, int var2, int var3, int var4, int[] var5, byte[] var6, int var7, int var8, IntegerComponentRaster var9);

    private native boolean setDiffICM(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7, IndexColorModel var8, byte[] var9, int var10, int var11, ByteComponentRaster var12, int var13);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        block34: {
            int n7;
            block40: {
                int[] nArray;
                Object object;
                block39: {
                    int[] nArray2;
                    block38: {
                        int n8;
                        Object object2;
                        block35: {
                            block36: {
                                block37: {
                                    n7 = n5;
                                    Object var11_10 = null;
                                    if (this.src != null) {
                                        this.src.checkSecurity(null, false);
                                    }
                                    ImageRepresentation imageRepresentation = this;
                                    // MONITORENTER : imageRepresentation
                                    if (this.bimage == null) {
                                        if (this.cmodel == null) {
                                            this.cmodel = colorModel;
                                        }
                                        this.createBufferedImage();
                                    }
                                    if (n3 <= 0 || n4 <= 0) {
                                        // MONITOREXIT : imageRepresentation
                                        return;
                                    }
                                    int n9 = this.biRaster.getWidth();
                                    int n10 = this.biRaster.getHeight();
                                    int n11 = n + n3;
                                    int n12 = n2 + n4;
                                    if (n < 0) {
                                        n5 -= n;
                                        n = 0;
                                    } else if (n11 < 0) {
                                        n11 = n9;
                                    }
                                    if (n2 < 0) {
                                        n5 -= n2 * n6;
                                        n2 = 0;
                                    } else if (n12 < 0) {
                                        n12 = n10;
                                    }
                                    if (n11 > n9) {
                                        n11 = n9;
                                    }
                                    if (n12 > n10) {
                                        n12 = n10;
                                    }
                                    if (n >= n11 || n2 >= n12) {
                                        // MONITOREXIT : imageRepresentation
                                        return;
                                    }
                                    n3 = n11 - n;
                                    n4 = n12 - n2;
                                    if (n5 < 0) throw new ArrayIndexOutOfBoundsException("Data offset out of bounds.");
                                    if (n5 >= byArray.length) {
                                        throw new ArrayIndexOutOfBoundsException("Data offset out of bounds.");
                                    }
                                    int n13 = byArray.length - n5;
                                    if (n13 < n3) {
                                        throw new ArrayIndexOutOfBoundsException("Data array is too short.");
                                    }
                                    int n14 = n6 < 0 ? n5 / -n6 + 1 : (n6 > 0 ? (n13 - n3) / n6 + 1 : n4);
                                    if (n4 > n14) {
                                        throw new ArrayIndexOutOfBoundsException("Data array is too short.");
                                    }
                                    if (this.isSameCM && this.cmodel != colorModel && this.srcLUT != null && colorModel instanceof IndexColorModel && this.biRaster instanceof ByteComponentRaster) {
                                        object2 = (IndexColorModel)colorModel;
                                        object = (ByteComponentRaster)this.biRaster;
                                        n8 = this.numSrcLUT;
                                        if (!this.setDiffICM(n, n2, n3, n4, this.srcLUT, this.srcLUTtransIndex, this.numSrcLUT, (IndexColorModel)object2, byArray, n5, n6, (ByteComponentRaster)object, ((ByteComponentRaster)object).getDataOffset(0))) {
                                            this.convertToRGB();
                                        } else {
                                            ((SunWritableRaster)object).markDirty();
                                            if (n8 != this.numSrcLUT) {
                                                int n15;
                                                boolean bl = ((ColorModel)object2).hasAlpha();
                                                if (this.srcLUTtransIndex != -1) {
                                                    bl = true;
                                                }
                                                this.cmodel = object2 = new IndexColorModel(n15, this.numSrcLUT, this.srcLUT, 0, bl, this.srcLUTtransIndex, (n15 = ((ColorModel)object2).getPixelSize()) > 8 ? 1 : 0);
                                                this.bimage = this.createImage((ColorModel)object2, (WritableRaster)object, false, null);
                                            }
                                            // MONITOREXIT : imageRepresentation
                                            return;
                                        }
                                    }
                                    if (!this.isDefaultBI) break block35;
                                    object = (IntegerComponentRaster)this.biRaster;
                                    if (this.srcLUT == null || !(colorModel instanceof IndexColorModel)) break block36;
                                    if (colorModel != this.srcModel) {
                                        ((IndexColorModel)colorModel).getRGBs(this.srcLUT);
                                        this.srcModel = colorModel;
                                    }
                                    if (!s_useNative) break block37;
                                    if (!this.setICMpixels(n, n2, n3, n4, this.srcLUT, byArray, n5, n6, (IntegerComponentRaster)object)) {
                                        this.abort();
                                        // MONITOREXIT : imageRepresentation
                                        return;
                                    }
                                    ((SunWritableRaster)object).markDirty();
                                    break block34;
                                }
                                nArray2 = new int[n3 * n4];
                                int n16 = 0;
                                break block38;
                            }
                            nArray = new int[n3];
                            break block39;
                        }
                        if (this.cmodel != colorModel || !(this.biRaster instanceof ByteComponentRaster) || this.biRaster.getNumDataElements() != 1) break block40;
                        object2 = (ByteComponentRaster)this.biRaster;
                        if (n5 == 0 && n6 == n3) {
                            ((ByteComponentRaster)object2).putByteData(n, n2, n3, n4, byArray);
                            break block34;
                        } else {
                            object = new byte[n3];
                            int n17 = n5;
                            for (n8 = n2; n8 < n2 + n4; n17 += n6, ++n8) {
                                System.arraycopy((Object)byArray, n17, object, 0, n3);
                                ((ByteComponentRaster)object2).putByteData(n, n8, n3, 1, (byte[])object);
                            }
                        }
                        break block34;
                    }
                    for (int i = 0; i < n4; ++i, n7 += n6) {
                        int n18 = n7;
                        for (int j = 0; j < n3; ++j) {
                            nArray2[n16++] = this.srcLUT[byArray[n18++] & 0xFF];
                        }
                    }
                    ((IntegerComponentRaster)object).setDataElements(n, n2, n3, n4, nArray2);
                    break block34;
                }
                for (int i = n2; i < n2 + n4; ++i, n7 += n6) {
                    int n19 = n7;
                    for (int j = 0; j < n3; ++j) {
                        nArray[j] = colorModel.getRGB(byArray[n19++] & 0xFF);
                    }
                    ((IntegerComponentRaster)object).setDataElements(n, i, n3, 1, nArray);
                }
                this.availinfo |= 8;
                break block34;
            }
            for (int i = n2; i < n2 + n4; ++i, n7 += n6) {
                int n20 = n7;
                for (int j = n; j < n + n3; ++j) {
                    this.bimage.setRGB(j, i, colorModel.getRGB(byArray[n20++] & 0xFF));
                }
            }
            this.availinfo |= 8;
        }
        // MONITOREXIT : imageRepresentation
        if ((this.availinfo & 0x10) != 0) return;
        this.newInfo(this.image, 8, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n5;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            if (this.bimage == null) {
                if (this.cmodel == null) {
                    this.cmodel = colorModel;
                }
                this.createBufferedImage();
            }
            int[] nArray2 = new int[n3];
            if (this.cmodel instanceof IndexColorModel) {
                this.convertToRGB();
            }
            if (colorModel == this.cmodel && this.biRaster instanceof IntegerComponentRaster) {
                IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)this.biRaster;
                if (n5 == 0 && n6 == n3) {
                    integerComponentRaster.setDataElements(n, n2, n3, n4, nArray);
                } else {
                    int n8 = n2;
                    while (n8 < n2 + n4) {
                        System.arraycopy((Object)nArray, n7, (Object)nArray2, 0, n3);
                        integerComponentRaster.setDataElements(n, n8, n3, 1, nArray2);
                        ++n8;
                        n7 += n6;
                    }
                }
            } else {
                if (colorModel.getTransparency() != 1) {
                    if (this.cmodel.getTransparency() == 1) {
                        this.convertToRGB();
                    }
                }
                if (this.isDefaultBI) {
                    IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)this.biRaster;
                    int[] nArray3 = integerComponentRaster.getDataStorage();
                    if (this.cmodel.equals(colorModel)) {
                        int n9 = integerComponentRaster.getScanlineStride();
                        int n10 = n2 * n9 + n;
                        int n11 = 0;
                        while (n11 < n4) {
                            System.arraycopy((Object)nArray, n7, (Object)nArray3, n10, n3);
                            n10 += n9;
                            ++n11;
                            n7 += n6;
                        }
                        integerComponentRaster.markDirty();
                    } else {
                        int n12 = n2;
                        while (n12 < n2 + n4) {
                            int n13 = n7;
                            for (int i = 0; i < n3; ++i) {
                                nArray2[i] = colorModel.getRGB(nArray[n13++]);
                            }
                            integerComponentRaster.setDataElements(n, n12, n3, 1, nArray2);
                            ++n12;
                            n7 += n6;
                        }
                    }
                    this.availinfo |= 8;
                } else {
                    Object object = null;
                    int n14 = n2;
                    while (n14 < n2 + n4) {
                        int n15 = n7;
                        for (int i = n; i < n + n3; ++i) {
                            int n16 = colorModel.getRGB(nArray[n15++]);
                            object = this.cmodel.getDataElements(n16, object);
                            this.biRaster.setDataElements(i, n14, object);
                        }
                        ++n14;
                        n7 += n6;
                    }
                    this.availinfo |= 8;
                }
            }
        }
        if ((this.availinfo & 0x10) == 0) {
            this.newInfo(this.image, 8, n, n2, n3, n4);
        }
    }

    public BufferedImage getOpaqueRGBImage() {
        if (this.bimage.getType() == 2) {
            int n = this.bimage.getWidth();
            int n2 = this.bimage.getHeight();
            int n3 = n * n2;
            DataBufferInt dataBufferInt = (DataBufferInt)this.biRaster.getDataBuffer();
            int[] nArray = SunWritableRaster.stealData(dataBufferInt, 0);
            for (int i = 0; i < n3; ++i) {
                if (nArray[i] >>> 24 == 255) continue;
                return this.bimage;
            }
            DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
            int[] nArray2 = new int[]{0xFF0000, 65280, 255};
            WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, nArray2, null);
            try {
                BufferedImage bufferedImage = this.createImage(directColorModel, writableRaster, false, null);
                return bufferedImage;
            }
            catch (Exception exception) {
                return this.bimage;
            }
        }
        return this.bimage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageComplete(int n) {
        int n2;
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        switch (n) {
            default: {
                bl = true;
                n2 = 128;
                break;
            }
            case 1: {
                this.image.addInfo(64);
                bl = true;
                n2 = 64;
                this.dispose();
                break;
            }
            case 3: {
                bl = true;
                n2 = 32;
                break;
            }
            case 2: {
                bl = false;
                n2 = 16;
            }
        }
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            if (bl) {
                this.image.getSource().removeConsumer(this);
                this.consuming = false;
                this.newbits = null;
                if (this.bimage != null) {
                    this.bimage = this.getOpaqueRGBImage();
                }
            }
            this.availinfo |= n2;
            this.notifyAll();
        }
        this.newInfo(this.image, n2, 0, 0, this.width, this.height);
        this.image.infoDone(n);
    }

    void startProduction() {
        if (!this.consuming) {
            this.consuming = true;
            this.image.getSource().startProduction(this);
        }
    }

    private synchronized void checkConsumption() {
        if (this.isWatcherListEmpty() && this.numWaiters == 0 && (this.availinfo & 0x20) == 0) {
            this.dispose();
        }
    }

    @Override
    public synchronized void notifyWatcherListEmpty() {
        this.checkConsumption();
    }

    private synchronized void decrementWaiters() {
        --this.numWaiters;
        this.checkConsumption();
    }

    public boolean prepare(ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = bl = (this.availinfo & 0x20) != 0;
        if (!bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            bl = (this.availinfo & 0x20) != 0;
        }
        return bl;
    }

    public int check(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x60) == 0) {
            this.addWatcher(imageObserver);
        }
        return this.availinfo;
    }

    public boolean drawToBufImage(Graphics graphics, ToolkitImage toolkitImage, int n, int n2, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = (this.availinfo & 0x20) != 0;
        boolean bl3 = bl = (this.availinfo & 0x80) != 0;
        if (!bl2 && !bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl4 = bl2 = (this.availinfo & 0x20) != 0;
        }
        if (bl2 || 0 != (this.availinfo & 0x10)) {
            graphics.drawImage(this.bimage, n, n2, color, null);
        }
        return bl2;
    }

    public boolean drawToBufImage(Graphics graphics, ToolkitImage toolkitImage, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = (this.availinfo & 0x20) != 0;
        boolean bl3 = bl = (this.availinfo & 0x80) != 0;
        if (!bl2 && !bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl4 = bl2 = (this.availinfo & 0x20) != 0;
        }
        if (bl2 || 0 != (this.availinfo & 0x10)) {
            graphics.drawImage(this.bimage, n, n2, n3, n4, color, null);
        }
        return bl2;
    }

    public boolean drawToBufImage(Graphics graphics, ToolkitImage toolkitImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = (this.availinfo & 0x20) != 0;
        boolean bl3 = bl = (this.availinfo & 0x80) != 0;
        if (!bl2 && !bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl4 = bl2 = (this.availinfo & 0x20) != 0;
        }
        if (bl2 || 0 != (this.availinfo & 0x10)) {
            graphics.drawImage(this.bimage, n, n2, n3, n4, n5, n6, n7, n8, color, null);
        }
        return bl2;
    }

    public boolean drawToBufImage(Graphics graphics, ToolkitImage toolkitImage, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = (this.availinfo & 0x20) != 0;
        boolean bl3 = bl = (this.availinfo & 0x80) != 0;
        if (!bl2 && !bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl4 = bl2 = (this.availinfo & 0x20) != 0;
        }
        if (bl2 || 0 != (this.availinfo & 0x10)) {
            graphics2D.drawImage(this.bimage, affineTransform, null);
        }
        return bl2;
    }

    synchronized void abort() {
        this.image.getSource().removeConsumer(this);
        this.consuming = false;
        this.newbits = null;
        this.bimage = null;
        this.biRaster = null;
        this.cmodel = null;
        this.srcLUT = null;
        this.isDefaultBI = false;
        this.isSameCM = false;
        this.newInfo(this.image, 128, -1, -1, -1, -1);
        this.availinfo &= 0xFFFFFF87;
    }

    synchronized void dispose() {
        this.image.getSource().removeConsumer(this);
        this.consuming = false;
        this.newbits = null;
        this.availinfo &= 0xFFFFFFC7;
    }

    public void setAccelerationPriority(float f) {
        if (this.bimage != null) {
            this.bimage.setAccelerationPriority(f);
        }
    }

    static {
        NativeLibLoader.loadLibraries();
        ImageRepresentation.initIDs();
        s_useNative = true;
    }
}

