/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.spi.CalendarProvider;

public class HostLocaleProviderAdapterImpl {
    private static final int CAT_DISPLAY = 0;
    private static final int CAT_FORMAT = 1;
    private static final int NF_NUMBER = 0;
    private static final int NF_CURRENCY = 1;
    private static final int NF_PERCENT = 2;
    private static final int NF_INTEGER = 3;
    private static final int NF_MAX = 3;
    private static final int CD_FIRSTDAYOFWEEK = 0;
    private static final int CD_MINIMALDAYSINFIRSTWEEK = 1;
    private static final int DN_CURRENCY_NAME = 0;
    private static final int DN_CURRENCY_SYMBOL = 1;
    private static final int DN_LOCALE_LANGUAGE = 2;
    private static final int DN_LOCALE_SCRIPT = 3;
    private static final int DN_LOCALE_REGION = 4;
    private static final int DN_LOCALE_VARIANT = 5;
    private static final String[] calIDToLDML = new String[]{"", "gregory", "gregory_en-US", "japanese", "roc", "", "islamic", "buddhist", "hebrew", "gregory_fr", "gregory_ar", "gregory_en", "gregory_fr"};
    private static ConcurrentMap<Locale, SoftReference<AtomicReferenceArray<String>>> dateFormatCache = new ConcurrentHashMap<Locale, SoftReference<AtomicReferenceArray<String>>>();
    private static ConcurrentMap<Locale, SoftReference<DateFormatSymbols>> dateFormatSymbolsCache = new ConcurrentHashMap<Locale, SoftReference<DateFormatSymbols>>();
    private static ConcurrentMap<Locale, SoftReference<AtomicReferenceArray<String>>> numberFormatCache = new ConcurrentHashMap<Locale, SoftReference<AtomicReferenceArray<String>>>();
    private static ConcurrentMap<Locale, SoftReference<DecimalFormatSymbols>> decimalFormatSymbolsCache = new ConcurrentHashMap<Locale, SoftReference<DecimalFormatSymbols>>();
    private static final Set<Locale> supportedLocaleSet;
    private static final String nativeDisplayLanguage;
    private static final Locale[] supportedLocale;

    public static DateFormatProvider getDateFormatProvider() {
        return new DateFormatProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public DateFormat getDateInstance(int n, Locale locale) {
                AtomicReferenceArray<String> atomicReferenceArray = this.getDateTimePatterns(locale);
                return new SimpleDateFormat(atomicReferenceArray.get(n / 2), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            @Override
            public DateFormat getTimeInstance(int n, Locale locale) {
                AtomicReferenceArray<String> atomicReferenceArray = this.getDateTimePatterns(locale);
                return new SimpleDateFormat(atomicReferenceArray.get(n / 2 + 2), HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            @Override
            public DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
                AtomicReferenceArray<String> atomicReferenceArray = this.getDateTimePatterns(locale);
                String string = atomicReferenceArray.get(n / 2) + " " + atomicReferenceArray.get(n2 / 2 + 2);
                return new SimpleDateFormat(string, HostLocaleProviderAdapterImpl.getCalendarLocale(locale));
            }

            private AtomicReferenceArray<String> getDateTimePatterns(Locale locale) {
                AtomicReferenceArray<String> atomicReferenceArray;
                SoftReference softReference = (SoftReference)dateFormatCache.get(locale);
                if (softReference == null || (atomicReferenceArray = (AtomicReferenceArray<String>)softReference.get()) == null) {
                    String string = HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag();
                    atomicReferenceArray = new AtomicReferenceArray<String>(4);
                    atomicReferenceArray.compareAndSet(0, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(1, -1, string)));
                    atomicReferenceArray.compareAndSet(1, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(3, -1, string)));
                    atomicReferenceArray.compareAndSet(2, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(-1, 1, string)));
                    atomicReferenceArray.compareAndSet(3, null, HostLocaleProviderAdapterImpl.convertDateTimePattern(HostLocaleProviderAdapterImpl.getDateTimePattern(-1, 3, string)));
                    softReference = new SoftReference(atomicReferenceArray);
                    dateFormatCache.put(locale, softReference);
                }
                return atomicReferenceArray;
            }
        };
    }

    public static DateFormatSymbolsProvider getDateFormatSymbolsProvider() {
        return new DateFormatSymbolsProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public DateFormatSymbols getInstance(Locale locale) {
                DateFormatSymbols dateFormatSymbols;
                SoftReference<DateFormatSymbols> softReference = (SoftReference<DateFormatSymbols>)dateFormatSymbolsCache.get(locale);
                if (softReference == null || (dateFormatSymbols = (DateFormatSymbols)softReference.get()) == null) {
                    dateFormatSymbols = new DateFormatSymbols(locale);
                    String string = HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag();
                    dateFormatSymbols.setAmPmStrings(HostLocaleProviderAdapterImpl.getAmPmStrings(string, dateFormatSymbols.getAmPmStrings()));
                    dateFormatSymbols.setEras(HostLocaleProviderAdapterImpl.getEras(string, dateFormatSymbols.getEras()));
                    dateFormatSymbols.setMonths(HostLocaleProviderAdapterImpl.getMonths(string, dateFormatSymbols.getMonths()));
                    dateFormatSymbols.setShortMonths(HostLocaleProviderAdapterImpl.getShortMonths(string, dateFormatSymbols.getShortMonths()));
                    dateFormatSymbols.setWeekdays(HostLocaleProviderAdapterImpl.getWeekdays(string, dateFormatSymbols.getWeekdays()));
                    dateFormatSymbols.setShortWeekdays(HostLocaleProviderAdapterImpl.getShortWeekdays(string, dateFormatSymbols.getShortWeekdays()));
                    softReference = new SoftReference<DateFormatSymbols>(dateFormatSymbols);
                    dateFormatSymbolsCache.put(locale, softReference);
                }
                return (DateFormatSymbols)dateFormatSymbols.clone();
            }
        };
    }

    public static NumberFormatProvider getNumberFormatProvider() {
        return new NumberFormatProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedNativeDigitLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedNativeDigitLocale(locale);
            }

            @Override
            public NumberFormat getCurrencyInstance(Locale locale) {
                AtomicReferenceArray<String> atomicReferenceArray = this.getNumberPatterns(locale);
                return new DecimalFormat(atomicReferenceArray.get(1), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getIntegerInstance(Locale locale) {
                AtomicReferenceArray<String> atomicReferenceArray = this.getNumberPatterns(locale);
                return new DecimalFormat(atomicReferenceArray.get(3), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getNumberInstance(Locale locale) {
                AtomicReferenceArray<String> atomicReferenceArray = this.getNumberPatterns(locale);
                return new DecimalFormat(atomicReferenceArray.get(0), DecimalFormatSymbols.getInstance(locale));
            }

            @Override
            public NumberFormat getPercentInstance(Locale locale) {
                AtomicReferenceArray<String> atomicReferenceArray = this.getNumberPatterns(locale);
                return new DecimalFormat(atomicReferenceArray.get(2), DecimalFormatSymbols.getInstance(locale));
            }

            private AtomicReferenceArray<String> getNumberPatterns(Locale locale) {
                AtomicReferenceArray<String> atomicReferenceArray;
                SoftReference softReference = (SoftReference)numberFormatCache.get(locale);
                if (softReference == null || (atomicReferenceArray = (AtomicReferenceArray<String>)softReference.get()) == null) {
                    String string = locale.toLanguageTag();
                    atomicReferenceArray = new AtomicReferenceArray<String>(4);
                    for (int i = 0; i <= 3; ++i) {
                        atomicReferenceArray.compareAndSet(i, null, HostLocaleProviderAdapterImpl.getNumberPattern(i, string));
                    }
                    softReference = new SoftReference(atomicReferenceArray);
                    numberFormatCache.put(locale, softReference);
                }
                return atomicReferenceArray;
            }
        };
    }

    public static DecimalFormatSymbolsProvider getDecimalFormatSymbolsProvider() {
        return new DecimalFormatSymbolsProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedNativeDigitLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedNativeDigitLocale(locale);
            }

            @Override
            public DecimalFormatSymbols getInstance(Locale locale) {
                DecimalFormatSymbols decimalFormatSymbols;
                SoftReference<DecimalFormatSymbols> softReference = (SoftReference<DecimalFormatSymbols>)decimalFormatSymbolsCache.get(locale);
                if (softReference == null || (decimalFormatSymbols = (DecimalFormatSymbols)softReference.get()) == null) {
                    decimalFormatSymbols = new DecimalFormatSymbols(HostLocaleProviderAdapterImpl.getNumberLocale(locale));
                    String string = HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag();
                    decimalFormatSymbols.setInternationalCurrencySymbol(HostLocaleProviderAdapterImpl.getInternationalCurrencySymbol(string, decimalFormatSymbols.getInternationalCurrencySymbol()));
                    decimalFormatSymbols.setCurrencySymbol(HostLocaleProviderAdapterImpl.getCurrencySymbol(string, decimalFormatSymbols.getCurrencySymbol()));
                    decimalFormatSymbols.setDecimalSeparator(HostLocaleProviderAdapterImpl.getDecimalSeparator(string, decimalFormatSymbols.getDecimalSeparator()));
                    decimalFormatSymbols.setGroupingSeparator(HostLocaleProviderAdapterImpl.getGroupingSeparator(string, decimalFormatSymbols.getGroupingSeparator()));
                    decimalFormatSymbols.setInfinity(HostLocaleProviderAdapterImpl.getInfinity(string, decimalFormatSymbols.getInfinity()));
                    decimalFormatSymbols.setMinusSign(HostLocaleProviderAdapterImpl.getMinusSign(string, decimalFormatSymbols.getMinusSign()));
                    decimalFormatSymbols.setMonetaryDecimalSeparator(HostLocaleProviderAdapterImpl.getMonetaryDecimalSeparator(string, decimalFormatSymbols.getMonetaryDecimalSeparator()));
                    decimalFormatSymbols.setNaN(HostLocaleProviderAdapterImpl.getNaN(string, decimalFormatSymbols.getNaN()));
                    decimalFormatSymbols.setPercent(HostLocaleProviderAdapterImpl.getPercent(string, decimalFormatSymbols.getPercent()));
                    decimalFormatSymbols.setPerMill(HostLocaleProviderAdapterImpl.getPerMill(string, decimalFormatSymbols.getPerMill()));
                    decimalFormatSymbols.setZeroDigit(HostLocaleProviderAdapterImpl.getZeroDigit(string, decimalFormatSymbols.getZeroDigit()));
                    softReference = new SoftReference<DecimalFormatSymbols>(decimalFormatSymbols);
                    decimalFormatSymbolsCache.put(locale, softReference);
                }
                return (DecimalFormatSymbols)decimalFormatSymbols.clone();
            }
        };
    }

    public static CalendarDataProvider getCalendarDataProvider() {
        return new CalendarDataProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public int getFirstDayOfWeek(Locale locale) {
                int n = HostLocaleProviderAdapterImpl.getCalendarDataValue(HostLocaleProviderAdapterImpl.removeExtensions(locale).toLanguageTag(), 0);
                if (n != -1) {
                    return (n + 1) % 7 + 1;
                }
                return 0;
            }

            @Override
            public int getMinimalDaysInFirstWeek(Locale locale) {
                return 0;
            }
        };
    }

    public static CalendarProvider getCalendarProvider() {
        return new CalendarProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return HostLocaleProviderAdapterImpl.getSupportedCalendarLocales();
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return HostLocaleProviderAdapterImpl.isSupportedCalendarLocale(locale);
            }

            @Override
            public Calendar getInstance(TimeZone timeZone, Locale locale) {
                return new Calendar.Builder().setLocale(HostLocaleProviderAdapterImpl.getCalendarLocale(locale)).setTimeZone(timeZone).setInstant(System.currentTimeMillis()).build();
            }
        };
    }

    public static CurrencyNameProvider getCurrencyNameProvider() {
        return new CurrencyNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions()) && locale.getLanguage().equals(nativeDisplayLanguage);
            }

            @Override
            public String getSymbol(String string, Locale locale) {
                try {
                    if (Currency.getInstance(locale).getCurrencyCode().equals(string)) {
                        return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 1, string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public String getDisplayName(String string, Locale locale) {
                try {
                    if (Currency.getInstance(locale).getCurrencyCode().equals(string)) {
                        return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 0, string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    public static LocaleNameProvider getLocaleNameProvider() {
        return new LocaleNameProvider(){

            @Override
            public Locale[] getAvailableLocales() {
                return supportedLocale;
            }

            @Override
            public boolean isSupportedLocale(Locale locale) {
                return supportedLocaleSet.contains(locale.stripExtensions()) && locale.getLanguage().equals(nativeDisplayLanguage);
            }

            @Override
            public String getDisplayLanguage(String string, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 2, string);
            }

            @Override
            public String getDisplayCountry(String string, Locale locale) {
                return HostLocaleProviderAdapterImpl.getDisplayString(locale.toLanguageTag(), 4, nativeDisplayLanguage + "-" + string);
            }

            @Override
            public String getDisplayScript(String string, Locale locale) {
                return null;
            }

            @Override
            public String getDisplayVariant(String string, Locale locale) {
                return null;
            }
        };
    }

    private static String convertDateTimePattern(String string) {
        String string2 = string.replaceAll("dddd", "EEEE");
        string2 = string2.replaceAll("ddd", "EEE");
        string2 = string2.replaceAll("tt", "aa");
        string2 = string2.replaceAll("g", "GG");
        return string2;
    }

    private static Locale[] getSupportedCalendarLocales() {
        if (supportedLocale.length != 0 && supportedLocaleSet.contains(Locale.JAPAN) && HostLocaleProviderAdapterImpl.isJapaneseCalendar()) {
            Locale[] localeArray = new Locale[supportedLocale.length + 1];
            localeArray[0] = JRELocaleConstants.JA_JP_JP;
            System.arraycopy((Object)supportedLocale, 0, (Object)localeArray, 1, supportedLocale.length);
            return localeArray;
        }
        return supportedLocale;
    }

    private static boolean isSupportedCalendarLocale(Locale locale) {
        Locale locale2 = locale;
        if (locale2.hasExtensions() || locale2.getVariant() != "") {
            locale2 = new Locale.Builder().setLocale(locale).clearExtensions().build();
        }
        if (!supportedLocaleSet.contains(locale2)) {
            return false;
        }
        int n = HostLocaleProviderAdapterImpl.getCalendarID(locale2.toLanguageTag());
        if (n <= 0 || n >= calIDToLDML.length) {
            return false;
        }
        String string = locale.getUnicodeLocaleType("ca");
        String string2 = calIDToLDML[n].replaceFirst("_.*", "");
        if (string == null) {
            return Calendar.getAvailableCalendarTypes().contains(string2);
        }
        return string.equals(string2);
    }

    private static Locale[] getSupportedNativeDigitLocales() {
        if (supportedLocale.length != 0 && supportedLocaleSet.contains(JRELocaleConstants.TH_TH) && HostLocaleProviderAdapterImpl.isNativeDigit("th-TH")) {
            Locale[] localeArray = new Locale[supportedLocale.length + 1];
            localeArray[0] = JRELocaleConstants.TH_TH_TH;
            System.arraycopy((Object)supportedLocale, 0, (Object)localeArray, 1, supportedLocale.length);
            return localeArray;
        }
        return supportedLocale;
    }

    private static boolean isSupportedNativeDigitLocale(Locale locale) {
        if (JRELocaleConstants.TH_TH_TH.equals(locale)) {
            return HostLocaleProviderAdapterImpl.isNativeDigit("th-TH");
        }
        String string = null;
        Locale locale2 = locale;
        if (locale.hasExtensions()) {
            string = locale.getUnicodeLocaleType("nu");
            locale2 = locale.stripExtensions();
        }
        if (supportedLocaleSet.contains(locale2)) {
            if (string == null || string.equals("latn")) {
                return true;
            }
            if (locale.getLanguage().equals("th")) {
                return "thai".equals(string) && HostLocaleProviderAdapterImpl.isNativeDigit(locale.toLanguageTag());
            }
        }
        return false;
    }

    private static Locale removeExtensions(Locale locale) {
        return new Locale.Builder().setLocale(locale).clearExtensions().build();
    }

    private static boolean isJapaneseCalendar() {
        return HostLocaleProviderAdapterImpl.getCalendarID("ja-JP") == 3;
    }

    private static Locale getCalendarLocale(Locale locale) {
        int n = HostLocaleProviderAdapterImpl.getCalendarID(locale.toLanguageTag());
        if (n > 0 && n < calIDToLDML.length) {
            Locale.Builder builder = new Locale.Builder();
            String[] stringArray = calIDToLDML[n].split("_");
            if (stringArray.length > 1) {
                builder.setLocale(Locale.forLanguageTag(stringArray[1]));
            } else {
                builder.setLocale(locale);
            }
            builder.setUnicodeLocaleKeyword("ca", stringArray[0]);
            return builder.build();
        }
        return locale;
    }

    private static Locale getNumberLocale(Locale locale) {
        if (JRELocaleConstants.TH_TH.equals(locale) && HostLocaleProviderAdapterImpl.isNativeDigit("th-TH")) {
            Locale.Builder builder = new Locale.Builder().setLocale(locale);
            builder.setUnicodeLocaleKeyword("nu", "thai");
            return builder.build();
        }
        return locale;
    }

    private static native boolean initialize();

    private static native String getDefaultLocale(int var0);

    private static native String getDateTimePattern(int var0, int var1, String var2);

    private static native int getCalendarID(String var0);

    private static native String[] getAmPmStrings(String var0, String[] var1);

    private static native String[] getEras(String var0, String[] var1);

    private static native String[] getMonths(String var0, String[] var1);

    private static native String[] getShortMonths(String var0, String[] var1);

    private static native String[] getWeekdays(String var0, String[] var1);

    private static native String[] getShortWeekdays(String var0, String[] var1);

    private static native String getNumberPattern(int var0, String var1);

    private static native boolean isNativeDigit(String var0);

    private static native String getCurrencySymbol(String var0, String var1);

    private static native char getDecimalSeparator(String var0, char var1);

    private static native char getGroupingSeparator(String var0, char var1);

    private static native String getInfinity(String var0, String var1);

    private static native String getInternationalCurrencySymbol(String var0, String var1);

    private static native char getMinusSign(String var0, char var1);

    private static native char getMonetaryDecimalSeparator(String var0, char var1);

    private static native String getNaN(String var0, String var1);

    private static native char getPercent(String var0, char var1);

    private static native char getPerMill(String var0, char var1);

    private static native char getZeroDigit(String var0, char var1);

    private static native int getCalendarDataValue(String var0, int var1);

    private static native String getDisplayString(String var0, int var1, String var2);

    static {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        if (HostLocaleProviderAdapterImpl.initialize()) {
            ResourceBundle.Control control = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
            String string = HostLocaleProviderAdapterImpl.getDefaultLocale(0);
            Locale locale = Locale.forLanguageTag(string.replace('_', '-'));
            hashSet.addAll(control.getCandidateLocales("", locale));
            nativeDisplayLanguage = locale.getLanguage();
            String string2 = HostLocaleProviderAdapterImpl.getDefaultLocale(1);
            if (!string2.equals(string)) {
                locale = Locale.forLanguageTag(string2.replace('_', '-'));
                hashSet.addAll(control.getCandidateLocales("", locale));
            }
        } else {
            nativeDisplayLanguage = "";
        }
        supportedLocaleSet = Collections.unmodifiableSet(hashSet);
        supportedLocale = supportedLocaleSet.toArray(new Locale[0]);
    }
}

