/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_qu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabe Simi";
        final String metaValue_hy = "Armenio Simi";
        final String metaValue_bn = "Bangla Simi";
        final String metaValue_ccp = "Chakma Simi";
        final String metaValue_el = "Griego Simi";
        final String metaValue_gu = "Gujarati Simi";
        final String metaValue_he = "Hebreo Simi";
        final String metaValue_ja = "Japones Simi";
        final String metaValue_kn = "Kannada Simi";
        final String metaValue_ko = "Coreano Simi";
        final String metaValue_lo = "Lao Simi";
        final String metaValue_ml = "Malayalam Simi";
        final String metaValue_mn = "Mongol Simi";
        final String metaValue_MM = "Myanmar";
        final String metaValue_nqo = "N’Ko Simi";
        final String metaValue_or = "Odia Simi";
        final String metaValue_si = "Cingales Simi";
        final String metaValue_ta = "Tamil Simi";
        final String metaValue_th = "Tailandes Simi";
        final String metaValue_bo = "Tibetano Simi";
        final String metaValue_vai = "Vai Simi";
        final String metaValue_ii = "Yi Simi";
        final Object[][] data = new Object[][] {
            { "001", "Pacha" },
            { "002", "Africa" },
            { "003", "Norte America" },
            { "005", "Sud America" },
            { "009", "Oceania" },
            { "011", "Africa Occidental" },
            { "013", "America Central" },
            { "014", "Africa Oriental" },
            { "015", "Africa del Norte" },
            { "017", "Africa Media" },
            { "018", "Sud Africa" },
            { "019", "America" },
            { "021", "America del Norte" },
            { "029", "Caribe" },
            { "030", "Asia Oriental" },
            { "034", "Asia del Sur" },
            { "035", "Sureste de Asia" },
            { "039", "Europa del Sur" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Región Micronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Central" },
            { "145", "Asia Occidental" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa del Norte" },
            { "155", "Europa Occidental" },
            { "202", "Africa Sub-Sahariana" },
            { "419", "AmericaLatina" },
            { "AC", "Islas Ascensión" },
            { "AD", "Andorra" },
            { "AE", "Emiratos Árabes Unidos" },
            { "AF", "Afganistán" },
            { "AG", "Antigua y Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antártida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Islas Åland" },
            { "AZ", "Azerbaiyán" },
            { "BA", "Bosnia y Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Bélgica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Baréin" },
            { "BI", "Burundi" },
            { "BJ", "Benín" },
            { "BL", "San Bartolomé" },
            { "BM", "Bermudas" },
            { "BN", "Brunéi" },
            { "BO", "Bolivia" },
            { "BQ", "Bonaire" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "Bután" },
            { "BV", "Isla Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Belarús" },
            { "BZ", "Belice" },
            { "CA", "Canadá" },
            { "CC", "Islas Cocos" },
            { "CD", "Congo (RDC)" },
            { "CF", "República Centroafricana" },
            { "CG", "Congo" },
            { "CH", "Suiza" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Islas Cook" },
            { "CL", "Chile" },
            { "CM", "Camerún" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Isla Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Curazao" },
            { "CX", "Isla Christmas" },
            { "CY", "Chipre" },
            { "CZ", "Chequia" },
            { "DE", "Alemania" },
            { "DG", "Diego García" },
            { "DJ", "Yibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "República Dominicana" },
            { "DZ", "Argelia" },
            { "EA", "Ceuta y Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipto" },
            { "EH", "Sahara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "España" },
            { "ET", "Etiopía" },
            { "EU", "Union Europea" },
            { "EZ", "Eurozona" },
            { "FI", "Finlandia" },
            { "FJ", "Fiyi" },
            { "FK", "Islas Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Islas Feroe" },
            { "FR", "Francia" },
            { "GA", "Gabón" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Georgia" },
            { "GF", "Guayana Francesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Georgia del Sur e Islas Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bisáu" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong RAE China" },
            { "HM", "Islas Heard y McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "HT", "Haití" },
            { "HU", "Hungría" },
            { "IC", "Islas Canarias" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Isla de Man" },
            { "IN", "India" },
            { "IO", "Territorio Británico del Océano Índico" },
            { "IQ", "Irak" },
            { "IR", "Irán" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordania" },
            { "JP", "Japón" },
            { "KE", "Kenia" },
            { "KG", "Kirguistán" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "KN", "San Cristóbal y Nieves" },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "KW", "Kuwait" },
            { "KY", "Islas Caimán" },
            { "KZ", "Kazajistán" },
            { "LA", "Laos" },
            { "LB", "Líbano" },
            { "LC", "Santa Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Marruecos" },
            { "MC", "Mónaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "San Martín" },
            { "MG", "Madagascar" },
            { "MH", "Islas Marshall" },
            { "MK", "Macedonia del Norte" },
            { "ML", "Malí" },
            { "MM", metaValue_MM },
            { "MN", "Mongolia" },
            { "MO", "Macao RAE China" },
            { "MP", "Islas Marianas del Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricio" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "México" },
            { "MY", "Malasia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nueva Caledonia" },
            { "NE", "Níger" },
            { "NF", "Isla Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Países Bajos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nueva Zelanda" },
            { "OM", "Omán" },
            { "PA", "Panamá" },
            { "PE", "Perú" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Papúa Nueva Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Pakistán" },
            { "PL", "Polonia" },
            { "PM", "San Pedro y Miquelón" },
            { "PN", "Islas Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestina Kamachikuq" },
            { "PT", "Portugal" },
            { "PW", "Palaos" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceanía Periférica" },
            { "RE", "Reunión" },
            { "RO", "Rumania" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudí" },
            { "SB", "Islas Salomón" },
            { "SC", "Seychelles" },
            { "SD", "Sudán" },
            { "SE", "Suecia" },
            { "SG", "Singapur" },
            { "SH", "Santa Elena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard y Jan Mayen" },
            { "SK", "Eslovaquia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sudán del Sur" },
            { "ST", "Santo Tomé y Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Esuatini" },
            { "TA", "Tristán de Acuña" },
            { "TC", "Islas Turcas y Caicos" },
            { "TD", "Chad" },
            { "TF", "Territorios Australes Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Tayikistán" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistán" },
            { "TN", "Túnez" },
            { "TO", "Tonga" },
            { "TR", "Turquía" },
            { "TT", "Trinidad y Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwán" },
            { "TZ", "Tanzania" },
            { "UA", "Ucrania" },
            { "UG", "Uganda" },
            { "UM", "Islas menores alejadas de los EE.UU." },
            { "UN", "Naciones Unidas" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistán" },
            { "VA", "Santa Sede (Ciudad del Vaticano)" },
            { "VC", "San Vicente y las Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Islas Vírgenes Británicas" },
            { "VI", "EE.UU. Islas Vírgenes" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis y Futuna" },
            { "WS", "Samoa" },
            { "XA", "Seudo-Acentos" },
            { "XB", "Seudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sudáfrica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Mana yachasqa Suyu" },
            { "ab", "Abjasia" },
            { "af", "Afrikaans Simi" },
            { "ak", "Akan Simi" },
            { "am", "Amarico Simi" },
            { "an", "Aragonesa" },
            { "ar", metaValue_ar },
            { "as", "Asames Simi" },
            { "av", "Avaric" },
            { "ay", "Aymara Simi" },
            { "az", "Azerbaiyano Simi" },
            { "ba", "Baskir Simi" },
            { "be", "Bielorruso Simi" },
            { "bg", "Bulgaro Simi" },
            { "bi", "Bislama" },
            { "bm", "Bambara Simi" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Breton Simi" },
            { "bs", "Bosnio Simi" },
            { "ca", "Catalan Simi" },
            { "ce", "Checheno Simi" },
            { "ch", "Chamorro Simi" },
            { "co", "Corso Simi" },
            { "cs", "Checo Simi" },
            { "cu", "Eslavo Eclesiástico Simi" },
            { "cv", "Chuvash Simi" },
            { "cy", "Gales Simi" },
            { "da", "Danes Simi" },
            { "de", "Aleman Simi" },
            { "dv", "Divehi Simi" },
            { "dz", "Butanés Simi" },
            { "ee", "Ewé Simi" },
            { "el", metaValue_el },
            { "en", "Ingles Simi" },
            { "eo", "Esperanto Simi" },
            { "es", "Español Simi" },
            { "et", "Estonio Simi" },
            { "eu", "Euskera Simi" },
            { "fa", "Persa Simi" },
            { "ff", "Fulah Simi" },
            { "fi", "Fines Simi" },
            { "fj", "Fiyiano Simi" },
            { "fo", "Feroes Simi" },
            { "fr", "Frances Simi" },
            { "fy", "Frison Simi" },
            { "ga", "Irlandes Simi" },
            { "gd", "Gaelico Escoces Simi" },
            { "gl", "Gallego Simi" },
            { "gn", "Guaraní Simi" },
            { "gu", metaValue_gu },
            { "gv", "Manés Simi" },
            { "ha", "Hausa Simi" },
            { "he", metaValue_he },
            { "hi", "Hindi Simi" },
            { "hr", "Croata Simi" },
            { "ht", "Haitiano Criollo Simi" },
            { "hu", "Hungaro Simi" },
            { "hy", metaValue_hy },
            { "hz", "Herero Simi" },
            { "ia", "Interlingua Simi" },
            { "id", "Indonesio Simi" },
            { "ie", "Interlingue Simi" },
            { "ig", "Igbo Simi" },
            { "ii", metaValue_ii },
            { "io", "Ido Simi" },
            { "is", "Islandes Simi" },
            { "it", "Italiano Simi" },
            { "iu", "Inuktitut Simi" },
            { "ja", metaValue_ja },
            { "jv", "Javanés Simi" },
            { "ka", "Georgiano Simi" },
            { "ki", "Kikuyu Simi" },
            { "kj", "Kuanyama Simi" },
            { "kk", "Kazajo Simi" },
            { "kl", "Groenlandes Simi" },
            { "km", "Khmer Simi" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri Simi" },
            { "ks", "Cachemir Simi" },
            { "ku", "Kurmanji Simi" },
            { "kv", "Komi Simi" },
            { "kw", "Córnico Simi" },
            { "ky", "Kirghiz Simi" },
            { "la", "Latín Simi" },
            { "lb", "Luxemburgues Simi" },
            { "lg", "Luganda Simi" },
            { "li", "Limburgues Simi" },
            { "ln", "Lingala Simi" },
            { "lo", metaValue_lo },
            { "lt", "Lituano Simi" },
            { "lu", "Luba-Katanga Simi" },
            { "lv", "Leton Simi" },
            { "mg", "Malgache Simi" },
            { "mh", "Marshallese Simi" },
            { "mi", "Maori Simi" },
            { "mk", "Macedonio Simi" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi Simi" },
            { "ms", "Malayo Simi" },
            { "mt", "Maltes Simi" },
            { "my", "Birmano Simi" },
            { "na", "Nauru Simi" },
            { "nb", "Noruego Bokmål Simi" },
            { "nd", "Ndebele septentrional Simi" },
            { "ne", "Nepali Simi" },
            { "ng", "Ndonga Simi" },
            { "nl", "Neerlandes Simi" },
            { "nn", "Noruego Nynorsk Simi" },
            { "no", "Noruego Simi" },
            { "nr", "Ndebele del Sur Simi" },
            { "nv", "Navajo Simi" },
            { "ny", "Nyanja Simi" },
            { "oc", "Occitano Simi" },
            { "om", "Oromo Simi" },
            { "or", metaValue_or },
            { "os", "Osetio Simi" },
            { "pa", "Punyabi Simi" },
            { "pl", "Polaco Simi" },
            { "ps", "Pashto Simi" },
            { "pt", "Portugues Simi" },
            { "qu", "Runasimi" },
            { "rm", "Romanche Simi" },
            { "rn", "Rundi Simi" },
            { "ro", "Rumano Simi" },
            { "ru", "Ruso Simi" },
            { "rw", "Kinyarwanda Simi" },
            { "sa", "Sanscrito Simi" },
            { "sc", "Sardinian Simi" },
            { "sd", "Sindhi Simi" },
            { "se", "Chincha Sami Simi" },
            { "sg", "Sango Simi" },
            { "si", metaValue_si },
            { "sk", "Eslovaco Simi" },
            { "sl", "Esloveno Simi" },
            { "sm", "Samoano Simi" },
            { "sn", "Shona Simi" },
            { "so", "Somali Simi" },
            { "sq", "Albanes Simi" },
            { "sr", "Serbio Simi" },
            { "ss", "Swati Simi" },
            { "st", "Soto Meridional Simi" },
            { "su", "Sundanés Simi" },
            { "sv", "Sueco Simi" },
            { "sw", "Suajili Simi" },
            { "ta", metaValue_ta },
            { "te", "Telugu Simi" },
            { "tg", "Tayiko Simi" },
            { "th", metaValue_th },
            { "ti", "Tigriña Simi" },
            { "tk", "Turcomano Simi" },
            { "tn", "Setsuana Simi" },
            { "to", "Tongano Simi" },
            { "tr", "Turco Simi" },
            { "ts", "Tsonga Simi" },
            { "tt", "Tartaro Simi" },
            { "ty", "Tahití Simi" },
            { "ug", "Uigur Simi" },
            { "uk", "Ucraniano Simi" },
            { "ur", "Urdu Simi" },
            { "uz", "Uzbeko Simi" },
            { "ve", "Venda Simi" },
            { "vi", "Vietnamita Simi" },
            { "vo", "Volapük Simi" },
            { "wa", "Valona Simi" },
            { "wo", "Wolof Simi" },
            { "xh", "Isixhosa Simi" },
            { "yi", "Yiddish Simi" },
            { "yo", "Yoruba Simi" },
            { "za", "Zhuang" },
            { "zh", "Chino Simi" },
            { "zu", "Isizulu Simi" },
            { "ace", "Achinese" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "agq", "Aghem Simi" },
            { "ain", "Ainu" },
            { "ale", "Aleut" },
            { "alt", "Altai Meridional" },
            { "ann", "Obolo Simi" },
            { "anp", "Angika" },
            { "arn", "Mapuche Simi" },
            { "arp", "Arapaho" },
            { "ars", "Árabe Najdi Simi" },
            { "asa", "Asu Simi" },
            { "ast", "Asturiano Simi" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "bal", "Baluchi Simi" },
            { "ban", "Balines Simi" },
            { "bas", "Basaa Simi" },
            { "bem", "Bemba Simi" },
            { "bez", "Bena Simi" },
            { "bgc", "Haryanvi" },
            { "bho", "Bhojpuri Simi" },
            { "bin", "Bini" },
            { "bla", "Siksiká Simi" },
            { "blo", "Anii Simi" },
            { "brx", "Bodo Simi" },
            { "bug", "Buginese" },
            { "byn", "Blin" },
            { "cay", "Cayugá" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano Simi" },
            { "cgg", "Kiga Simi" },
            { "chk", "Chuukese Simi" },
            { "chm", "Mari Simi" },
            { "cho", "Choctaw Simi" },
            { "chp", "Chipewyan Simi" },
            { "chr", "Cheroqui Simi" },
            { "chy", "Cheyenne" },
            { "ckb", "Chawpi Kurdo Simi" },
            { "clc", "Chilcotin Simi" },
            { "crg", "Michif Simi" },
            { "crj", "Cree Este del Sur Simi" },
            { "crk", "Plains Cree Simi" },
            { "crl", "Cree del Noreste Simi" },
            { "crm", "Moose Cree Simi" },
            { "crr", "Algonquian Carolina" },
            { "csw", "Swampy Cree Simi" },
            { "dak", "Dakota Simi" },
            { "dar", "Dargwa Simi" },
            { "dav", "Taita Simi" },
            { "dgr", "Dogrib Simi" },
            { "dje", "Zarma Simi" },
            { "doi", "Dogri Simi" },
            { "dsb", "Bajo Sorbio Simi" },
            { "dua", "Duala Simi" },
            { "dyo", "Jola-Fonyi Simi" },
            { "dzg", "Dazaga Simi" },
            { "ebu", "Embu Simi" },
            { "efi", "Efik Simi" },
            { "eka", "Ekajuk Simi" },
            { "ewo", "Ewondo Simi" },
            { "fil", "Filipino Simi" },
            { "fon", "Fon Simi" },
            { "frc", "Francés Cajun" },
            { "frr", "Frisón del Norte Simi" },
            { "fur", "Friulano Simi" },
            { "gaa", "Ga Simi" },
            { "gez", "Geez Simi" },
            { "gil", "Gilbertese Simi" },
            { "gor", "Gorontalo Simi" },
            { "gsw", "Alsaciano Simi" },
            { "guz", "Guzí Simi" },
            { "gwi", "Gwichʼin Simi" },
            { "hai", "Haida Simi" },
            { "haw", "Hawaiano Simi" },
            { "hax", "Haida Meridional" },
            { "hil", "Hiligaynon Simi" },
            { "hmn", "Hmong Daw Simi" },
            { "hsb", "Alto Sorbio Simi" },
            { "hup", "Hupa Simi" },
            { "hur", "Halkomelem Simi" },
            { "iba", "Iban Simi" },
            { "ibb", "Ibibio Simi" },
            { "ikt", "Inuktitut Simi (Canadá occidental)" },
            { "ilo", "Iloko Simi" },
            { "inh", "Ingush Simi" },
            { "jbo", "Lojban Simi" },
            { "jgo", "Ngomba Simi" },
            { "jmc", "Machame Simi" },
            { "kab", "Cabilio Simi" },
            { "kac", "Kachin Simi" },
            { "kaj", "Jju Simi" },
            { "kam", "Kamba Simi" },
            { "kbd", "Kabardiano Simi" },
            { "kcg", "Tyap Simi" },
            { "kde", "Makonde Simi" },
            { "kea", "Caboverdiano Simi" },
            { "kfo", "Koro Simi" },
            { "kgp", "Kaingang Simi" },
            { "kha", "Khasi Simi" },
            { "khq", "Koyra Chiini Simi" },
            { "kkj", "Kako Simi" },
            { "kln", "Kalenjin Simi" },
            { "kmb", "Kimbundu Simi" },
            { "kok", "Konkani Simi" },
            { "kpe", "Kpelle Simi" },
            { "krc", "Karachay-Balkar Simi" },
            { "krl", "Karelian Simi" },
            { "kru", "Kurukh Simi" },
            { "ksb", "Shambala Simi" },
            { "ksf", "Bafia Simi" },
            { "ksh", "Kölsch Simi" },
            { "kum", "Kumyk Simi" },
            { "kwk", "Kwakʼwala Simi" },
            { "kxv", "Kuvi Simi" },
            { "lad", "Ladino Simi" },
            { "lag", "Langi Simi" },
            { "lez", "Lezghian Simi" },
            { "lij", "Liguria Simi" },
            { "lil", "Lillooet Simi" },
            { "lkt", "Lakota Simi" },
            { "lmo", "Lombardo Simi" },
            { "lou", "Luisiana Criollo" },
            { "loz", "Lozi Simi" },
            { "lrc", "Luri septentrional Simi" },
            { "lsm", "Saamia Simi" },
            { "lua", "Luba-Lulua Simi" },
            { "lun", "Lunda Simi" },
            { "luo", "Luo Simi" },
            { "lus", "Mizo Simi" },
            { "luy", "Luyia Simi" },
            { "mad", "Madurese Simi" },
            { "mag", "Magahi Simi" },
            { "mai", "Maithili Simi" },
            { "mak", "Makasar Simi" },
            { "mas", "Masai Simi" },
            { "mdf", "Moksha Simi" },
            { "men", "Mende Simi" },
            { "mer", "Meru Simi" },
            { "mfe", "Mauriciano Simi" },
            { "mgh", "Makhuwa-Meetto Simi" },
            { "mgo", "Metaʼ Simi" },
            { "mic", "Mi'kmaq Simi" },
            { "min", "Minangkabau Simi" },
            { "mni", "Manipuri Simi" },
            { "moe", "Innu-aimun Simi" },
            { "moh", "Mohawk Simi" },
            { "mos", "Mossi Simi" },
            { "mua", "Mundang Simi" },
            { "mul", "Achka simikuna" },
            { "mus", "Muscogee Simi" },
            { "mwl", "Mirandés Simi" },
            { "myv", "Erzya Simi" },
            { "mzn", "Mazandaraní Simi" },
            { "nap", "Neapolitan Simi" },
            { "naq", "Nama Simi" },
            { "nds", "Bajo Alemán Simi" },
            { "new", "Newari Simi" },
            { "nia", "Nias Simi" },
            { "niu", "Niuean Simi" },
            { "nmg", "Kwasio Ngumba Simi" },
            { "nnh", "Ngiemboon Simi" },
            { "nog", "Nogai Simi" },
            { "nqo", metaValue_nqo },
            { "nso", "Sesotho Sa Leboa Simi" },
            { "nus", "Nuer Simi" },
            { "nyn", "Nyankole Simi" },
            { "ojb", "Ojibwa del noroeste Simi" },
            { "ojc", "Ojibwa Central" },
            { "ojs", "Oji-Cree Simi" },
            { "ojw", "Ojibwa Occidental" },
            { "oka", "Okanagan Simi" },
            { "pag", "Pangasinan Simi" },
            { "pam", "Pampanga Simi" },
            { "pap", "Papiamento Simi" },
            { "pau", "Palauan Simi" },
            { "pcm", "Pidgin Nigeriano Simi" },
            { "pis", "Pijin Simi" },
            { "pqm", "Maliseet-Passamaquoddy Simi" },
            { "prg", "Prusiano Simi" },
            { "quc", "Kʼicheʼ Simi" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui Simi" },
            { "rar", "Rarotongan Simi" },
            { "rhg", "Rohingya Simi" },
            { "rof", "Rombo Simi" },
            { "rup", "Arrumano" },
            { "rwk", "Rwa Simi" },
            { "sad", "Sandawe Simi" },
            { "sah", "Sakha Simi" },
            { "saq", "Samburu Simi" },
            { "sat", "Santali Simi" },
            { "sba", "Ngambay Simi" },
            { "sbp", "Sangu Simi" },
            { "scn", "Siciliano Simi" },
            { "sco", "Scots Simi" },
            { "seh", "Sena Simi" },
            { "ses", "Koyraboro Senni Simi" },
            { "shi", "Tashelhit Simi" },
            { "shn", "Shan Simi" },
            { "slh", "Lushootseed Meridional" },
            { "sma", "Qulla Sami Simi" },
            { "smj", "Sami Lule Simi" },
            { "smn", "Sami Inari Simi" },
            { "sms", "Sami Skolt Simi" },
            { "snk", "Soninke Simi" },
            { "srn", "Sranan Tongo Simi" },
            { "str", "Straits Salish Simi" },
            { "suk", "Sukuma Simi" },
            { "swb", "Comorian Simi" },
            { "syr", "Siriaco Simi" },
            { "szl", "Silesiano" },
            { "tce", "Tutchone Meridional" },
            { "tem", "Timne Simi" },
            { "teo", "Teso Simi" },
            { "tet", "Tetum Simi" },
            { "tgx", "Tagish Simi" },
            { "tht", "Tahltan Simi" },
            { "tig", "Tigre Simi" },
            { "tlh", "Klingon Simi" },
            { "tli", "Tlingit Simi" },
            { "tok", "Toki Pona Simi" },
            { "tpi", "Tok Pisin Simi" },
            { "trv", "Taroko Simi" },
            { "ttm", "Tutchone del Norte Simi" },
            { "tum", "Tumbuka Simi" },
            { "tvl", "Tuvalu Simi" },
            { "twq", "Tasawaq Simi" },
            { "tyv", "Tuviniano Simi" },
            { "tzm", "Tamazight Simi" },
            { "udm", "Udmurt Simi" },
            { "umb", "Umbundu Simi" },
            { "und", "Mana Riqsisqa Simi" },
            { "vai", metaValue_vai },
            { "vec", "Veneciamanta" },
            { "vmw", "Makhuwa Simi" },
            { "vun", "Vunjo Simi" },
            { "wae", "Walser Simi" },
            { "wal", "Wolaytta Simi" },
            { "war", "Waray Simi" },
            { "wuu", "Wu Chino" },
            { "xal", "Kalmyk Simi" },
            { "xnr", "Kangri Simi" },
            { "xog", "Soga Simi" },
            { "yav", "Yangben Simi" },
            { "ybb", "Yemba Simi" },
            { "yrl", "Nheengatu Simi" },
            { "yue", "Cantonés Simi" },
            { "zgh", "Bereber Marroquí Estándar Simi" },
            { "zun", "Zuni Simi" },
            { "zxx", "Manaraq simi yachana" },
            { "zza", "Zaza Simi" },
            { "Adlm", "Adlam Simi" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq qillqa" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "Bopomofo Simi" },
            { "Brai", "Braile" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Silabeo aborigen Simi (Canadiense unificado)" },
            { "Cher", "Cherokee Simi" },
            { "Cyrl", "Cirilico" },
            { "Deva", "Devanagari" },
            { "Ethi", "Etiope" },
            { "Geor", "Georgiano" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi Simi" },
            { "Hanb", "Han with Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hans", "Simplificado" },
            { "Hant", "Tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hrkt", "Japones silabico sananpakuna" },
            { "Jpan", metaValue_ja },
            { "Kana", "Katakana" },
            { "Khmr", "Khmer" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "Latin Simi" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "Meitei Mayek Simi" },
            { "Mymr", metaValue_MM },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ol Chiki Simi" },
            { "Orya", metaValue_or },
            { "Rohg", "Hanifi Simi" },
            { "Sinh", metaValue_si },
            { "Sund", "Sundanese Simi" },
            { "Syrc", "Sirio Simi" },
            { "Taml", metaValue_ta },
            { "Telu", "Tegulu Simi" },
            { "Tfng", "Tifinagh Simi" },
            { "Thaa", "Thaana Simi" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", metaValue_ii },
            { "Zmth", "Matimatica Willay" },
            { "Zsye", "Emoji" },
            { "Zsym", "Unanchakuna" },
            { "Zxxx", "Mana qillqasqa" },
            { "Zyyy", "Common Simi" },
            { "Zzzz", "Mana yachasqa Qillqa" },
            { "fa_AF", "Dari Simi" },
            { "nl_BE", "Flamenco Simi" },
            { "sw_CD", "Suajili Simi (Congo (RDC))" },
            { "ar_001", "Musuq Estandar Arabe Simi" },
            { "es_419", "Español Simi (Latino América)" },
            { "key.ca", "Intiwatana" },
            { "key.cf", "Imayna Qullqi kaynin" },
            { "key.co", "Ñiqinchana" },
            { "key.cu", "qullqi" },
            { "key.em", "Emoji nisqamanta rikuchiy" },
            { "key.hc", "Ciclo de Horas (12 vs 24)" },
            { "key.lb", "Siqi paway kaynin" },
            { "key.lw", "Simikuna ukhupi Chiru Pakikuna" },
            { "key.ms", "Tupuy Kamay" },
            { "key.nu", "Yupaykuna" },
            { "key.ss", "Oración Pakikuy Abbr." },
            { "zh_Hans", "Chino Simplificado Simi" },
            { "zh_Hant", "Chino Tradicional Simi" },
            { "type.ca.roc", "Minguo Intiwatana" },
            { "type.hc.h11", "12 hora kaynin (0–11)" },
            { "type.hc.h12", "12 hora kaynin (1–12)" },
            { "type.hc.h23", "24 hora kaynin (0–23)" },
            { "type.hc.h24", "24 hora kaynin (1–24)" },
            { "type.nu.arab", "Arabe Sananpakuna" },
            { "type.nu.armn", "Armenio Sananpakuna" },
            { "type.nu.beng", "Bangla Sananpakuna" },
            { "type.nu.cakm", "Chakma Sananpakuna" },
            { "type.nu.deva", "Devanagari Sananpakuna" },
            { "type.nu.ethi", "Etiope Sananpakuna" },
            { "type.nu.geor", "Gregoriano Yupaykuna" },
            { "type.nu.grek", "Griego Yupaykuna" },
            { "type.nu.gujr", "Gujarati Sananpakuna" },
            { "type.nu.guru", "Gurmukhi Sananpakuna" },
            { "type.nu.hans", "Uchuyachusqa Chino Yupaypakuna" },
            { "type.nu.hant", "Kikin Chino Yupaypakuna" },
            { "type.nu.hebr", "Hebreo Yupaykuna" },
            { "type.nu.java", "Javaneses Yupaykuna" },
            { "type.nu.jpan", "Japones Yupaykuna" },
            { "type.nu.khmr", "Khmer Sananpakuna" },
            { "type.nu.knda", "Kannada Sananpakuna" },
            { "type.nu.laoo", "Lao Sananpakuna" },
            { "type.nu.latn", "Occidental Sananpakuna" },
            { "type.nu.mlym", "Malayalam Sananpakuna" },
            { "type.nu.mtei", "Meetei Mayek Yupaykuna" },
            { "type.nu.mymr", "Myanmar Sananpakuna" },
            { "type.nu.olck", "Ol Chiki Yupaykuna" },
            { "type.nu.orya", "Odia Sananpakuna" },
            { "type.nu.taml", "Kikin Tamil Yupaykuna" },
            { "type.nu.telu", "Telegu Sananpakuna" },
            { "type.nu.thai", "Thai Sananpakuna" },
            { "type.nu.tibt", "Tibetano Sananpakuna" },
            { "type.nu.vaii", "Vai Yupaykuna" },
            { "type.ca.dangi", "Dangi Intiwatana" },
            { "type.co.ducet", "Ñawpaqchasqa Unicode Nisqa Ñiqinchana" },
            { "type.lb.loose", "Siqi paway chinkachiy kaynin" },
            { "type.nu.roman", "Romano Sananpakuna" },
            { "type.ca.coptic", "Copto Intiwatana" },
            { "type.ca.hebrew", "Hebreo Intiwatana" },
            { "type.co.search", "Llapanpaq maskana" },
            { "type.lb.normal", "Siqi paway Normal kaynin" },
            { "type.lb.strict", "Siqi paway Chiqa kaynin" },
            { "type.ms.metric", "Metrico Kamay" },
            { "type.ca.chinese", "Chino Intiwatana" },
            { "type.ca.islamic", "Hijri Intiwatana" },
            { "type.ca.iso8601", "ISO-8601 Intiwatana" },
            { "type.ca.persian", "Persa Intiwatana" },
            { "type.cf.account", "Yupana Qullqi imayna kaynin" },
            { "type.nu.arabext", "Arabe Mirachisqa Sananpakuna" },
            { "type.nu.armnlow", "Armenio Uchuy Sananpakuna" },
            { "type.nu.greklow", "Griego Uchuy Yupaykuna" },
            { "type.nu.hanidec", "Chunkachasqa Chino Yupaykuna" },
            { "type.nu.hansfin", "Uchuyachisqa Qullqi Chino Yupaypakuna" },
            { "type.nu.hantfin", "Kikin Qullqi Chino Yupaypakuna" },
            { "type.nu.jpanfin", "Japones Qullqi Yupaykuna" },
            { "type.nu.tamldec", "Tamil Sananpakuna" },
            { "type.ca.buddhist", "Budista Intiwatana" },
            { "type.ca.ethiopic", "Etiope Intiwatana" },
            { "type.ca.japanese", "Japones Intiwatana" },
            { "type.cf.standard", "Estandar nisqa qullqi imayna kaynin" },
            { "type.co.standard", "Estandar nisqa Ñiqinchana" },
            { "type.ms.uksystem", "Metrico Ingles Kamay" },
            { "type.ms.ussystem", "Metrico Americano Kamay" },
            { "type.nu.fullwide", "Llapan kinray Sananpakuna" },
            { "type.nu.romanlow", "Roman Uchuy Yupaykuna" },
            { "type.ca.gregorian", "Gregoriano Intiwatana" },
            { "type.ca.islamic-civil", "Hijri Intiwatana (tabular, epoca civil)" },
            { "type.ca.islamic-umalqura", "Hijri Intiwatana (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etíope Amete Alem Intiwatana" },
        };
        return data;
    }
}
