/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.whitebox.code;

import jdk.test.whitebox.WhiteBox;
import jdk.test.whitebox.code.BlobType;

public class CodeBlob {
    private static final WhiteBox WB = WhiteBox.getWhiteBox();
    public final String name;
    public final int size;
    public final BlobType code_blob_type;
    public final long address;
    public final long code_begin;
    public final boolean isNMethod;

    public static CodeBlob[] getCodeBlobs(BlobType type) {
        Object[] obj = WB.getCodeHeapEntries(type.id);
        if (obj == null) {
            return null;
        }
        CodeBlob[] result = new CodeBlob[obj.length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = new CodeBlob((Object[])obj[i]);
        }
        return result;
    }

    public static CodeBlob getCodeBlob(long addr) {
        Object[] obj = WB.getCodeBlob(addr);
        if (obj == null) {
            return null;
        }
        return new CodeBlob(obj);
    }

    protected CodeBlob(Object[] obj) {
        assert (obj.length == 6);
        this.name = (String)obj[0];
        this.size = (Integer)obj[1];
        int blob_type_index = (Integer)obj[2];
        this.code_blob_type = BlobType.values()[blob_type_index];
        assert (this.code_blob_type.id == (Integer)obj[2]);
        this.address = (Long)obj[3];
        this.code_begin = (Long)obj[4];
        this.isNMethod = (Boolean)obj[5];
    }

    public String toString() {
        return "CodeBlob{name=" + this.name + ", size=" + this.size + ", code_blob_type=" + String.valueOf((Object)this.code_blob_type) + ", address=" + this.address + ", code_begin=" + this.code_begin + "}";
    }
}

