/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_EnvironmentBase
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_EnvironmentBase {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __activeValidatorOffset_;
	public static final int __allocationColorOffset_;
	public static final int __allocationContextOffset_;
	public static final int __allocationFailureReportedOffset_;
	public static final int __allocationTrackerOffset_;
	public static final int __cachedGCExclusiveAccessThreadIdOffset_;
	public static final int __cardCleaningStatsOffset_;
	public static final int __commonAllocationContextOffset_;
	public static final int __compactStatsOffset_;
	public static final int __concurrentScavengerSwitchCountOffset_;
	public static final int __currentTaskOffset_;
	public static final int __cycleStateOffset_;
	public static final int __delegateOffset_;
	public static final int __environmentIdOffset_;
	public static final int __exclusiveAccessBeatenByOtherThreadOffset_;
	public static final int __exclusiveAccessHaltedThreadsOffset_;
	public static final int __exclusiveAccessTimeOffset_;
	public static final int __exclusiveCountOffset_;
	public static final int __failAllocOnExcessiveGCOffset_;
	public static final int __freeEntrySizeClassStatsOffset_;
	public static final int __hotFieldCopyDepthCountOffset_;
	public static final int __isInNoGCAllocationCallOffset_;
	public static final int __lastExclusiveAccessResponderOffset_;
	public static final int __lastSyncPointReachedOffset_;
	public static final int __markStatsOffset_;
	public static final int __meanExclusiveAccessIdleTimeOffset_;
	public static final int __objectAllocationInterfaceOffset_;
	public static final int __omrVMOffset_;
	public static final int __omrVMThreadOffset_;
	public static final int __oolTraceAllocationBytesOffset_;
	public static final int __portLibraryOffset_;
	public static final int __regionLocalFreeOffset_;
	public static final int __regionLocalFullOffset_;
	public static final int __regionWorkListOffset_;
	public static final int __rootScannerStatsOffset_;
	public static final int __scavengerStatsOffset_;
	public static final int __sweepStatsOffset_;
	public static final int __threadScannedOffset_;
	public static final int __threadTypeOffset_;
	public static final int __traceAllocationBytesOffset_;
	public static final int __traceAllocationBytesCurrentTLHOffset_;
	public static final int __workPacketStatsOffset_;
	public static final int __workPacketStatsRSScanOffset_;
	public static final int __workStackOffset_;
	public static final int __workUnitIndexOffset_;
	public static final int __workUnitToHandleOffset_;
	public static final int __workerIDOffset_;
	public static final int __workerThreadCpuTimeNanosOffset_;
	public static final int _approxScanCacheCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__activeValidatorOffset_ = 0;
		__allocationColorOffset_ = 0;
		__allocationContextOffset_ = 0;
		__allocationFailureReportedOffset_ = 0;
		__allocationTrackerOffset_ = 0;
		__cachedGCExclusiveAccessThreadIdOffset_ = 0;
		__cardCleaningStatsOffset_ = 0;
		__commonAllocationContextOffset_ = 0;
		__compactStatsOffset_ = 0;
		__concurrentScavengerSwitchCountOffset_ = 0;
		__currentTaskOffset_ = 0;
		__cycleStateOffset_ = 0;
		__delegateOffset_ = 0;
		__environmentIdOffset_ = 0;
		__exclusiveAccessBeatenByOtherThreadOffset_ = 0;
		__exclusiveAccessHaltedThreadsOffset_ = 0;
		__exclusiveAccessTimeOffset_ = 0;
		__exclusiveCountOffset_ = 0;
		__failAllocOnExcessiveGCOffset_ = 0;
		__freeEntrySizeClassStatsOffset_ = 0;
		__hotFieldCopyDepthCountOffset_ = 0;
		__isInNoGCAllocationCallOffset_ = 0;
		__lastExclusiveAccessResponderOffset_ = 0;
		__lastSyncPointReachedOffset_ = 0;
		__markStatsOffset_ = 0;
		__meanExclusiveAccessIdleTimeOffset_ = 0;
		__objectAllocationInterfaceOffset_ = 0;
		__omrVMOffset_ = 0;
		__omrVMThreadOffset_ = 0;
		__oolTraceAllocationBytesOffset_ = 0;
		__portLibraryOffset_ = 0;
		__regionLocalFreeOffset_ = 0;
		__regionLocalFullOffset_ = 0;
		__regionWorkListOffset_ = 0;
		__rootScannerStatsOffset_ = 0;
		__scavengerStatsOffset_ = 0;
		__sweepStatsOffset_ = 0;
		__threadScannedOffset_ = 0;
		__threadTypeOffset_ = 0;
		__traceAllocationBytesOffset_ = 0;
		__traceAllocationBytesCurrentTLHOffset_ = 0;
		__workPacketStatsOffset_ = 0;
		__workPacketStatsRSScanOffset_ = 0;
		__workStackOffset_ = 0;
		__workUnitIndexOffset_ = 0;
		__workUnitToHandleOffset_ = 0;
		__workerIDOffset_ = 0;
		__workerThreadCpuTimeNanosOffset_ = 0;
		_approxScanCacheCountOffset_ = 0;
	}

}
