/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.thread;

import java.util.concurrent.ThreadFactory;

public class TestThreadFactory {
    private static final TestThreadFactoryType testThreadFactoryType = "Virtual".equals(System.getProperty("test.thread.factory")) ? TestThreadFactoryType.VIRTUAL : TestThreadFactoryType.NONE;
    private static final ThreadFactory threadFactory = testThreadFactoryType == TestThreadFactoryType.VIRTUAL ? TestThreadFactory.virtualThreadFactory() : TestThreadFactory.platformThreadFactory();

    public static TestThreadFactoryType testThreadFactoryType() {
        return testThreadFactoryType;
    }

    public static boolean isTestThreadFactorySet() {
        return !testThreadFactoryType.equals((Object)TestThreadFactoryType.NONE);
    }

    public static Thread newThread(Runnable task) {
        return threadFactory.newThread(task);
    }

    public static Thread newThread(Runnable task, String name) {
        Thread t = threadFactory.newThread(task);
        t.setName(name);
        return t;
    }

    private static ThreadFactory platformThreadFactory() {
        return Thread.ofPlatform().factory();
    }

    private static ThreadFactory virtualThreadFactory() {
        return Thread.ofVirtual().factory();
    }

    public static enum TestThreadFactoryType {
        NONE,
        VIRTUAL;

    }
}

