/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _LC_collate_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _LC_collate_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_LC_collate_t.class)
public class _LC_collate_tPointer extends StructurePointer {

	// NULL
	public static final _LC_collate_tPointer NULL = new _LC_collate_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _LC_collate_tPointer(long address) {
		super(address);
	}

	public static _LC_collate_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _LC_collate_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _LC_collate_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _LC_collate_tPointer(address);
	}

	public _LC_collate_tPointer add(long count) {
		return _LC_collate_tPointer.cast(address + (_LC_collate_t.SIZEOF * count));
	}

	public _LC_collate_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _LC_collate_tPointer addOffset(long offset) {
		return _LC_collate_tPointer.cast(address + offset);
	}

	public _LC_collate_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _LC_collate_tPointer sub(long count) {
		return _LC_collate_tPointer.cast(address - (_LC_collate_t.SIZEOF * count));
	}

	public _LC_collate_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _LC_collate_tPointer subOffset(long offset) {
		return _LC_collate_tPointer.cast(address - offset);
	}

	public _LC_collate_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _LC_collate_tPointer untag(long mask) {
		return _LC_collate_tPointer.cast(address & ~mask);
	}

	public _LC_collate_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _LC_collate_t.SIZEOF;
	}

	// Implementation methods

	// void* __data_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data_ptrOffset_", declaredType="void*")
	public VoidPointer __data_ptr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_LC_collate_t.___data_ptrOffset_));
	}

	// void* __data_ptr
	public PointerPointer __data_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_collate_t.___data_ptrOffset_));
	}

	// void* __meth_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___meth_ptrOffset_", declaredType="void*")
	public VoidPointer __meth_ptr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_LC_collate_t.___meth_ptrOffset_));
	}

	// void* __meth_ptr
	public PointerPointer __meth_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_collate_t.___meth_ptrOffset_));
	}

	// wchar_t co_col_max
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_col_maxOffset_", declaredType="wchar_t")
	public UDATA co_col_max() throws CorruptDataException {
		return new U32(getIntAtOffset(_LC_collate_t._co_col_maxOffset_));
	}

	// wchar_t co_col_max
	public UDATAPointer co_col_maxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_LC_collate_t._co_col_maxOffset_));
	}

	// wchar_t co_col_min
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_col_minOffset_", declaredType="wchar_t")
	public UDATA co_col_min() throws CorruptDataException {
		return new U32(getIntAtOffset(_LC_collate_t._co_col_minOffset_));
	}

	// wchar_t co_col_min
	public UDATAPointer co_col_minEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_LC_collate_t._co_col_minOffset_));
	}

	// _LC_coltbl_t* co_coltbl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_coltblOffset_", declaredType="_LC_coltbl_t*")
	public _LC_coltbl_tPointer co_coltbl() throws CorruptDataException {
		return _LC_coltbl_tPointer.cast(getPointerAtOffset(_LC_collate_t._co_coltblOffset_));
	}

	// _LC_coltbl_t* co_coltbl
	public PointerPointer co_coltblEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_collate_t._co_coltblOffset_));
	}

	// U8 co_nord
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_nordOffset_", declaredType="U8")
	public U8 co_nord() throws CorruptDataException {
		return new U8(getByteAtOffset(_LC_collate_t._co_nordOffset_));
	}

	// U8 co_nord
	public U8Pointer co_nordEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(_LC_collate_t._co_nordOffset_));
	}

	// U32 co_nsubs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_nsubsOffset_", declaredType="U32")
	public UDATA co_nsubs() throws CorruptDataException {
		return new U32(getIntAtOffset(_LC_collate_t._co_nsubsOffset_));
	}

	// U32 co_nsubs
	public UDATAPointer co_nsubsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_LC_collate_t._co_nsubsOffset_));
	}

	// _LC_weight_t co_sort
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_sortOffset_", declaredType="_LC_weight_t")
	public _LC_weight_tPointer co_sort() throws CorruptDataException {
		return _LC_weight_tPointer.cast(nonNullFieldEA(_LC_collate_t._co_sortOffset_));
	}

	// _LC_weight_t co_sort
	public PointerPointer co_sortEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_collate_t._co_sortOffset_));
	}

	// U16 co_special
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_specialOffset_", declaredType="U16")
	public U16 co_special() throws CorruptDataException {
		return new U16(getShortAtOffset(_LC_collate_t._co_specialOffset_));
	}

	// U16 co_special
	public U16Pointer co_specialEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_LC_collate_t._co_specialOffset_));
	}

	// _LC_subs_t* co_subs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_subsOffset_", declaredType="_LC_subs_t*")
	public _LC_subs_tPointer co_subs() throws CorruptDataException {
		return _LC_subs_tPointer.cast(getPointerAtOffset(_LC_collate_t._co_subsOffset_));
	}

	// _LC_subs_t* co_subs
	public PointerPointer co_subsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_collate_t._co_subsOffset_));
	}

	// wchar_t co_wc_max
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_wc_maxOffset_", declaredType="wchar_t")
	public UDATA co_wc_max() throws CorruptDataException {
		return new U32(getIntAtOffset(_LC_collate_t._co_wc_maxOffset_));
	}

	// wchar_t co_wc_max
	public UDATAPointer co_wc_maxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_LC_collate_t._co_wc_maxOffset_));
	}

	// wchar_t co_wc_min
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_co_wc_minOffset_", declaredType="wchar_t")
	public UDATA co_wc_min() throws CorruptDataException {
		return new U32(getIntAtOffset(_LC_collate_t._co_wc_minOffset_));
	}

	// wchar_t co_wc_min
	public UDATAPointer co_wc_minEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_LC_collate_t._co_wc_minOffset_));
	}

	// _LC_core_collate_t core
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_coreOffset_", declaredType="_LC_core_collate_t")
	public _LC_core_collate_tPointer core() throws CorruptDataException {
		return _LC_core_collate_tPointer.cast(nonNullFieldEA(_LC_collate_t._coreOffset_));
	}

	// _LC_core_collate_t core
	public PointerPointer coreEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_collate_t._coreOffset_));
	}

	// __LC_locale* loc_rec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_loc_recOffset_", declaredType="__LC_locale*")
	public __LC_localePointer loc_rec() throws CorruptDataException {
		return __LC_localePointer.cast(getPointerAtOffset(_LC_collate_t._loc_recOffset_));
	}

	// __LC_locale* loc_rec
	public PointerPointer loc_recEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_collate_t._loc_recOffset_));
	}

}
