/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _LC_core_car_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _LC_core_car_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_LC_core_car_t.class)
public class _LC_core_car_tPointer extends StructurePointer {

	// NULL
	public static final _LC_core_car_tPointer NULL = new _LC_core_car_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _LC_core_car_tPointer(long address) {
		super(address);
	}

	public static _LC_core_car_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _LC_core_car_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _LC_core_car_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _LC_core_car_tPointer(address);
	}

	public _LC_core_car_tPointer add(long count) {
		return _LC_core_car_tPointer.cast(address + (_LC_core_car_t.SIZEOF * count));
	}

	public _LC_core_car_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _LC_core_car_tPointer addOffset(long offset) {
		return _LC_core_car_tPointer.cast(address + offset);
	}

	public _LC_core_car_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _LC_core_car_tPointer sub(long count) {
		return _LC_core_car_tPointer.cast(address - (_LC_core_car_t.SIZEOF * count));
	}

	public _LC_core_car_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _LC_core_car_tPointer subOffset(long offset) {
		return _LC_core_car_tPointer.cast(address - offset);
	}

	public _LC_core_car_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _LC_core_car_tPointer untag(long mask) {
		return _LC_core_car_tPointer.cast(address & ~mask);
	}

	public _LC_core_car_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _LC_core_car_t.SIZEOF;
	}

	// Implementation methods

	// I32 __catclose
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___catcloseOffset_", declaredType="I32")
	public IDATA __catclose() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_car_t.___catcloseOffset_));
	}

	// I32 __catclose
	public IDATAPointer __catcloseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_car_t.___catcloseOffset_));
	}

	// I32 __catgets
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___catgetsOffset_", declaredType="I32")
	public IDATA __catgets() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_car_t.___catgetsOffset_));
	}

	// I32 __catgets
	public IDATAPointer __catgetsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_car_t.___catgetsOffset_));
	}

	// I32 __compress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___compressOffset_", declaredType="I32")
	public IDATA __compress() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_car_t.___compressOffset_));
	}

	// I32 __compress
	public IDATAPointer __compressEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_car_t.___compressOffset_));
	}

	// void* __data
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___dataOffset_", declaredType="void*")
	public VoidPointer __data() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(_LC_core_car_t.___dataOffset_));
	}

	// void* __data
	public PointerPointer __dataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_core_car_t.___dataOffset_));
	}

	// I32 __decompress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___decompressOffset_", declaredType="I32")
	public IDATA __decompress() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_car_t.___decompressOffset_));
	}

	// I32 __decompress
	public IDATAPointer __decompressEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_car_t.___decompressOffset_));
	}

	// I32 __end_compress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___end_compressOffset_", declaredType="I32")
	public IDATA __end_compress() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_car_t.___end_compressOffset_));
	}

	// I32 __end_compress
	public IDATAPointer __end_compressEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_car_t.___end_compressOffset_));
	}

	// _LC_object_t __hdr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___hdrOffset_", declaredType="_LC_object_t")
	public _LC_object_tPointer __hdr() throws CorruptDataException {
		return _LC_object_tPointer.cast(nonNullFieldEA(_LC_core_car_t.___hdrOffset_));
	}

	// _LC_object_t __hdr
	public PointerPointer __hdrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(_LC_core_car_t.___hdrOffset_));
	}

	// I32 __init
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___initOffset_", declaredType="I32")
	public IDATA __init() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_car_t.___initOffset_));
	}

	// I32 __init
	public IDATAPointer __initEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_car_t.___initOffset_));
	}

	// I32 __start_compress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___start_compressOffset_", declaredType="I32")
	public IDATA __start_compress() throws CorruptDataException {
		return new I32(getIntAtOffset(_LC_core_car_t.___start_compressOffset_));
	}

	// I32 __start_compress
	public IDATAPointer __start_compressEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(_LC_core_car_t.___start_compressOffset_));
	}

}
