/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: sigeventPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the sigeventPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=sigevent.class)
public class sigeventPointer extends StructurePointer {

	// NULL
	public static final sigeventPointer NULL = new sigeventPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected sigeventPointer(long address) {
		super(address);
	}

	public static sigeventPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static sigeventPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static sigeventPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new sigeventPointer(address);
	}

	public sigeventPointer add(long count) {
		return sigeventPointer.cast(address + (sigevent.SIZEOF * count));
	}

	public sigeventPointer add(Scalar count) {
		return add(count.longValue());
	}

	public sigeventPointer addOffset(long offset) {
		return sigeventPointer.cast(address + offset);
	}

	public sigeventPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public sigeventPointer sub(long count) {
		return sigeventPointer.cast(address - (sigevent.SIZEOF * count));
	}

	public sigeventPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public sigeventPointer subOffset(long offset) {
		return sigeventPointer.cast(address - offset);
	}

	public sigeventPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public sigeventPointer untag(long mask) {
		return sigeventPointer.cast(address & ~mask);
	}

	public sigeventPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return sigevent.SIZEOF;
	}

	// Implementation methods

	// I32 sigev_notify
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sigev_notifyOffset_", declaredType="I32")
	public IDATA sigev_notify() throws CorruptDataException {
		return new I32(getIntAtOffset(sigevent._sigev_notifyOffset_));
	}

	// I32 sigev_notify
	public IDATAPointer sigev_notifyEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(sigevent._sigev_notifyOffset_));
	}

	// pthread_attr_t* sigev_notify_attributes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sigev_notify_attributesOffset_", declaredType="pthread_attr_t*")
	public PointerPointer sigev_notify_attributes() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(sigevent._sigev_notify_attributesOffset_));
	}

	// pthread_attr_t* sigev_notify_attributes
	public PointerPointer sigev_notify_attributesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sigevent._sigev_notify_attributesOffset_));
	}

	// void* sigev_notify_function
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sigev_notify_functionOffset_", declaredType="void*")
	public VoidPointer sigev_notify_function() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(sigevent._sigev_notify_functionOffset_));
	}

	// void* sigev_notify_function
	public PointerPointer sigev_notify_functionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sigevent._sigev_notify_functionOffset_));
	}

	// I32 sigev_signo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sigev_signoOffset_", declaredType="I32")
	public IDATA sigev_signo() throws CorruptDataException {
		return new I32(getIntAtOffset(sigevent._sigev_signoOffset_));
	}

	// I32 sigev_signo
	public IDATAPointer sigev_signoEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(sigevent._sigev_signoOffset_));
	}

	// sigval sigev_value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sigev_valueOffset_", declaredType="sigval")
	public sigvalPointer sigev_value() throws CorruptDataException {
		return sigvalPointer.cast(nonNullFieldEA(sigevent._sigev_valueOffset_));
	}

	// sigval sigev_value
	public PointerPointer sigev_valueEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(sigevent._sigev_valueOffset_));
	}

}
