/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ucredPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ucredPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ucred.class)
public class ucredPointer extends StructurePointer {

	// NULL
	public static final ucredPointer NULL = new ucredPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ucredPointer(long address) {
		super(address);
	}

	public static ucredPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ucredPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ucredPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ucredPointer(address);
	}

	public ucredPointer add(long count) {
		return ucredPointer.cast(address + (ucred.SIZEOF * count));
	}

	public ucredPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ucredPointer addOffset(long offset) {
		return ucredPointer.cast(address + offset);
	}

	public ucredPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ucredPointer sub(long count) {
		return ucredPointer.cast(address - (ucred.SIZEOF * count));
	}

	public ucredPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ucredPointer subOffset(long offset) {
		return ucredPointer.cast(address - offset);
	}

	public ucredPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ucredPointer untag(long mask) {
		return ucredPointer.cast(address & ~mask);
	}

	public ucredPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ucred.SIZEOF;
	}

	// Implementation methods

	// uid_t cr_acctid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_acctidOffset_", declaredType="uid_t")
	public UDATA cr_acctid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred._cr_acctidOffset_));
	}

	// uid_t cr_acctid
	public UDATAPointer cr_acctidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred._cr_acctidOffset_));
	}

	// priv_t cr_bpriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_bprivOffset_", declaredType="priv_t")
	public privPointer cr_bpriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred._cr_bprivOffset_));
	}

	// priv_t cr_bpriv
	public PointerPointer cr_bprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred._cr_bprivOffset_));
	}

	// I16 cr_caps
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_capsOffset_", declaredType="I16")
	public I16 cr_caps() throws CorruptDataException {
		return new I16(getShortAtOffset(ucred._cr_capsOffset_));
	}

	// I16 cr_caps
	public I16Pointer cr_capsEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(ucred._cr_capsOffset_));
	}

	// priv_t cr_epriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_eprivOffset_", declaredType="priv_t")
	public privPointer cr_epriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred._cr_eprivOffset_));
	}

	// priv_t cr_epriv
	public PointerPointer cr_eprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred._cr_eprivOffset_));
	}

	// gid_t cr_gid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_gidOffset_", declaredType="gid_t")
	public UDATA cr_gid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred._cr_gidOffset_));
	}

	// gid_t cr_gid
	public UDATAPointer cr_gidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred._cr_gidOffset_));
	}

	// groupset_t cr_groupset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_groupsetOffset_", declaredType="groupset_t")
	public groupsetPointer cr_groupset() throws CorruptDataException {
		return groupsetPointer.cast(nonNullFieldEA(ucred._cr_groupsetOffset_));
	}

	// groupset_t cr_groupset
	public PointerPointer cr_groupsetEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred._cr_groupsetOffset_));
	}

	// priv_t cr_ipriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_iprivOffset_", declaredType="priv_t")
	public privPointer cr_ipriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred._cr_iprivOffset_));
	}

	// priv_t cr_ipriv
	public PointerPointer cr_iprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred._cr_iprivOffset_));
	}

	// uid_t cr_luid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_luidOffset_", declaredType="uid_t")
	public UDATA cr_luid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred._cr_luidOffset_));
	}

	// uid_t cr_luid
	public UDATAPointer cr_luidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred._cr_luidOffset_));
	}

	// priv_t cr_mpriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_mprivOffset_", declaredType="priv_t")
	public privPointer cr_mpriv() throws CorruptDataException {
		return privPointer.cast(nonNullFieldEA(ucred._cr_mprivOffset_));
	}

	// priv_t cr_mpriv
	public PointerPointer cr_mprivEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucred._cr_mprivOffset_));
	}

	// I16 cr_ngrps
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_ngrpsOffset_", declaredType="I16")
	public I16 cr_ngrps() throws CorruptDataException {
		return new I16(getShortAtOffset(ucred._cr_ngrpsOffset_));
	}

	// I16 cr_ngrps
	public I16Pointer cr_ngrpsEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(ucred._cr_ngrpsOffset_));
	}

	// I32 cr_pag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_pagOffset_", declaredType="I32")
	public IDATA cr_pag() throws CorruptDataException {
		return new I32(getIntAtOffset(ucred._cr_pagOffset_));
	}

	// I32 cr_pag
	public IDATAPointer cr_pagEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucred._cr_pagOffset_));
	}

	// I32 cr_ref
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_refOffset_", declaredType="I32")
	public IDATA cr_ref() throws CorruptDataException {
		return new I32(getIntAtOffset(ucred._cr_refOffset_));
	}

	// I32 cr_ref
	public IDATAPointer cr_refEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucred._cr_refOffset_));
	}

	// gid_t cr_rgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_rgidOffset_", declaredType="gid_t")
	public UDATA cr_rgid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred._cr_rgidOffset_));
	}

	// gid_t cr_rgid
	public UDATAPointer cr_rgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred._cr_rgidOffset_));
	}

	// uid_t cr_ruid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_ruidOffset_", declaredType="uid_t")
	public UDATA cr_ruid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred._cr_ruidOffset_));
	}

	// uid_t cr_ruid
	public UDATAPointer cr_ruidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred._cr_ruidOffset_));
	}

	// gid_t cr_sgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_sgidOffset_", declaredType="gid_t")
	public UDATA cr_sgid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred._cr_sgidOffset_));
	}

	// gid_t cr_sgid
	public UDATAPointer cr_sgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred._cr_sgidOffset_));
	}

	// uid_t cr_suid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_suidOffset_", declaredType="uid_t")
	public UDATA cr_suid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred._cr_suidOffset_));
	}

	// uid_t cr_suid
	public UDATAPointer cr_suidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred._cr_suidOffset_));
	}

	// uid_t cr_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cr_uidOffset_", declaredType="uid_t")
	public UDATA cr_uid() throws CorruptDataException {
		return new U32(getIntAtOffset(ucred._cr_uidOffset_));
	}

	// uid_t cr_uid
	public UDATAPointer cr_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucred._cr_uidOffset_));
	}

}
