/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: hostent_data
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class hostent_data {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __host_reserv1Offset_;
	public static final int __host_reserv2Offset_;
	public static final int _currentOffset_;
	public static final int _currentlenOffset_;
	public static final int _domainOffset_;
	public static final int _h_addr_ptrsOffset_;
	public static final int _host_addrOffset_;
	public static final int _host_addressesOffset_;
	public static final int _host_addrsOffset_;
	public static final int _host_aliasesOffset_;
	public static final int _hostaddrOffset_;
	public static final int _hostbufOffset_;
	public static final int _hostfOffset_;
	public static final int _stayopenOffset_;
	public static final int _this_serviceOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__host_reserv1Offset_ = 0;
		__host_reserv2Offset_ = 0;
		_currentOffset_ = 0;
		_currentlenOffset_ = 0;
		_domainOffset_ = 0;
		_h_addr_ptrsOffset_ = 0;
		_host_addrOffset_ = 0;
		_host_addressesOffset_ = 0;
		_host_addrsOffset_ = 0;
		_host_aliasesOffset_ = 0;
		_hostaddrOffset_ = 0;
		_hostbufOffset_ = 0;
		_hostfOffset_ = 0;
		_stayopenOffset_ = 0;
		_this_serviceOffset_ = 0;
	}

}
