/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_ObjectEnqueuedForFinalizingEventPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_ObjectEnqueuedForFinalizingEventPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_ObjectEnqueuedForFinalizingEvent.class)
public class MM_ObjectEnqueuedForFinalizingEventPointer extends StructurePointer {

	// NULL
	public static final MM_ObjectEnqueuedForFinalizingEventPointer NULL = new MM_ObjectEnqueuedForFinalizingEventPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_ObjectEnqueuedForFinalizingEventPointer(long address) {
		super(address);
	}

	public static MM_ObjectEnqueuedForFinalizingEventPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_ObjectEnqueuedForFinalizingEventPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_ObjectEnqueuedForFinalizingEventPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_ObjectEnqueuedForFinalizingEventPointer(address);
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer add(long count) {
		return MM_ObjectEnqueuedForFinalizingEventPointer.cast(address + (MM_ObjectEnqueuedForFinalizingEvent.SIZEOF * count));
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer addOffset(long offset) {
		return MM_ObjectEnqueuedForFinalizingEventPointer.cast(address + offset);
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer sub(long count) {
		return MM_ObjectEnqueuedForFinalizingEventPointer.cast(address - (MM_ObjectEnqueuedForFinalizingEvent.SIZEOF * count));
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer subOffset(long offset) {
		return MM_ObjectEnqueuedForFinalizingEventPointer.cast(address - offset);
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer untag(long mask) {
		return MM_ObjectEnqueuedForFinalizingEventPointer.cast(address & ~mask);
	}

	public MM_ObjectEnqueuedForFinalizingEventPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_ObjectEnqueuedForFinalizingEvent.SIZEOF;
	}

	// Implementation methods

	// OMR_VM* OMR_VM
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OMR_VMOffset_", declaredType="OMR_VM*")
	public OMR_VMPointer OMR_VM() throws CorruptDataException {
		return OMR_VMPointer.cast(getPointerAtOffset(MM_ObjectEnqueuedForFinalizingEvent._OMR_VMOffset_));
	}

	// OMR_VM* OMR_VM
	public PointerPointer OMR_VMEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ObjectEnqueuedForFinalizingEvent._OMR_VMOffset_));
	}

	// OMR_VMThread* currentThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_currentThreadOffset_", declaredType="OMR_VMThread*")
	public OMR_VMThreadPointer currentThread() throws CorruptDataException {
		return OMR_VMThreadPointer.cast(getPointerAtOffset(MM_ObjectEnqueuedForFinalizingEvent._currentThreadOffset_));
	}

	// OMR_VMThread* currentThread
	public PointerPointer currentThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ObjectEnqueuedForFinalizingEvent._currentThreadOffset_));
	}

	// U64 eventid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_eventidOffset_", declaredType="U64")
	public UDATA eventid() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectEnqueuedForFinalizingEvent._eventidOffset_));
	}

	// U64 eventid
	public UDATAPointer eventidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectEnqueuedForFinalizingEvent._eventidOffset_));
	}

	// U64 finalizerJob
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_finalizerJobOffset_", declaredType="U64")
	public UDATA finalizerJob() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectEnqueuedForFinalizingEvent._finalizerJobOffset_));
	}

	// U64 finalizerJob
	public UDATAPointer finalizerJobEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectEnqueuedForFinalizingEvent._finalizerJobOffset_));
	}

	// GC_FinalizerJob* job
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jobOffset_", declaredType="GC_FinalizerJob*")
	public GC_FinalizerJobPointer job() throws CorruptDataException {
		return GC_FinalizerJobPointer.cast(getPointerAtOffset(MM_ObjectEnqueuedForFinalizingEvent._jobOffset_));
	}

	// GC_FinalizerJob* job
	public PointerPointer jobEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ObjectEnqueuedForFinalizingEvent._jobOffset_));
	}

	// U64 timestamp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timestampOffset_", declaredType="U64")
	public UDATA timestamp() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectEnqueuedForFinalizingEvent._timestampOffset_));
	}

	// U64 timestamp
	public UDATAPointer timestampEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectEnqueuedForFinalizingEvent._timestampOffset_));
	}

}
