/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __LC_localePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __LC_localePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__LC_locale.class)
public class __LC_localePointer extends StructurePointer {

	// NULL
	public static final __LC_localePointer NULL = new __LC_localePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __LC_localePointer(long address) {
		super(address);
	}

	public static __LC_localePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __LC_localePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __LC_localePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __LC_localePointer(address);
	}

	public __LC_localePointer add(long count) {
		return __LC_localePointer.cast(address + (__LC_locale.SIZEOF * count));
	}

	public __LC_localePointer add(Scalar count) {
		return add(count.longValue());
	}

	public __LC_localePointer addOffset(long offset) {
		return __LC_localePointer.cast(address + offset);
	}

	public __LC_localePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __LC_localePointer sub(long count) {
		return __LC_localePointer.cast(address - (__LC_locale.SIZEOF * count));
	}

	public __LC_localePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __LC_localePointer subOffset(long offset) {
		return __LC_localePointer.cast(address - offset);
	}

	public __LC_localePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __LC_localePointer untag(long mask) {
		return __LC_localePointer.cast(address & ~mask);
	}

	public __LC_localePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __LC_locale.SIZEOF;
	}

	// Implementation methods

	// void* __data_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data_ptrOffset_", declaredType="void*")
	public VoidPointer __data_ptr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(__LC_locale.___data_ptrOffset_));
	}

	// void* __data_ptr
	public PointerPointer __data_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale.___data_ptrOffset_));
	}

	// void* __meth_ptr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___meth_ptrOffset_", declaredType="void*")
	public VoidPointer __meth_ptr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(__LC_locale.___meth_ptrOffset_));
	}

	// void* __meth_ptr
	public PointerPointer __meth_ptrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale.___meth_ptrOffset_));
	}

	// U8* __nl_crncystr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___nl_crncystrOffset_", declaredType="U8*")
	public U8Pointer __nl_crncystr() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(__LC_locale.___nl_crncystrOffset_));
	}

	// U8* __nl_crncystr
	public PointerPointer __nl_crncystrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale.___nl_crncystrOffset_));
	}

	// U8* __nl_nostr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___nl_nostrOffset_", declaredType="U8*")
	public U8Pointer __nl_nostr() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(__LC_locale.___nl_nostrOffset_));
	}

	// U8* __nl_nostr
	public PointerPointer __nl_nostrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale.___nl_nostrOffset_));
	}

	// U8* __nl_yesstr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___nl_yesstrOffset_", declaredType="U8*")
	public U8Pointer __nl_yesstr() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(__LC_locale.___nl_yesstrOffset_));
	}

	// U8* __nl_yesstr
	public PointerPointer __nl_yesstrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale.___nl_yesstrOffset_));
	}

	// _LC_core_locale_t core
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_coreOffset_", declaredType="_LC_core_locale_t")
	public _LC_core_locale_tPointer core() throws CorruptDataException {
		return _LC_core_locale_tPointer.cast(nonNullFieldEA(__LC_locale._coreOffset_));
	}

	// _LC_core_locale_t core
	public PointerPointer coreEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._coreOffset_));
	}

	// _LC_charmap_objhdl_t lc_charmap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_charmapOffset_", declaredType="_LC_charmap_objhdl_t")
	public _LC_charmap_objhdlPointer lc_charmap() throws CorruptDataException {
		return _LC_charmap_objhdlPointer.cast(nonNullFieldEA(__LC_locale._lc_charmapOffset_));
	}

	// _LC_charmap_objhdl_t lc_charmap
	public PointerPointer lc_charmapEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._lc_charmapOffset_));
	}

	// _LC_collate_objhdl_t lc_collate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_collateOffset_", declaredType="_LC_collate_objhdl_t")
	public _LC_collate_objhdlPointer lc_collate() throws CorruptDataException {
		return _LC_collate_objhdlPointer.cast(nonNullFieldEA(__LC_locale._lc_collateOffset_));
	}

	// _LC_collate_objhdl_t lc_collate
	public PointerPointer lc_collateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._lc_collateOffset_));
	}

	// _LC_ctype_objhdl_t lc_ctype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_ctypeOffset_", declaredType="_LC_ctype_objhdl_t")
	public _LC_ctype_objhdlPointer lc_ctype() throws CorruptDataException {
		return _LC_ctype_objhdlPointer.cast(nonNullFieldEA(__LC_locale._lc_ctypeOffset_));
	}

	// _LC_ctype_objhdl_t lc_ctype
	public PointerPointer lc_ctypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._lc_ctypeOffset_));
	}

	// _LC_monetary_objhdl_t lc_monetary
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_monetaryOffset_", declaredType="_LC_monetary_objhdl_t")
	public _LC_monetary_objhdlPointer lc_monetary() throws CorruptDataException {
		return _LC_monetary_objhdlPointer.cast(nonNullFieldEA(__LC_locale._lc_monetaryOffset_));
	}

	// _LC_monetary_objhdl_t lc_monetary
	public PointerPointer lc_monetaryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._lc_monetaryOffset_));
	}

	// _LC_numeric_objhdl_t lc_numeric
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_numericOffset_", declaredType="_LC_numeric_objhdl_t")
	public _LC_numeric_objhdlPointer lc_numeric() throws CorruptDataException {
		return _LC_numeric_objhdlPointer.cast(nonNullFieldEA(__LC_locale._lc_numericOffset_));
	}

	// _LC_numeric_objhdl_t lc_numeric
	public PointerPointer lc_numericEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._lc_numericOffset_));
	}

	// _LC_resp_objhdl_t lc_resp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_respOffset_", declaredType="_LC_resp_objhdl_t")
	public _LC_resp_objhdlPointer lc_resp() throws CorruptDataException {
		return _LC_resp_objhdlPointer.cast(nonNullFieldEA(__LC_locale._lc_respOffset_));
	}

	// _LC_resp_objhdl_t lc_resp
	public PointerPointer lc_respEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._lc_respOffset_));
	}

	// _LC_time_objhdl_t lc_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_timeOffset_", declaredType="_LC_time_objhdl_t")
	public _LC_time_objhdlPointer lc_time() throws CorruptDataException {
		return _LC_time_objhdlPointer.cast(nonNullFieldEA(__LC_locale._lc_timeOffset_));
	}

	// _LC_time_objhdl_t lc_time
	public PointerPointer lc_timeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._lc_timeOffset_));
	}

	// __LC_locale* loc_rec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_loc_recOffset_", declaredType="__LC_locale*")
	public __LC_localePointer loc_rec() throws CorruptDataException {
		return __LC_localePointer.cast(getPointerAtOffset(__LC_locale._loc_recOffset_));
	}

	// __LC_locale* loc_rec
	public PointerPointer loc_recEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._loc_recOffset_));
	}

	// U8*[] nl_info
	public PointerPointer nl_infoEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._nl_infoOffset_));
	}

	// lconv* nl_lconv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nl_lconvOffset_", declaredType="lconv*")
	public lconvPointer nl_lconv() throws CorruptDataException {
		return lconvPointer.cast(getPointerAtOffset(__LC_locale._nl_lconvOffset_));
	}

	// lconv* nl_lconv
	public PointerPointer nl_lconvEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__LC_locale._nl_lconvOffset_));
	}

}
