/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __sigcontextPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __sigcontextPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__sigcontext.class)
public class __sigcontextPointer extends StructurePointer {

	// NULL
	public static final __sigcontextPointer NULL = new __sigcontextPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __sigcontextPointer(long address) {
		super(address);
	}

	public static __sigcontextPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __sigcontextPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __sigcontextPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __sigcontextPointer(address);
	}

	public __sigcontextPointer add(long count) {
		return __sigcontextPointer.cast(address + (__sigcontext.SIZEOF * count));
	}

	public __sigcontextPointer add(Scalar count) {
		return add(count.longValue());
	}

	public __sigcontextPointer addOffset(long offset) {
		return __sigcontextPointer.cast(address + offset);
	}

	public __sigcontextPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __sigcontextPointer sub(long count) {
		return __sigcontextPointer.cast(address - (__sigcontext.SIZEOF * count));
	}

	public __sigcontextPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __sigcontextPointer subOffset(long offset) {
		return __sigcontextPointer.cast(address - offset);
	}

	public __sigcontextPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __sigcontextPointer untag(long mask) {
		return __sigcontextPointer.cast(address & ~mask);
	}

	public __sigcontextPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __sigcontext.SIZEOF;
	}

	// Implementation methods

	// __jmpbuf sc_jmpbuf
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_jmpbufOffset_", declaredType="__jmpbuf")
	public __jmpbufPointer sc_jmpbuf() throws CorruptDataException {
		return __jmpbufPointer.cast(nonNullFieldEA(__sigcontext._sc_jmpbufOffset_));
	}

	// __jmpbuf sc_jmpbuf
	public PointerPointer sc_jmpbufEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__sigcontext._sc_jmpbufOffset_));
	}

	// sigset_t sc_mask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_maskOffset_", declaredType="sigset_t")
	public sigset_tPointer sc_mask() throws CorruptDataException {
		return sigset_tPointer.cast(nonNullFieldEA(__sigcontext._sc_maskOffset_));
	}

	// sigset_t sc_mask
	public PointerPointer sc_maskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__sigcontext._sc_maskOffset_));
	}

	// I32 sc_onstack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_onstackOffset_", declaredType="I32")
	public IDATA sc_onstack() throws CorruptDataException {
		return new I32(getIntAtOffset(__sigcontext._sc_onstackOffset_));
	}

	// I32 sc_onstack
	public IDATAPointer sc_onstackEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__sigcontext._sc_onstackOffset_));
	}

	// I32 sc_uerror
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sc_uerrorOffset_", declaredType="I32")
	public IDATA sc_uerror() throws CorruptDataException {
		return new I32(getIntAtOffset(__sigcontext._sc_uerrorOffset_));
	}

	// I32 sc_uerror
	public IDATAPointer sc_uerrorEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__sigcontext._sc_uerrorOffset_));
	}

}
